/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util.featurestore.ops.write_ops;

import io.hops.util.FeaturestoreRestClient;
import io.hops.util.Hops;
import io.hops.util.exceptions.DataframeIsEmpty;
import io.hops.util.exceptions.FeaturegroupDoesNotExistError;
import io.hops.util.exceptions.FeaturegroupUpdateStatsError;
import io.hops.util.exceptions.FeaturestoreNotFound;
import io.hops.util.exceptions.HiveNotEnabled;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.OnlineFeaturestoreNotEnabled;
import io.hops.util.exceptions.OnlineFeaturestorePasswordNotFound;
import io.hops.util.exceptions.OnlineFeaturestoreUserNotFound;
import io.hops.util.exceptions.StorageConnectorDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetDoesNotExistError;
import io.hops.util.exceptions.TrainingDatasetFormatNotSupportedError;
import io.hops.util.featurestore.FeaturestoreHelper;
import io.hops.util.featurestore.dtos.app.FeaturestoreMetadataDTO;
import io.hops.util.featurestore.dtos.jobs.FeaturestoreJobDTO;
import io.hops.util.featurestore.dtos.stats.StatisticsDTO;
import io.hops.util.featurestore.dtos.trainingdataset.TrainingDatasetDTO;
import io.hops.util.featurestore.ops.FeaturestoreOp;
import io.hops.util.featurestore.ops.read_ops.FeaturestoreReadTrainingDataset;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;

public class FeaturestoreUpdateTrainingDatasetStats
extends FeaturestoreOp {
    public FeaturestoreUpdateTrainingDatasetStats(String name) {
        super(name);
    }

    @Override
    public Object read() {
        throw new UnsupportedOperationException("read() is not supported on a write operation");
    }

    @Override
    public void write() throws DataframeIsEmpty, JAXBException, FeaturegroupUpdateStatsError, IOException, FeaturestoreNotFound, TrainingDatasetDoesNotExistError, TrainingDatasetFormatNotSupportedError, JWTNotFoundException, HiveNotEnabled, StorageConnectorDoesNotExistError, OnlineFeaturestoreUserNotFound, OnlineFeaturestorePasswordNotFound, OnlineFeaturestoreNotEnabled, FeaturegroupDoesNotExistError {
        Dataset<Row> sparkDf = new FeaturestoreReadTrainingDataset(this.name).setSpark(this.getSpark()).setFeaturestore(this.featurestore).setVersion(this.version).read();
        StatisticsDTO statisticsDTO = FeaturestoreHelper.computeDataFrameStats(this.name, this.getSpark(), sparkDf, this.featurestore, this.version, this.descriptiveStats, this.featureCorr, this.featureHistograms, this.clusterAnalysis, this.statColumns, this.numBins, this.numClusters, this.corrMethod);
        FeaturestoreMetadataDTO featurestoreMetadataDTO = Hops.getFeaturestoreMetadata().setFeaturestore(this.featurestore).read();
        TrainingDatasetDTO trainingDatasetDTO = FeaturestoreHelper.findTrainingDataset(featurestoreMetadataDTO.getTrainingDatasets(), this.name, this.version);
        FeaturestoreRestClient.updateTrainingDatasetStatsRest(this.groupInputParamsIntoDTO(trainingDatasetDTO, statisticsDTO));
    }

    private TrainingDatasetDTO groupInputParamsIntoDTO(TrainingDatasetDTO trainingDatasetDTO, StatisticsDTO statisticsDTO) {
        if (FeaturestoreHelper.jobNameGetOrDefault(null) != null) {
            this.jobs.add(FeaturestoreHelper.jobNameGetOrDefault(null));
        }
        List<FeaturestoreJobDTO> jobsDTOs = this.jobs.stream().map(jobName -> {
            FeaturestoreJobDTO featurestoreJobDTO = new FeaturestoreJobDTO();
            featurestoreJobDTO.setJobName((String)jobName);
            return featurestoreJobDTO;
        }).collect(Collectors.toList());
        trainingDatasetDTO.setDescriptiveStatistics(statisticsDTO.getDescriptiveStatsDTO());
        trainingDatasetDTO.setFeatureCorrelationMatrix(statisticsDTO.getFeatureCorrelationMatrixDTO());
        trainingDatasetDTO.setFeaturesHistogram(statisticsDTO.getFeatureDistributionsDTO());
        trainingDatasetDTO.setClusterAnalysis(statisticsDTO.getClusterAnalysisDTO());
        trainingDatasetDTO.setJobs(jobsDTOs);
        return trainingDatasetDTO;
    }

    public FeaturestoreUpdateTrainingDatasetStats setName(String name) {
        this.name = name;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setFeaturestore(String featurestore) {
        this.featurestore = featurestore;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setSpark(SparkSession spark) {
        this.spark = spark;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setVersion(int version) {
        this.version = version;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setCorrMethod(String corrMethod) {
        this.corrMethod = corrMethod;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setNumBins(int numBins) {
        this.numBins = numBins;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setNumClusters(int numClusters) {
        this.numClusters = numClusters;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setMode(String mode) {
        this.mode = mode;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setDataframe(Dataset<Row> dataframe) {
        this.dataframe = dataframe;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setDescriptiveStats(Boolean descriptiveStats) {
        this.descriptiveStats = descriptiveStats;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setFeatureCorr(Boolean featureCorr) {
        this.featureCorr = featureCorr;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setFeatureHistograms(Boolean featureHistograms) {
        this.featureHistograms = featureHistograms;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setClusterAnalysis(Boolean clusterAnalysis) {
        this.clusterAnalysis = clusterAnalysis;
        return this;
    }

    public FeaturestoreUpdateTrainingDatasetStats setStatColumns(List<String> statColumns) {
        this.statColumns = statColumns;
        return this;
    }
}

