/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.util.Hops;
import io.hops.util.cloud.Credentials;
import io.hops.util.exceptions.CloudCredentialException;
import io.hops.util.exceptions.HTTPSClientInitializationException;
import io.hops.util.exceptions.JWTNotFoundException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.spark.sql.SparkSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class CredentialsProvider {
    private static final Logger LOG = Logger.getLogger(CredentialsProvider.class.getName());

    private CredentialsProvider() {
    }

    public static Credentials assumeRole() throws CloudCredentialException {
        return CredentialsProvider.assumeRole(null, null, 0);
    }

    public static Credentials assumeRole(String role) throws CloudCredentialException {
        return CredentialsProvider.assumeRole(role, null, 0);
    }

    public static Credentials assumeRole(String role, String roleSessionName, int durationSeconds) throws CloudCredentialException {
        Response response;
        try {
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            if (role != null && !role.isEmpty()) {
                queryParams.put("roleARN", role);
            }
            if (roleSessionName != null && roleSessionName.isEmpty()) {
                queryParams.put("roleSessionName", roleSessionName);
            }
            if (durationSeconds > 0) {
                queryParams.put("durationSeconds", durationSeconds);
            }
            response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "cloud" + "/" + "aws/session-token", "GET", queryParams);
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new CloudCredentialException(e.getMessage());
        }
        LOG.log(Level.FINE, "******* response.getStatusInfo():" + response.getStatusInfo());
        JSONObject jsonObject = CredentialsProvider.getResponse(response);
        Credentials credentials = CredentialsProvider.getCredentialsFromJson(jsonObject);
        CredentialsProvider.setSparkHadoopConf(credentials);
        CredentialsProvider.setSystemProperties(credentials);
        return credentials;
    }

    public static String[] getRoles() throws CloudCredentialException {
        JSONObject roles = CredentialsProvider.getCloudRoles(null);
        JSONArray items = roles.getJSONArray("items");
        String[] cloudRoles = new String[items.length()];
        for (int i = 0; i < items.length(); ++i) {
            JSONObject role = (JSONObject)items.get(i);
            cloudRoles[i] = (String)role.get("cloudRole");
        }
        return cloudRoles;
    }

    public static String getRole(Integer id) throws CloudCredentialException {
        return CredentialsProvider.getCloudRoles(id.toString()).getString("cloudRole");
    }

    public static String getRole() throws CloudCredentialException {
        return CredentialsProvider.getCloudRoles("default").getString("cloudRole");
    }

    private static JSONObject getCloudRoles(String id) throws CloudCredentialException {
        Response response;
        String byId = id == null ? "" : "/" + id;
        try {
            response = Hops.clientWrapper("/project/" + Hops.getProjectId() + "/" + "cloud" + "/" + "role-mappings" + byId, "GET", null);
        }
        catch (HTTPSClientInitializationException | JWTNotFoundException e) {
            throw new CloudCredentialException(e.getMessage());
        }
        LOG.log(Level.FINE, "******* response.getStatusInfo():" + response.getStatusInfo());
        return CredentialsProvider.getResponse(response);
    }

    private static void setSparkHadoopConf(Credentials credentials) {
        if (!System.getenv().containsKey("IS_HOPS_DRIVER")) {
            return;
        }
        SparkSession spark = Hops.findSpark();
        spark.sparkContext().hadoopConfiguration().set("fs.s3a.aws.credentials.provider", "org.apache.hadoop.fs.s3a.TemporaryAWSCredentialsProvider");
        spark.sparkContext().hadoopConfiguration().set("fs.s3a.access.key", credentials.getAccessKeyId());
        spark.sparkContext().hadoopConfiguration().set("fs.s3a.secret.key", credentials.getSecretAccessKey());
        spark.sparkContext().hadoopConfiguration().set("fs.s3a.session.token", credentials.getSessionToken());
    }

    private static void setSystemProperties(Credentials credentials) {
        Hops.setEnv("AWS_ACCESS_KEY_ID", credentials.getAccessKeyId());
        Hops.setEnv("AWS_SECRET_ACCESS_KEY", credentials.getSecretAccessKey());
        Hops.setEnv("AWS_SESSION_TOKEN", credentials.getSessionToken());
    }

    private static Credentials getCredentialsFromJson(JSONObject jsonObject) {
        Credentials credentials = new Credentials();
        if (jsonObject.has("accessKeyId")) {
            credentials.setAccessKeyId(jsonObject.getString("accessKeyId"));
        }
        if (jsonObject.has("secretAccessKey")) {
            credentials.setSecretAccessKey(jsonObject.getString("secretAccessKey"));
        }
        if (jsonObject.has("sessionToken")) {
            credentials.setSessionToken(jsonObject.getString("sessionToken"));
        }
        return credentials;
    }

    private static JSONObject getResponse(Response response) throws CloudCredentialException {
        Response.Status.Family statusFamily = response.getStatusInfo().getFamily();
        if (response.getMediaType() != null && MediaType.APPLICATION_JSON_TYPE.getSubtype().equals(response.getMediaType().getSubtype())) {
            try {
                String responseEntity = (String)response.readEntity(String.class);
                JSONObject content = new JSONObject(responseEntity);
                if (statusFamily == Response.Status.Family.INFORMATIONAL || statusFamily == Response.Status.Family.SUCCESSFUL) {
                    return content;
                }
                String errorMsg = content.getString("errorMsg") + " " + content.getString("usrMsg");
                throw new CloudCredentialException(errorMsg);
            }
            catch (ProcessingException e) {
                throw new CloudCredentialException(e.getMessage() + " Status: " + response.getStatus());
            }
        }
        throw new CloudCredentialException("Cannot Connect To Server. Got status: " + response.getStatus());
    }

    public static class AssumeRoleRequest {
        private String roleArn;
        private String roleSessionName;
        private int durationSeconds;

        private AssumeRoleRequest() {
        }

        public static AssumeRoleRequest builder() {
            return new AssumeRoleRequest();
        }

        public Credentials send() throws CloudCredentialException {
            return CredentialsProvider.assumeRole(this.roleArn, this.roleSessionName, this.durationSeconds);
        }

        public AssumeRoleRequest setRoleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public AssumeRoleRequest setRoleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        public AssumeRoleRequest setDurationSeconds(int durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }
    }
}

