/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import com.google.common.base.Strings;
import io.hops.util.exceptions.ElasticAuthorizationTokenException;
import io.hops.util.exceptions.HTTPSClientInitializationException;
import io.hops.util.exceptions.JWTNotFoundException;
import io.hops.util.exceptions.ProjectException;
import io.hops.util.exceptions.SchemaNotFoundException;
import io.hops.util.exceptions.SecretException;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.avro.Schema;
import org.apache.spark.sql.SparkSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class Hops {
    private static final Logger LOG = Logger.getLogger(Hops.class.getName());
    private static Integer projectId;
    private static String projectName;
    private static String jobName;
    private static String appId;
    private static String jobType;
    private static List<String> brokerEndpointsList;
    private static String brokerEndpoints;
    private static String restEndpoint;
    private static boolean insecure;
    private static String keyStore;
    private static String trustStore;
    private static String keystorePwd;
    private static String truststorePwd;
    private static String elasticEndPoint;
    private static String domainCaTruststore;

    private Hops() {
    }

    private static synchronized void setup() {
        Properties sysProps = System.getProperties();
        if (sysProps.containsKey("hopsworks.job.type") && sysProps.getProperty("hopsworks.job.type").equalsIgnoreCase("spark")) {
            String pwd;
            restEndpoint = sysProps.getProperty("hopsworks.restendpoint");
            insecure = Boolean.parseBoolean(sysProps.getProperty("hopsutil.insecure"));
            projectName = sysProps.getProperty("hopsworks.projectname");
            keyStore = "k_certificate";
            trustStore = "t_certificate";
            projectId = Integer.parseInt(sysProps.getProperty("hopsworks.projectid"));
            keystorePwd = pwd = Hops.getCertPw();
            truststorePwd = pwd;
            jobName = sysProps.getProperty("hopsworks.job.name");
            appId = sysProps.getProperty("hopsworks.job.appid");
            jobType = sysProps.getProperty("hopsworks.job.type");
            elasticEndPoint = sysProps.getProperty("hopsworks.elastic.endpoint");
            domainCaTruststore = sysProps.getProperty("hopsworks.domain.truststore");
            if (sysProps.containsKey("hopsworks.kafka.brokeraddress")) {
                Hops.parseBrokerEndpoints(sysProps.getProperty("hopsworks.kafka.brokeraddress"));
            }
        }
    }

    public static Map<String, Schema> getSchemas(String[] topics) throws JWTNotFoundException, SchemaNotFoundException {
        if (topics == null) {
            throw new IllegalArgumentException("Topics were not provided.");
        }
        HashMap<String, Schema> schemas = new HashMap<String, Schema>();
        for (String topic : topics) {
            Schema.Parser parser = new Schema.Parser();
            schemas.put(topic, parser.parse(Hops.getSchema(topic)));
        }
        return schemas;
    }

    public static String getSchema(String topic) throws JWTNotFoundException, SchemaNotFoundException {
        LOG.log(Level.FINE, "Getting schema for topic:{0}", new String[]{topic});
        JSONObject json = new JSONObject();
        json.append("topicName", (Object)topic);
        Response response = null;
        try {
            response = Hops.clientWrapper(json, "/project/" + projectId + "/kafka/topics/" + topic + "/subjects", "GET", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new SchemaNotFoundException(e.getMessage());
        }
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new SchemaNotFoundException("No schema found for topic:" + topic);
        }
        String responseEntity = (String)response.readEntity(String.class);
        LOG.log(Level.FINE, "responseEntity:" + responseEntity);
        json = new JSONObject(responseEntity);
        return json.getString("schema");
    }

    public static Properties getKafkaSSLProperties() {
        Properties properties = new Properties();
        properties.setProperty("security.protocol", "SSL");
        properties.setProperty("ssl.truststore.location", Hops.getTrustStore());
        properties.setProperty("ssl.truststore.password", Hops.getTruststorePwd());
        properties.setProperty("ssl.keystore.location", Hops.getKeyStore());
        properties.setProperty("ssl.keystore.password", Hops.getKeystorePwd());
        properties.setProperty("ssl.key.password", Hops.getKeystorePwd());
        properties.setProperty("ssl.endpoint.identification.algorithm", "");
        return properties;
    }

    private static JSONObject getProjectInfo(String projectName) throws JWTNotFoundException, ProjectException {
        LOG.log(Level.FINE, "Getting project with name:{0}", new String[]{projectName});
        Response response = null;
        try {
            response = Hops.clientWrapper(null, "/project/getProjectInfo/" + projectName, "GET", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new ProjectException(e.getMessage());
        }
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new ProjectException("No project found named " + projectName);
        }
        String responseEntity = (String)response.readEntity(String.class);
        return new JSONObject(responseEntity);
    }

    public static String getSecret(String name) throws SecretException, JWTNotFoundException {
        return Hops.getSecret(name, null);
    }

    public static String getSecret(String name, String owner) throws JWTNotFoundException, SecretException {
        LOG.log(Level.FINE, "Getting secret with name:{0}", new String[]{name});
        Response response = null;
        try {
            if (Strings.isNullOrEmpty((String)owner)) {
                response = Hops.clientWrapper(null, "/users/secrets/" + name, "GET", null);
            } else {
                HashMap<String, Object> queryParams = new HashMap<String, Object>();
                queryParams.put("name", name);
                queryParams.put("owner", owner);
                response = Hops.clientWrapper(null, "/users/secrets/shared", "GET", queryParams);
            }
        }
        catch (HTTPSClientInitializationException e) {
            throw new SecretException(e.getMessage());
        }
        String responseEntity = (String)response.readEntity(String.class);
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new SecretException(responseEntity);
        }
        JSONArray json = new JSONObject(responseEntity).getJSONArray("items");
        return json.getJSONObject(0).getString("secret");
    }

    public static void createSecret(String name, String secret) throws JWTNotFoundException, ProjectException, SecretException {
        Hops.createSecret(name, secret, null);
    }

    public static void createSecret(String name, String secret, String projectName) throws JWTNotFoundException, ProjectException, SecretException {
        LOG.log(Level.FINE, "Creating secret with name:{0}", new String[]{name});
        JSONObject payload = new JSONObject();
        if (Strings.isNullOrEmpty((String)projectName)) {
            payload.put("visibility", (Object)"PRIVATE");
        } else {
            JSONObject projectInfo = Hops.getProjectInfo(projectName);
            payload.put("scope", projectInfo.getInt("projectId"));
            payload.put("visibility", (Object)"PROJECT");
        }
        payload.put("name", (Object)name);
        payload.put("secret", (Object)secret);
        Response response = null;
        try {
            response = Hops.clientWrapper(payload, "/users/secrets", "POST", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new SecretException(e.getMessage());
        }
        String responseEntity = (String)response.readEntity(String.class);
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new SecretException(responseEntity);
        }
    }

    public static void deleteSecret(String name) throws JWTNotFoundException, SecretException {
        LOG.log(Level.FINE, "Deleting secret with name:{0}", new String[]{name});
        Response response = null;
        try {
            response = Hops.clientWrapper(null, "/users/secrets/" + name, "DELETE", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new SecretException(e.getMessage());
        }
        String responseEntity = (String)response.readEntity(String.class);
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new SecretException(responseEntity);
        }
    }

    protected static Response clientWrapper(String path, String httpMethod, Map<String, Object> queryParams) throws HTTPSClientInitializationException, JWTNotFoundException {
        return Hops.clientWrapper(null, path, httpMethod, queryParams);
    }

    protected static Response clientWrapper(JSONObject json, String path, String httpMethod, Map<String, Object> queryParams) throws HTTPSClientInitializationException, JWTNotFoundException {
        Client client;
        try {
            client = Hops.initClient();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new HTTPSClientInitializationException("Could not retrieve credentials from local working directory", e);
        }
        WebTarget webTarget = client.target(Hops.getRestEndpoint() + "/").path("hopsworks-api/api" + path);
        if (queryParams != null && !queryParams.isEmpty()) {
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                webTarget = webTarget.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        LOG.log(Level.FINE, "webTarget.getUri().getHost():" + webTarget.getUri().getHost());
        LOG.log(Level.FINE, "webTarget.getUri().getPort():" + webTarget.getUri().getPort());
        LOG.log(Level.FINE, "webTarget.getUri().getPath():" + webTarget.getUri().getPath());
        Invocation.Builder invocationBuilder = webTarget.request().header("Authorization", (Object)("Bearer " + Hops.getJwt().orElseThrow(IllegalArgumentException::new))).accept(new String[]{"application/json"});
        switch (httpMethod) {
            case "PUT": {
                if (json == null) {
                    return invocationBuilder.put(Entity.json((Object)""));
                }
                return invocationBuilder.put(Entity.entity((Object)json.toString(), (String)"application/json"));
            }
            case "POST": {
                if (json == null) {
                    return invocationBuilder.post(Entity.json((Object)""));
                }
                return invocationBuilder.post(Entity.entity((Object)json.toString(), (String)"application/json"));
            }
            case "GET": {
                return invocationBuilder.get();
            }
            case "DELETE": {
                return invocationBuilder.delete();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getCertPw() {
        try (FileInputStream fis = new FileInputStream("material_passwd");){
            int content;
            StringBuilder sb = new StringBuilder();
            while ((content = fis.read()) != -1) {
                sb.append((char)content);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Optional<String> getJwt() throws JWTNotFoundException {
        String jwt = null;
        try (FileChannel fc = FileChannel.open(Paths.get("token.jwt", new String[0]), StandardOpenOption.READ);){
            FileLock fileLock = fc.tryLock(0L, Long.MAX_VALUE, true);
            try {
                int numRetries = 5;
                for (int retries = 0; fileLock == null && retries < numRetries; retries = (int)((short)(retries + 1))) {
                    LOG.log(Level.FINEST, "Waiting for lock on jwt file at:token.jwt");
                    Thread.sleep(1000L);
                    fileLock = fc.tryLock(0L, Long.MAX_VALUE, true);
                }
                if (fileLock == null) {
                    throw new JWTNotFoundException("Could not read jwt token from local container, possibly another process has acquired the lock");
                }
                ByteBuffer buf = ByteBuffer.allocateDirect(512);
                fc.read(buf);
                buf.flip();
                jwt = StandardCharsets.UTF_8.decode(buf).toString();
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "JWT waiting thread was interrupted.", e);
            }
            finally {
                if (fileLock != null) {
                    fileLock.release();
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not read jwt token from local container.", e);
            throw new JWTNotFoundException("Could not read jwt token from local container." + e.getMessage(), e);
        }
        return Optional.ofNullable(jwt);
    }

    public static List<String> getBrokerEndpointsList() {
        return brokerEndpointsList;
    }

    public static String getBrokerEndpoints() {
        return brokerEndpoints;
    }

    public static Integer getProjectId() {
        return projectId;
    }

    public static String getRestEndpoint() {
        return restEndpoint;
    }

    public static String getKeyStore() {
        return keyStore;
    }

    public static String getTrustStore() {
        return trustStore;
    }

    public static String getKeystorePwd() {
        return keystorePwd;
    }

    public static String getTruststorePwd() {
        return truststorePwd;
    }

    public static String getProjectName() {
        return projectName;
    }

    public static String getElasticEndPoint() {
        return elasticEndPoint;
    }

    public static String getJobName() {
        return jobName;
    }

    public static String getAppId() {
        return appId;
    }

    public static String getJobType() {
        return jobType;
    }

    private static void parseBrokerEndpoints(String addresses) {
        brokerEndpoints = addresses;
        brokerEndpointsList = Arrays.asList(addresses.split(","));
    }

    private static Client initClient() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore truststore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream trustStoreIS = new FileInputStream(domainCaTruststore);){
            truststore.load(trustStoreIS, null);
        }
        return ClientBuilder.newBuilder().trustStore(truststore).hostnameVerifier((HostnameVerifier)InsecureHostnameVerifier.INSTANCE).build();
    }

    public static SparkSession findSpark() {
        return SparkSession.builder().enableHiveSupport().getOrCreate();
    }

    public static String getElasticIndex(String index) {
        return Hops.getProjectName() + "_" + index;
    }

    public static String getElasticAuthorizationToken() throws JWTNotFoundException, ElasticAuthorizationTokenException {
        Response response;
        try {
            response = Hops.clientWrapper("/elastic/jwt/" + Hops.getProjectId(), "GET", null);
        }
        catch (HTTPSClientInitializationException e) {
            throw new ElasticAuthorizationTokenException(e.getMessage());
        }
        String responseEntity = (String)response.readEntity(String.class);
        LOG.log(Level.INFO, "******* response.getStatusInfo():" + response.getStatusInfo());
        if (response.getStatusInfo().getStatusCode() != Response.Status.OK.getStatusCode()) {
            throw new ElasticAuthorizationTokenException(responseEntity);
        }
        JSONObject jsonResponse = new JSONObject(responseEntity);
        if (!jsonResponse.has("token")) {
            throw new ElasticAuthorizationTokenException("Couldn't get authorization token for elastic.");
        }
        String token = jsonResponse.getString("token");
        if (token.isEmpty()) {
            throw new ElasticAuthorizationTokenException("Couldn't get authorization token for elastic.");
        }
        return "Bearer " + token;
    }

    public static Map<String, String> getElasticConfiguration(String index) throws ElasticAuthorizationTokenException, JWTNotFoundException {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("es.net.ssl", "true");
        configs.put("es.nodes.wan.only", "true");
        configs.put("es.nodes", Hops.getElasticEndPoint());
        configs.put("es.net.ssl.keystore.location", Hops.getKeyStore());
        configs.put("es.net.ssl.keystore.pass", Hops.getKeystorePwd());
        configs.put("es.net.ssl.truststore.location", Hops.getTrustStore());
        configs.put("es.net.ssl.truststore.pass", Hops.getTruststorePwd());
        configs.put("es.net.http.header.Authorization", Hops.getElasticAuthorizationToken());
        configs.put("es.resource", Hops.getElasticIndex(index));
        return configs;
    }

    public static void setEnv(String key, String value) {
        try {
            Map<String, String> env = System.getenv();
            Class<?> cl = env.getClass();
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Map writableEnv = (Map)field.get(env);
            writableEnv.put(key, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set environment variable", e);
        }
    }

    static {
        Hops.setup();
    }

    private static class InsecureHostnameVerifier
    implements HostnameVerifier {
        static InsecureHostnameVerifier INSTANCE = new InsecureHostnameVerifier();

        InsecureHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession ssls) {
            return insecure || string.equals(restEndpoint.split(":")[0]);
        }
    }
}

