/*
 * Decompiled with CFR 0.152.
 */
package io.hops.cli.action;

import io.hops.cli.action.HopsworksAction;
import io.hops.cli.config.HopsworksAPIConfig;
import io.hops.upload.net.IFileToHttpEntity;
import io.hops.upload.params.FlowHttpEntityGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Scanner;
import org.apache.commons.lang.SystemUtils;
import org.apache.hadoop.fs.Path;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadAction
extends HopsworksAction {
    private String hopsworksFolder;
    private URI filePath;
    private boolean overwrite = true;
    private String projectId;
    private static final Logger logger = LoggerFactory.getLogger(FileUploadAction.class);

    public FileUploadAction(HopsworksAPIConfig hopsworksAPIConfig, String hopsworksFolder, String filePath) throws URISyntaxException {
        super(hopsworksAPIConfig);
        this.init(hopsworksFolder, filePath);
    }

    public FileUploadAction(HopsworksAPIConfig hopsworksAPIConfig, String hopsworksFolder, String filePath, boolean overwrite) throws URISyntaxException {
        super(hopsworksAPIConfig);
        this.init(hopsworksFolder, filePath);
        this.overwrite = overwrite;
    }

    public FileUploadAction(HopsworksAPIConfig hopsworksAPIConfig, String hopsworksFolder, URI filePath) {
        super(hopsworksAPIConfig);
        this.init(hopsworksFolder, filePath);
    }

    private void init(String hopsworksFolder, String filePath) throws URISyntaxException {
        URI path = SystemUtils.IS_OS_WINDOWS && !filePath.startsWith("file://") ? new URI("file:///" + filePath) : (filePath.startsWith("/") ? new URI("file://" + filePath) : new URI(filePath));
        this.init(hopsworksFolder, path);
    }

    private void init(String hopsworksFolder, URI path) {
        this.hopsworksFolder = hopsworksFolder;
        this.filePath = path;
    }

    @Override
    public int execute() throws Exception {
        int statusCode;
        this.projectId = this.getProjectId();
        if (this.overwrite) {
            // empty if block
        }
        if ((statusCode = this.uploadFile(this.filePath, this.hopsworksFolder, this.hopsworksAPIConfig)) != 200) {
            throw new Exception("HTTP File Upload not successful");
        }
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(String datasetPath, HopsworksAPIConfig apiConfig, String targetFileName) throws IOException {
        String apiUrl = apiConfig.getProjectUrl() + this.projectId + "/dataset/" + datasetPath + "/" + targetFileName;
        try (CloseableHttpClient client = this.getClient();){
            HttpDelete delete = new HttpDelete(apiUrl);
            delete.addHeader("Authorization", "ApiKey " + apiConfig.getApiKey());
            CloseableHttpResponse response = client.execute((HttpUriRequest)delete);
            response.close();
        }
    }

    private int startUploadFile(URI fileUri, String datasetPath, HopsworksAPIConfig apiConfig, String targetFileName) throws IOException {
        String apiUrl = apiConfig.getProjectUrl() + this.projectId + "/dataset/upload/" + datasetPath;
        CloseableHttpClient client = this.getClient();
        HttpPost post = new HttpPost(apiUrl);
        post.addHeader("Authorization", "ApiKey " + apiConfig.getApiKey());
        FlowHttpEntityGenerator entityGenerator = new FlowHttpEntityGenerator();
        entityGenerator.init(fileUri, targetFileName);
        int statusCode = 0;
        long startTime = System.currentTimeMillis();
        while (entityGenerator.hasNext()) {
            statusCode = this.uploadChunk(entityGenerator, post, (HttpClient)client);
            if (200 == statusCode) continue;
            return statusCode;
        }
        long endTime = System.currentTimeMillis();
        logger.info("File Total Upload Time: " + (endTime - startTime) + " milliseconds");
        client.close();
        return statusCode;
    }

    private int uploadFile(URI uri, String datasetPath, HopsworksAPIConfig apiConfig) throws IOException {
        Path path = new Path(uri);
        String targetFileName = path.getName();
        return this.startUploadFile(uri, datasetPath, apiConfig, targetFileName);
    }

    private int uploadChunk(IFileToHttpEntity entityGenerator, HttpPost post, HttpClient client) throws IOException {
        HttpEntity entity = entityGenerator.next();
        post.setEntity(entity);
        logger.info(post.toString());
        HttpResponse response = client.execute((HttpUriRequest)post);
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        InputStream responseContent = response.getEntity().getContent();
        logger.info("API Response ==> " + this.convertStreamToString(responseContent));
        return statusCode;
    }

    private String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

