/*
 * Decompiled with CFR 0.152.
 */
package io.hops.cli.action;

import io.hops.cli.action.HopsworksAction;
import io.hops.cli.config.HopsworksAPIConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class JobAction
extends HopsworksAction {
    protected final String jobName;
    protected String result;
    protected JsonObject jsonResult;

    public JobAction(HopsworksAPIConfig hopsworksAPIConfig, String jobName) {
        super(hopsworksAPIConfig);
        this.jobName = jobName;
    }

    protected void addHeaders(HttpRequestBase request) {
        request.addHeader("User-Agent", "User-Agent");
        request.addHeader("Authorization", "ApiKey " + this.hopsworksAPIConfig.getApiKey());
    }

    protected HttpPost getJobPost(String path) throws IOException {
        HttpPost request = new HttpPost(this.getJobUrl() + "/" + path);
        this.addHeaders((HttpRequestBase)request);
        return request;
    }

    protected HttpPut getJobPut(String path) throws IOException {
        HttpPut request = new HttpPut(this.getJobUrl() + "/" + path);
        this.addHeaders((HttpRequestBase)request);
        return request;
    }

    protected HttpGet getJobGet(String path) throws IOException {
        HttpGet request = new HttpGet(this.getJobUrl() + "/" + path);
        this.addHeaders((HttpRequestBase)request);
        return request;
    }

    public String getJobUrl() throws IOException {
        return this.hopsworksAPIConfig.getProjectUrl() + this.getProjectId() + "/jobs/" + this.jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getResult() {
        return this.result;
    }

    protected void setResult(String result) {
        this.result = result;
    }

    public JsonObject getJsonResult() {
        return this.jsonResult;
    }

    protected void setJsonResult(JsonObject jsonResult) {
        this.jsonResult = jsonResult;
    }

    protected int readJsonResponse(CloseableHttpResponse response) throws IOException {
        String line;
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
        StringBuilder res = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            res.append(line);
        }
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(res.toString()));
        JsonObject body = jsonReader.readObject();
        jsonReader.close();
        response.close();
        this.setResult(res.toString());
        this.setJsonResult(body);
        return response.getStatusLine().getStatusCode();
    }

    protected int getLatestExecution() throws IOException {
        HttpGet request;
        CloseableHttpClient client = this.getClient();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(request = this.getJobGet("/executions?sort_by=appId:desc&limit=1")));
        int status = this.readJsonResponse(response);
        if (status != 200 && status != 201) {
            client.close();
            throw new IOException("Could not get latest execution: " + status);
        }
        JsonArray resultArray = this.getJsonResult().getJsonArray("items");
        if (resultArray == null) {
            return 0;
        }
        JsonObject execution = resultArray.getJsonObject(0);
        client.close();
        response.close();
        return execution.getInt("id");
    }

    public String getJobsOnlyUrl() throws IOException {
        return this.hopsworksAPIConfig.getProjectUrl() + this.getProjectId() + "/jobs/";
    }

    protected JsonObject inspectJobConfig(String jobType, String path) throws IOException {
        path = path.split("hdfs://")[1];
        CloseableHttpClient client = this.getClient();
        HttpGet request = new HttpGet(this.getJobsOnlyUrl() + jobType + "/inspection?path=" + path);
        this.addHeaders((HttpRequestBase)request);
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        int status = this.readJsonResponse(response);
        if (status != 200 && status != 201) {
            client.close();
            throw new IOException("Could not inspect job configuration: " + status);
        }
        return this.getJsonResult();
    }

    protected int getExecutionById(Integer execId) throws IOException {
        HttpGet request;
        CloseableHttpClient client = this.getClient();
        CloseableHttpResponse response = client.execute((HttpUriRequest)(request = this.getJobGet("/executions/" + execId.toString())));
        int status = this.readJsonResponse(response);
        if (status != 200 && status != 201) {
            client.close();
            throw new IOException("Could not get execution id: " + execId + " ; Status :" + status);
        }
        client.close();
        response.close();
        return status;
    }

    public boolean getJobExists() throws IOException {
        HttpGet request;
        CloseableHttpClient getClient = this.getClient();
        CloseableHttpResponse response = getClient.execute((HttpUriRequest)(request = this.getJobGet("")));
        int statusCode = this.readJsonResponse(response);
        return statusCode != 404;
    }
}

