/*
 * Decompiled with CFR 0.152.
 */
package io.hops.cli.action;

import io.hops.cli.action.JobAction;
import io.hops.cli.config.HopsworksAPIConfig;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCreateAction
extends JobAction {
    private static final String SPARK = "SPARK";
    private static final String PYTHON = "PYTHON";
    private static final String FLINK = "FLINK";
    private static final String PYTHON_JOB_CONFIG = "pythonJobConfiguration";
    private static final String FLINK_JOB_CONFIG = "flinkJobConfiguration";
    private static final Logger logger = LoggerFactory.getLogger(JobCreateAction.class);
    private final JsonObject payload;
    private final HopsworksAPIConfig hopsworksAPIConfig;
    private final String jobName;

    public JobCreateAction(HopsworksAPIConfig hopsworksAPIConfig, String jobName) throws IOException {
        this(hopsworksAPIConfig, jobName, new Args());
    }

    public JobCreateAction(HopsworksAPIConfig hopsworksAPIConfig, String jobName, Args args) throws IOException {
        super(hopsworksAPIConfig, jobName);
        this.hopsworksAPIConfig = hopsworksAPIConfig;
        this.jobName = jobName;
        this.payload = this.getJobConfig(args);
    }

    private JsonObject getJobConfig(Args args) throws IOException {
        JsonObject jobConfig = null;
        switch (args.getJobType()) {
            case "SPARK": {
                JsonObject respConfig = this.inspectJobConfig(args.getJobType().toLowerCase(), args.appPath);
                JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
                for (String key : respConfig.keySet()) {
                    objectBuilder.add(key, (JsonValue)respConfig.get((Object)key));
                }
                objectBuilder.add("appPath", args.getAppPath());
                if (!respConfig.containsKey((Object)"mainClass")) {
                    objectBuilder.add("mainClass", args.getMainClass());
                }
                objectBuilder.add("defaultArgs", (JsonValue)Json.createValue((String)args.getCommandArgs()));
                objectBuilder.add("amMemory", (JsonValue)Json.createValue((int)args.getDriverMemInMbs()));
                objectBuilder.add("amVCores", (JsonValue)Json.createValue((int)args.getDriverVC()));
                objectBuilder.add("spark.executor.memory", (JsonValue)Json.createValue((int)args.getExecutorMemInMbs()));
                objectBuilder.add("spark.executor.cores", (JsonValue)Json.createValue((int)args.getExecutorVC()));
                objectBuilder.add("spark.dynamicAllocation.enabled", args.isDynamic());
                objectBuilder.add("spark.executor.instances", (JsonValue)Json.createValue((int)args.getNumExecutors()));
                if (args.isDynamic()) {
                    objectBuilder.add("spark.dynamicAllocation.minExecutors", args.getMinExecutors());
                    objectBuilder.add("spark.dynamicAllocation.maxExecutors", args.getMaxExecutors());
                    objectBuilder.add("spark.dynamicAllocation.initialExecutors", args.getInitExecutors());
                }
                if (args.isAdvanceConfig()) {
                    objectBuilder.add("spark.yarn.dist.archives", args.getArchives());
                    objectBuilder.add("spark.yarn.dist.pyFiles", args.getPythonDependency());
                    objectBuilder.add("spark.yarn.dist.files", args.getFiles());
                    objectBuilder.add("spark.yarn.dist.jars", args.getJars());
                    objectBuilder.add("properties", args.getProperties());
                }
                jobConfig = objectBuilder.build();
                break;
            }
            case "PYTHON": {
                jobConfig = this.getPythonJobConfig(args);
                break;
            }
            case "FLINK": {
                jobConfig = this.getFlinkJobConfig(args);
            }
        }
        return jobConfig;
    }

    public JsonObject getFlinkJobConfig(Args args) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("type", FLINK_JOB_CONFIG).add("amQueue", "default").add("jobmanager.heap.size", args.getJobManagerMemory()).add("amVCores", 1).add("numberOfTaskManagers", args.getNumTaskManager()).add("taskmanager.heap.size", args.getTaskManagerMemory()).add("taskmanager.numberOfTaskSlots", args.getNumSlots()).add("appName", this.jobName).add("properties", args.getProperties());
        return objectBuilder.build();
    }

    public JsonObject getPythonJobConfig(Args args) {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("type", PYTHON_JOB_CONFIG).add("appName", this.jobName).add("memory", args.getPythonMemory()).add("cores", args.getCpusCores()).add("jobType", PYTHON).add("appPath", args.getAppPath()).add("defaultArgs", args.getCommandArgs()).add("files", args.getFiles());
        return objectBuilder.build();
    }

    @Override
    public int execute() throws Exception {
        CloseableHttpClient getClient = this.getClient();
        HttpPut request = new HttpPut(this.getJobUrl());
        request.addHeader("User-Agent", "User-Agent");
        request.addHeader("Authorization", "ApiKey " + this.hopsworksAPIConfig.getApiKey());
        request.setHeader("Accept", "application/json");
        request.setHeader("Content-type", "application/json");
        StringEntity entity = new StringEntity(this.payload.toString());
        request.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = getClient.execute((HttpUriRequest)request);
        int status = this.readJsonResponse(response);
        response.close();
        return status;
    }

    @XmlRootElement
    public static class Args {
        private int numExecutors = 1;
        private int initExecutors = 1;
        private int minExecutors = 1;
        private int maxExecutors;
        private int cpusPerExecutor = 1;
        private int cpusPerDriver = 1;
        private int driverMemInMbs = 2048;
        private int executorMemInMbs = 4096;
        private int gpusPerExecutor = 0;
        private String commandArgs = "";
        private String jvmArgs = "";
        private String[] sparkConf = new String[0];
        private String files = "";
        private String jars = "";
        private String archives = "";
        private String properties = "";
        private String pythonDependency = "";
        private String appPath = "";
        private String mainClass = "";
        private String configType = "";
        private String jobType = "";
        private int driverVC = 1;
        private int executorVC = 1;
        private int cpusCores = 1;
        private int pythonMemory = 2048;
        private int jobManagerMemory = 1024;
        private int numTaskManager = 1;
        private int taskManagerMemory = 1024;
        private int numSlots = 1;
        private boolean isAdvanceConfig = false;
        private boolean isDynamicAllocation = false;

        public int getInitExecutors() {
            return this.initExecutors;
        }

        public void setInitExecutors(int initExecutors) {
            this.initExecutors = initExecutors;
        }

        public int getMinExecutors() {
            return this.minExecutors;
        }

        public void setMinExecutors(int minExecutors) {
            this.minExecutors = minExecutors;
        }

        public int getMaxExecutors() {
            return this.maxExecutors;
        }

        public void setMaxExecutors(int maxExecutors) {
            this.maxExecutors = maxExecutors;
        }

        public boolean isDynamic() {
            return this.isDynamicAllocation;
        }

        public void setDynamic(boolean dynamic) {
            this.isDynamicAllocation = dynamic;
        }

        public int getNumExecutors() {
            return this.numExecutors;
        }

        public void setNumExecutors(int numExecutors) {
            this.numExecutors = numExecutors;
        }

        public int getCpusPerExecutor() {
            return this.cpusPerExecutor;
        }

        public void setCpusPerExecutor(int cpusPerExecutor) {
            this.cpusPerExecutor = cpusPerExecutor;
        }

        public int getCpusPerDriver() {
            return this.cpusPerDriver;
        }

        public void setCpusPerDriver(int cpusPerDriver) {
            this.cpusPerDriver = cpusPerDriver;
        }

        public int getDriverMemInMbs() {
            return this.driverMemInMbs;
        }

        public void setDriverMemInMbs(int driverMemInMbs) {
            this.driverMemInMbs = driverMemInMbs;
        }

        public int getExecutorMemInMbs() {
            return this.executorMemInMbs;
        }

        public void setExecutorMemInMbs(int executorMemInMbs) {
            this.executorMemInMbs = executorMemInMbs;
        }

        public int getGpusPerExecutor() {
            return this.gpusPerExecutor;
        }

        public void setGpusPerExecutor(int gpusPerExecutor) {
            this.gpusPerExecutor = gpusPerExecutor;
        }

        public String getCommandArgs() {
            return this.commandArgs;
        }

        public void setCommandArgs(String commandArgs) {
            this.commandArgs = commandArgs;
        }

        public String getJvmArgs() {
            return this.jvmArgs;
        }

        public void setJvmArgs(String jvmArgs) {
            this.jvmArgs = jvmArgs;
        }

        public String getFiles() {
            return this.files;
        }

        public void setFiles(String files) {
            this.files = files;
        }

        public String getJars() {
            return this.jars;
        }

        public void setJars(String jars) {
            this.jars = jars;
        }

        public String getArchives() {
            return this.archives;
        }

        public void setArchives(String archives) {
            this.archives = archives;
        }

        public String getProperties() {
            return this.properties;
        }

        public void setProperties(String properties) {
            this.properties = properties;
        }

        public String getPythonDependency() {
            return this.pythonDependency;
        }

        public void setPythonDependency(String pythonDependency) {
            this.pythonDependency = pythonDependency;
        }

        public String[] getSparkConf() {
            return this.sparkConf;
        }

        public void setSparkConf(String[] sparkConf) {
            this.sparkConf = sparkConf;
        }

        public int getNumSlots() {
            return this.numSlots;
        }

        public void setNumSlots(int numSlots) {
            this.numSlots = numSlots;
        }

        public String getAppPath() {
            return this.appPath;
        }

        public void setAppPath(String s) {
            this.appPath = s;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public void setMainClass(String s) {
            this.mainClass = s;
        }

        public String getConfigType() {
            return this.configType;
        }

        public void setConfigType(String s) {
            this.configType = s;
        }

        public String getJobType() {
            return this.jobType;
        }

        public void setJobType(String s) {
            this.jobType = s;
        }

        public int getNumTaskManager() {
            return this.numTaskManager;
        }

        public void getNumTaskManager(int numTaskManager) {
            this.numTaskManager = numTaskManager;
        }

        public int getTaskManagerMemory() {
            return this.taskManagerMemory;
        }

        public void setDriverVC(int driverVC) {
            this.driverVC = driverVC;
        }

        public void setExecutorVC(int executorVC) {
            this.executorVC = executorVC;
        }

        public void setCpusCores(int cpusCores) {
            this.cpusCores = cpusCores;
        }

        public void setPythonMemory(int pythonMemory) {
            this.pythonMemory = pythonMemory;
        }

        public void setJobManagerMemory(int jobManagerMemory) {
            this.jobManagerMemory = jobManagerMemory;
        }

        public void setNumTaskManager(int numTaskManager) {
            this.numTaskManager = numTaskManager;
        }

        public int getExecutorVC() {
            return this.executorVC;
        }

        public int getCpusCores() {
            return this.cpusCores;
        }

        public int getPythonMemory() {
            return this.pythonMemory;
        }

        public int getJobManagerMemory() {
            return this.jobManagerMemory;
        }

        public int getDriverVC() {
            return this.driverVC;
        }

        public void setTaskManagerMemory(int taskManagerMemory) {
            this.taskManagerMemory = taskManagerMemory;
        }

        public boolean isAdvanceConfig() {
            return this.isAdvanceConfig;
        }

        public void setAdvanceConfig(boolean advanceConfig) {
            this.isAdvanceConfig = advanceConfig;
        }
    }
}

