/*
 * Decompiled with CFR 0.152.
 */
package io.hops.cli.action;

import io.hops.cli.action.JobAction;
import io.hops.cli.config.HopsworksAPIConfig;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonValue;
import org.apache.http.impl.client.CloseableHttpClient;

public class JobStatusAction
extends JobAction {
    Logger logger = Logger.getLogger(JobStatusAction.class.getName());
    protected String[] jobStatusArr = new String[2];
    private Integer executionId;

    public String[] getJobStatusArr() {
        return this.jobStatusArr;
    }

    private void setJobStatusArr(String[] arr) {
        this.jobStatusArr = arr;
    }

    public Integer getExecutionId() {
        return this.executionId;
    }

    public JobStatusAction(HopsworksAPIConfig hopsworksAPIConfig, String jobName) {
        super(hopsworksAPIConfig, jobName);
    }

    public JobStatusAction(HopsworksAPIConfig hopsworksAPIConfig, String jobName, String executionId) {
        super(hopsworksAPIConfig, jobName);
        if (!executionId.equals("")) {
            try {
                this.executionId = Integer.parseInt(executionId);
            }
            catch (NumberFormatException ex) {
                this.logger.log(Level.INFO, "Not a valid number execution id; Skipped");
            }
        }
    }

    @Override
    public int execute() throws Exception {
        String[] statusArr = new String[2];
        CloseableHttpClient client = this.getClient();
        if (this.executionId == null || this.executionId == 0) {
            this.executionId = this.getLatestExecution();
            JsonArray array = this.getJsonResult().getJsonArray("items");
            if (array != null) {
                statusArr[0] = ((JsonValue)((JsonValue)array.get(0)).asJsonObject().get((Object)"state")).toString();
                statusArr[1] = ((JsonValue)((JsonValue)array.get(0)).asJsonObject().get((Object)"finalStatus")).toString();
            }
        } else {
            this.getExecutionById(this.executionId);
            statusArr[0] = this.getJsonResult().getString("state");
            statusArr[1] = this.getJsonResult().getString("finalStatus");
        }
        if (statusArr != null) {
            this.setJobStatusArr(statusArr);
            return 0;
        }
        return 1;
    }
}

