/*
 * Decompiled with CFR 0.152.
 */
package io.hops.upload.params;

import io.hops.upload.net.FileReader;
import io.hops.upload.net.IFileToHttpEntity;
import io.hops.upload.params.FlowParameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.NoSuchElementException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowHttpEntityGenerator
implements IFileToHttpEntity {
    private FlowParameter parameter;
    FileReader fileReader;
    private final long FLOW_STANDARD_CHUNK_SIZE = 0x4000000L;
    private long sizeLastChunk;
    private static final Logger logger = LoggerFactory.getLogger(FileReader.class);

    private long calculateSizeLastChunk(long chunkSize, long fileSize) {
        long lastChunk = fileSize % chunkSize;
        return lastChunk;
    }

    private long calculateTotalChunks(long chunkSize, long fileSize) {
        long chunks = fileSize / chunkSize;
        if (chunks == 0L) {
            chunks = 1L;
        }
        return chunks;
    }

    @Override
    public void init(URI uri, String fileName) throws IOException {
        String filePath = uri.toURL().getPath();
        logger.info("FileName: " + fileName);
        this.fileReader = new FileReader();
        long fileSize = this.fileReader.open(filePath);
        this.parameter = new FlowParameter();
        this.parameter.setFlowChunkNumber(1L);
        this.parameter.setFlowChunkSize(this.FLOW_STANDARD_CHUNK_SIZE);
        this.parameter.setFlowCurrentChunkSize(this.FLOW_STANDARD_CHUNK_SIZE);
        this.parameter.setFlowTotalSize(fileSize);
        String flowIdentifier = fileSize + "-" + fileName.replaceAll("[^0-9A-Za-z_-]", "");
        this.parameter.setFlowIdentifier(flowIdentifier);
        this.parameter.setFlowFilename(fileName);
        this.parameter.setFlowRelativePath(fileName);
        long totalChunks = this.calculateTotalChunks(this.FLOW_STANDARD_CHUNK_SIZE, fileSize);
        logger.info("Total File Chunks:" + totalChunks);
        this.sizeLastChunk = this.calculateSizeLastChunk(this.FLOW_STANDARD_CHUNK_SIZE, fileSize);
        logger.info("Last Chunk Size:" + this.sizeLastChunk);
        this.parameter.setFlowTotalChunks(totalChunks);
    }

    private void addFlowParameter(MultipartEntityBuilder builder) {
        builder.addTextBody("templateId", "-1", ContentType.TEXT_PLAIN);
        builder.addTextBody("flowChunkNumber", this.parameter.getFlowChunkNumber() + "", ContentType.TEXT_PLAIN);
        builder.addTextBody("flowChunkSize", this.parameter.getFlowChunkSize() + "", ContentType.TEXT_PLAIN);
        builder.addTextBody("flowCurrentChunkSize", this.parameter.getFlowCurrentChunkSize() + "", ContentType.TEXT_PLAIN);
        builder.addTextBody("flowTotalSize", this.parameter.getFlowTotalSize() + "", ContentType.TEXT_PLAIN);
        builder.addTextBody("flowIdentifier", this.parameter.getFlowIdentifier() + "", ContentType.TEXT_PLAIN);
        builder.addTextBody("flowFilename", this.parameter.getFlowFilename() + "", ContentType.TEXT_PLAIN);
        builder.addTextBody("flowRelativePath", this.parameter.getFlowRelativePath() + "", ContentType.TEXT_PLAIN);
        builder.addTextBody("flowTotalChunks", this.parameter.getFlowTotalChunks() + "", ContentType.TEXT_PLAIN);
    }

    private String toStringHttpEntity(HttpEntity entity) {
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)entity.getContentLength());
        String entityAsString = "";
        try {
            entity.writeTo((OutputStream)out);
            entityAsString = out.toString();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return entityAsString;
    }

    private void increaseChunkNumber() {
        this.parameter.setFlowChunkNumber(this.parameter.getFlowChunkNumber() + 1L);
    }

    @Override
    public HttpEntity next() throws IOException, NoSuchElementException {
        logger.info("File Chunk Number: " + this.parameter.getFlowChunkNumber());
        if (this.parameter.getFlowChunkNumber() > this.parameter.getFlowTotalChunks()) {
            throw new NoSuchElementException();
        }
        int chunkSize = 0;
        chunkSize = (int)this.parameter.getFlowChunkSize();
        if (this.parameter.getFlowChunkNumber() == this.parameter.getFlowTotalChunks()) {
            chunkSize += (int)this.sizeLastChunk;
        }
        if (this.parameter.getFlowTotalSize() < this.parameter.getFlowChunkSize()) {
            chunkSize = (int)this.sizeLastChunk;
        }
        byte[] chunk = this.fileReader.readChunk(chunkSize);
        this.parameter.setFlowCurrentChunkSize(chunkSize);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        this.addFlowParameter(builder);
        builder.addBinaryBody("file", chunk, ContentType.DEFAULT_BINARY, this.parameter.getFlowFilename());
        HttpEntity entity = builder.build();
        this.increaseChunkNumber();
        if (this.parameter.getFlowChunkNumber() > this.parameter.getFlowTotalChunks()) {
            this.fileReader.close();
        }
        return entity;
    }

    @Override
    public boolean hasNext() {
        return this.parameter.getFlowChunkNumber() <= this.parameter.getFlowTotalChunks();
    }
}

