/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.config.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.Strings;
import io.hops.hopsworks.alerting.config.dto.BasicAuth;
import io.hops.hopsworks.alerting.config.dto.TlsConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"basic_auth", "bearer_token", "bearer_token_file", "tls_config", "proxy_url"})
public class HttpConfig {
    @JsonProperty(value="basic_auth")
    private BasicAuth basicAuth;
    @JsonProperty(value="bearer_token")
    private String bearerToken;
    @JsonProperty(value="bearer_token_file")
    private String bearerTokenFile;
    @JsonProperty(value="tls_config")
    private TlsConfig tlsConfig;
    @JsonProperty(value="proxy_url")
    private String proxyUrl;

    @JsonProperty(value="basic_auth")
    public BasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    @JsonProperty(value="basic_auth")
    public void setBasicAuth(BasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    public HttpConfig withBasicAuth(BasicAuth basicAuth) {
        if (!Strings.isNullOrEmpty((String)this.bearerToken) || !Strings.isNullOrEmpty((String)this.bearerTokenFile)) {
            throw new IllegalStateException("`basic_auth`, `bearer_token` and `bearer_token_file` options are mutually exclusive.");
        }
        this.basicAuth = basicAuth;
        return this;
    }

    @JsonProperty(value="bearer_token")
    public String getBearerToken() {
        return this.bearerToken;
    }

    @JsonProperty(value="bearer_token")
    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public HttpConfig withBearerToken(String bearerToken) {
        if (this.basicAuth != null || !Strings.isNullOrEmpty((String)this.bearerTokenFile)) {
            throw new IllegalStateException("`basic_auth`, `bearer_token` and `bearer_token_file` options are mutually exclusive.");
        }
        this.bearerToken = bearerToken;
        return this;
    }

    @JsonProperty(value="bearer_token_file")
    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    @JsonProperty(value="bearer_token_file")
    public void setBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
    }

    public HttpConfig withBearerTokenFile(String bearerTokenFile) {
        if (this.basicAuth != null || !Strings.isNullOrEmpty((String)this.bearerToken)) {
            throw new IllegalStateException("`basic_auth`, `bearer_token` and `bearer_token_file` options are mutually exclusive.");
        }
        this.bearerTokenFile = bearerTokenFile;
        return this;
    }

    @JsonProperty(value="tls_config")
    public TlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    @JsonProperty(value="tls_config")
    public void setTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    public HttpConfig withTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
        return this;
    }

    @JsonProperty(value="proxy_url")
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    @JsonProperty(value="proxy_url")
    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public HttpConfig withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return this;
    }

    public String toString() {
        return "HttpConfig{basicAuth=" + this.basicAuth + ", bearerToken='" + this.bearerToken + '\'' + ", bearerTokenFile='" + this.bearerTokenFile + '\'' + ", tlsConfig='" + this.tlsConfig + '\'' + ", proxyUrl='" + this.proxyUrl + '\'' + '}';
    }
}

