/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.config.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.Strings;
import io.hops.hopsworks.alerting.config.dto.HttpConfig;
import io.hops.hopsworks.alerting.config.dto.Imageconfig;
import io.hops.hopsworks.alerting.config.dto.LinkConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"send_resolved", "routing_key", "service_key", "url", "client", "client_url", "description", "severity", "details", "images", "links", "http_config"})
public class PagerdutyConfig {
    @JsonProperty(value="send_resolved")
    private Boolean sendResolved;
    @JsonProperty(value="routing_key")
    private String routingKey;
    @JsonProperty(value="service_key")
    private String serviceKey;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="client")
    private String client;
    @JsonProperty(value="client_url")
    private String clientUrl;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="severity")
    private String severity;
    @JsonProperty(value="details")
    private Map<String, String> details;
    @JsonProperty(value="images")
    private List<Imageconfig> images;
    @JsonProperty(value="links")
    private List<LinkConfig> links;
    @JsonProperty(value="http_config")
    private HttpConfig httpConfig;

    public PagerdutyConfig() {
    }

    public PagerdutyConfig(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    @JsonProperty(value="service_key")
    public String getServiceKey() {
        return this.serviceKey;
    }

    @JsonProperty(value="service_key")
    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public PagerdutyConfig withServiceKey(String serviceKey) {
        if (!Strings.isNullOrEmpty((String)this.routingKey) && !Strings.isNullOrEmpty((String)serviceKey)) {
            throw new IllegalArgumentException("The two options serviceKey and routingKey are mutually exclusive.");
        }
        this.serviceKey = serviceKey;
        return this;
    }

    @JsonProperty(value="send_resolved")
    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    @JsonProperty(value="send_resolved")
    public void setSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
    }

    public PagerdutyConfig withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return this;
    }

    @JsonProperty(value="routing_key")
    public String getRoutingKey() {
        return this.routingKey;
    }

    @JsonProperty(value="routing_key")
    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public PagerdutyConfig withRoutingKey(String routingKey) {
        if (!Strings.isNullOrEmpty((String)this.serviceKey) && !Strings.isNullOrEmpty((String)routingKey)) {
            throw new IllegalArgumentException("The two options serviceKey and routingKey are mutually exclusive.");
        }
        this.routingKey = routingKey;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public PagerdutyConfig withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="client")
    public String getClient() {
        return this.client;
    }

    @JsonProperty(value="client")
    public void setClient(String client) {
        this.client = client;
    }

    public PagerdutyConfig withClient(String client) {
        this.client = client;
        return this;
    }

    @JsonProperty(value="client_url")
    public String getClientUrl() {
        return this.clientUrl;
    }

    @JsonProperty(value="client_url")
    public void setClientUrl(String clientUrl) {
        this.clientUrl = clientUrl;
    }

    public PagerdutyConfig withClientUrl(String clientUrl) {
        this.clientUrl = clientUrl;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public PagerdutyConfig withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="severity")
    public String getSeverity() {
        return this.severity;
    }

    @JsonProperty(value="severity")
    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public PagerdutyConfig withSeverity(String severity) {
        this.severity = severity;
        return this;
    }

    @JsonProperty(value="details")
    public Map<String, String> getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public PagerdutyConfig withDetails(Map<String, String> details) {
        this.details = details;
        return this;
    }

    @JsonProperty(value="images")
    public List<Imageconfig> getImages() {
        return this.images;
    }

    @JsonProperty(value="images")
    public void setImages(List<Imageconfig> images) {
        this.images = images;
    }

    public PagerdutyConfig withImages(List<Imageconfig> images) {
        this.images = images;
        return this;
    }

    @JsonProperty(value="links")
    public List<LinkConfig> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<LinkConfig> links) {
        this.links = links;
    }

    public PagerdutyConfig withLinks(List<LinkConfig> links) {
        this.links = links;
        return this;
    }

    @JsonProperty(value="http_config")
    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    @JsonProperty(value="http_config")
    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public PagerdutyConfig withHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagerdutyConfig that = (PagerdutyConfig)o;
        return Objects.equals(this.routingKey, that.routingKey) && Objects.equals(this.serviceKey, that.serviceKey) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.routingKey, this.serviceKey, this.url);
    }

    public String toString() {
        return "PagerdutyConfig{sendResolved=" + this.sendResolved + ", routingKey='" + this.routingKey + '\'' + ", serviceKey='" + this.serviceKey + '\'' + ", url='" + this.url + '\'' + ", client='" + this.client + '\'' + ", clientUrl='" + this.clientUrl + '\'' + ", description='" + this.description + '\'' + ", severity='" + this.severity + '\'' + ", details=" + this.details + ", images=" + this.images + ", links=" + this.links + ", httpConfig=" + this.httpConfig + '}';
    }
}

