/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.config.dto;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Strings;
import io.hops.hopsworks.alerting.config.dto.BasicAuth;
import io.hops.hopsworks.alerting.config.dto.TlsConfig;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HttpConfig {
    @JsonAlias(value={"basic_auth"})
    private BasicAuth basicAuth;
    @JsonAlias(value={"bearer_token"})
    private String bearerToken;
    @JsonAlias(value={"bearer_token_file"})
    private String bearerTokenFile;
    @JsonAlias(value={"tls_config"})
    private TlsConfig tlsConfig;
    @JsonAlias(value={"proxy_url"})
    private String proxyUrl;

    public BasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(BasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    public HttpConfig withBasicAuth(BasicAuth basicAuth) {
        if (!Strings.isNullOrEmpty((String)this.bearerToken) || !Strings.isNullOrEmpty((String)this.bearerTokenFile)) {
            throw new IllegalStateException("`basic_auth`, `bearer_token` and `bearer_token_file` options are mutually exclusive.");
        }
        this.basicAuth = basicAuth;
        return this;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public HttpConfig withBearerToken(String bearerToken) {
        if (this.basicAuth != null || !Strings.isNullOrEmpty((String)this.bearerTokenFile)) {
            throw new IllegalStateException("`basic_auth`, `bearer_token` and `bearer_token_file` options are mutually exclusive.");
        }
        this.bearerToken = bearerToken;
        return this;
    }

    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public void setBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
    }

    public HttpConfig withBearerTokenFile(String bearerTokenFile) {
        if (this.basicAuth != null || !Strings.isNullOrEmpty((String)this.bearerToken)) {
            throw new IllegalStateException("`basic_auth`, `bearer_token` and `bearer_token_file` options are mutually exclusive.");
        }
        this.bearerTokenFile = bearerTokenFile;
        return this;
    }

    public TlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public void setTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    public HttpConfig withTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
        return this;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public HttpConfig withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return this;
    }

    public String toString() {
        return "HttpConfig{basicAuth=" + this.basicAuth + ", bearerToken='" + this.bearerToken + '\'' + ", bearerTokenFile='" + this.bearerTokenFile + '\'' + ", tlsConfig='" + this.tlsConfig + '\'' + ", proxyUrl='" + this.proxyUrl + '\'' + '}';
    }
}

