/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.api.util;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.Builder;
import com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.UriBuilder;

public class Settings {
    public static final String MANAGEMENT_API_HEALTH = "/-/healthy";
    public static final String MANAGEMENT_API_READY = "/-/ready";
    public static final String MANAGEMENT_API_RELOAD = "/-/reload";
    public static final String ALERTS_API_STATUS = "/api/v2/status";
    public static final String ALERTS_API_RECEIVERS = "/api/v2/receivers";
    public static final String ALERTS_API_SILENCES = "/api/v2/silences";
    public static final String ALERTS_API_SILENCE = "/api/v2/silence";
    public static final String ALERTS_API_ALERTS = "/api/v2/alerts";
    public static final String ALERTS_API_ALERTS_GROUPS = "/api/v2/alerts/groups";
    public static final String DEFAULT_SERVICE_DISCOVERY_DOMAIN = "consul";
    public static final String DEFAULT_ALERTMANAGER_FQDN = "alertmanager.prometheus.service.consul";
    private static final ConcurrentHashMap<String, URI> alertManagerAddresses = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<Service> getAlertManagerService(String serviceFQDN) throws ServiceDiscoveryException {
        Optional<Service> services;
        try (ServiceDiscoveryClient client = null;){
            client = new Builder(Type.DNS).build();
            String name = Strings.isNullOrEmpty((String)serviceFQDN) ? DEFAULT_ALERTMANAGER_FQDN : serviceFQDN;
            services = client.getService(ServiceQuery.of((String)name, Collections.emptySet())).findFirst();
        }
        return services;
    }

    public static URI getAlertManagerAddress(String serviceFQDN, String scheme) throws ServiceDiscoveryException {
        String string = serviceFQDN = Strings.isNullOrEmpty((String)serviceFQDN) ? DEFAULT_ALERTMANAGER_FQDN : serviceFQDN;
        if (alertManagerAddresses.get(serviceFQDN) == null) {
            Optional<Service> optionalService = Settings.getAlertManagerService(serviceFQDN);
            Service service = optionalService.orElseThrow(() -> new ServiceDiscoveryException("Service not found."));
            UriBuilder uriBuilder = UriBuilder.fromPath((String)"").scheme(Strings.isNullOrEmpty((String)scheme) ? "http" : scheme).host(service.getName());
            if (service.getPort() != null && service.getPort() > 0) {
                uriBuilder.port(service.getPort().intValue());
            }
            URI alertManagerAddress = uriBuilder.build(new Object[0]);
            alertManagerAddresses.put(serviceFQDN, alertManagerAddress);
        }
        return alertManagerAddresses.get(serviceFQDN);
    }

    public static URI getAlertManagerAddress() throws ServiceDiscoveryException {
        return Settings.getAlertManagerAddress(null, null);
    }

    public static URI getAlertManagerAddressByFQDN(String serviceFQDN, boolean isHttps) throws ServiceDiscoveryException {
        return Settings.getAlertManagerAddress(serviceFQDN, isHttps ? "https" : null);
    }

    public static URI getAlertManagerAddressByDN(String serviceDiscoveryDomain, boolean isHttps) throws ServiceDiscoveryException {
        String serviceFQDN = DEFAULT_ALERTMANAGER_FQDN;
        if (!Strings.isNullOrEmpty((String)serviceDiscoveryDomain) && !DEFAULT_SERVICE_DISCOVERY_DOMAIN.equals(serviceDiscoveryDomain)) {
            serviceFQDN = DEFAULT_ALERTMANAGER_FQDN.replace(DEFAULT_SERVICE_DISCOVERY_DOMAIN, serviceDiscoveryDomain);
        }
        return Settings.getAlertManagerAddressByFQDN(serviceFQDN, isHttps);
    }

    public static void clearCache() {
        alertManagerAddresses.clear();
    }
}

