/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import io.hops.hopsworks.alerting.api.AlertManagerClient;
import io.hops.hopsworks.alerting.config.dto.AlertManagerConfig;
import io.hops.hopsworks.alerting.config.dto.EmailConfig;
import io.hops.hopsworks.alerting.config.dto.Global;
import io.hops.hopsworks.alerting.config.dto.InhibitRule;
import io.hops.hopsworks.alerting.config.dto.PagerdutyConfig;
import io.hops.hopsworks.alerting.config.dto.Receiver;
import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.alerting.config.dto.SlackConfig;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigFileNotFoundException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigReadException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigUpdateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerDuplicateEntryException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerNoSuchElementException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerResponseException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerServerException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.client.ClientBuilder;

public class AlertManagerConfigController {
    private static final Logger LOGGER = Logger.getLogger(AlertManagerConfigController.class.getName());
    private static final String CONFIG_FILE_PATH = "/srv/hops/alertmanager/alertmanager/alertmanager.yml";
    private final File configFile;
    private AlertManagerClient client;

    private AlertManagerConfigController(File configFile, AlertManagerClient client) {
        this.configFile = configFile;
        this.client = client;
    }

    public void closeClient() {
        this.client.close();
    }

    public AlertManagerConfig read() throws AlertManagerConfigReadException {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            return (AlertManagerConfig)objectMapper.readValue(this.configFile, AlertManagerConfig.class);
        }
        catch (IOException e) {
            throw new AlertManagerConfigReadException("Failed to read configuration file. Error " + e.getMessage());
        }
    }

    public void write(AlertManagerConfig alertManagerConfig) throws AlertManagerConfigUpdateException {
        YAMLFactory yamlFactory = new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)yamlFactory);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
        try {
            objectMapper.writeValue(this.configFile, (Object)alertManagerConfig);
        }
        catch (IOException e) {
            throw new AlertManagerConfigUpdateException("Failed to update configuration file. Error " + e.getMessage());
        }
    }

    public void writeAndReload(AlertManagerConfig alertManagerConfig) throws AlertManagerConfigUpdateException, AlertManagerServerException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfigTmp = this.read();
        this.write(alertManagerConfig);
        try {
            this.client.reload();
        }
        catch (AlertManagerResponseException e) {
            this.write(alertManagerConfigTmp);
            throw new AlertManagerConfigUpdateException("Failed to update AlertManagerConfig. " + e.getMessage(), e);
        }
        catch (AlertManagerServerException se) {
            this.write(alertManagerConfigTmp);
            throw se;
        }
    }

    public Global getGlobal() throws AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        return alertManagerConfig.getGlobal();
    }

    public AlertManagerConfig updateGlobal(Global global) throws AlertManagerConfigReadException {
        this.validate(global);
        AlertManagerConfig alertManagerConfig = this.read();
        alertManagerConfig.setGlobal(global);
        return alertManagerConfig;
    }

    private void validate(Global global) {
        if (global == null) {
            throw new IllegalArgumentException("Global config can not be null.");
        }
    }

    public List<String> getTemplates() throws AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        return alertManagerConfig.getTemplates();
    }

    public AlertManagerConfig updateTemplates(List<String> templates) throws AlertManagerConfigReadException {
        this.validate(templates);
        AlertManagerConfig alertManagerConfig = this.read();
        alertManagerConfig.setTemplates(templates);
        return alertManagerConfig;
    }

    private void validate(List<String> templates) {
        if (templates == null || templates.isEmpty()) {
            throw new IllegalArgumentException("Templates config can not be null or empty.");
        }
    }

    public Route getGlobalRoute() throws AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        return alertManagerConfig.getRoute();
    }

    public AlertManagerConfig updateGlobalRoute(Route route) throws AlertManagerConfigReadException {
        this.validateGlobalRoute(route);
        AlertManagerConfig alertManagerConfig = this.read();
        alertManagerConfig.setRoute(route);
        return alertManagerConfig;
    }

    private void validateGlobalRoute(Route route) {
        if (route == null) {
            throw new IllegalArgumentException("Route config can not be null.");
        }
    }

    public List<InhibitRule> getInhibitRules() throws AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        return alertManagerConfig.getInhibitRules();
    }

    public AlertManagerConfig updateInhibitRules(List<InhibitRule> inhibitRules) throws AlertManagerConfigReadException {
        this.validateInhibitRules(inhibitRules);
        AlertManagerConfig alertManagerConfig = this.read();
        alertManagerConfig.setInhibitRules(inhibitRules);
        return alertManagerConfig;
    }

    private void validateInhibitRules(List<InhibitRule> inhibitRules) {
        if (inhibitRules == null || inhibitRules.isEmpty()) {
            throw new IllegalArgumentException("Inhibit Rules config can not be null or empty.");
        }
    }

    public Receiver getReceiver(String name) throws AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        int index = this.getIndexOfReceiver(alertManagerConfig, name);
        return alertManagerConfig.getReceivers().get(index);
    }

    public AlertManagerConfig addReceiver(Receiver receiver) throws AlertManagerDuplicateEntryException, AlertManagerConfigReadException {
        this.validate(receiver);
        AlertManagerConfig alertManagerConfig = this.read();
        if (alertManagerConfig.getReceivers() == null) {
            alertManagerConfig.setReceivers(new ArrayList<Receiver>());
        }
        if (alertManagerConfig.getReceivers().contains(receiver)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same name already exists.");
        }
        alertManagerConfig.getReceivers().add(receiver);
        return alertManagerConfig;
    }

    public AlertManagerConfig updateReceiver(String name, Receiver receiver) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigReadException {
        this.validate(receiver);
        AlertManagerConfig alertManagerConfig = this.read();
        int index = this.getIndexOfReceiver(alertManagerConfig, name);
        if (!name.equals(receiver.getName()) && alertManagerConfig.getReceivers().contains(receiver)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same name already exists.");
        }
        alertManagerConfig.getReceivers().remove(index);
        alertManagerConfig.getReceivers().add(receiver);
        return alertManagerConfig;
    }

    public AlertManagerConfig addEmailToReceiver(String name, EmailConfig emailConfig) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigReadException {
        this.validate(emailConfig);
        AlertManagerConfig alertManagerConfig = this.read();
        int index = this.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        if (receiverToUpdate.getEmailConfigs() == null) {
            receiverToUpdate.setEmailConfigs(new ArrayList<EmailConfig>());
        }
        if (receiverToUpdate.getEmailConfigs().contains(emailConfig)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same email already exists.");
        }
        receiverToUpdate.getEmailConfigs().add(emailConfig);
        return alertManagerConfig;
    }

    public AlertManagerConfig removeEmailFromReceiver(String name, EmailConfig emailConfig) throws AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        int index = this.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        int n = index = receiverToUpdate.getEmailConfigs() == null ? -1 : receiverToUpdate.getEmailConfigs().indexOf(emailConfig);
        if (index > -1) {
            receiverToUpdate.getEmailConfigs().remove(index);
            return alertManagerConfig;
        }
        return null;
    }

    public AlertManagerConfig addSlackToReceiver(String name, SlackConfig slackConfig) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigReadException {
        this.validate(slackConfig);
        AlertManagerConfig alertManagerConfig = this.read();
        int index = this.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        if (receiverToUpdate.getSlackConfigs() == null) {
            receiverToUpdate.setSlackConfigs(new ArrayList<SlackConfig>());
        }
        if (receiverToUpdate.getSlackConfigs().contains(slackConfig)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same api url and channel already exists.");
        }
        receiverToUpdate.getSlackConfigs().add(slackConfig);
        return alertManagerConfig;
    }

    public AlertManagerConfig removeSlackFromReceiver(String name, SlackConfig slackConfig) throws AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        int index = this.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        int n = index = receiverToUpdate.getSlackConfigs() == null ? -1 : receiverToUpdate.getSlackConfigs().indexOf(slackConfig);
        if (index > -1) {
            receiverToUpdate.getSlackConfigs().remove(index);
            return alertManagerConfig;
        }
        return null;
    }

    public AlertManagerConfig addPagerdutyToReceiver(String name, PagerdutyConfig pagerdutyConfig) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigReadException {
        this.validate(pagerdutyConfig);
        AlertManagerConfig alertManagerConfig = this.read();
        int index = this.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        if (receiverToUpdate.getPagerdutyConfigs() == null) {
            receiverToUpdate.setPagerdutyConfigs(new ArrayList<PagerdutyConfig>());
        }
        if (receiverToUpdate.getPagerdutyConfigs().contains(pagerdutyConfig)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same api url and channel already exists.");
        }
        receiverToUpdate.getPagerdutyConfigs().add(pagerdutyConfig);
        return alertManagerConfig;
    }

    public AlertManagerConfig removePagerdutyFromReceiver(String name, PagerdutyConfig pagerdutyConfig) throws AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        int index = this.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        int n = index = receiverToUpdate.getPagerdutyConfigs() == null ? -1 : receiverToUpdate.getPagerdutyConfigs().indexOf(pagerdutyConfig);
        if (index > -1) {
            receiverToUpdate.getPagerdutyConfigs().remove(index);
            return alertManagerConfig;
        }
        return null;
    }

    public AlertManagerConfig removeReceiver(String name, boolean cascade) throws AlertManagerConfigReadException {
        int index;
        AlertManagerConfig alertManagerConfig = this.read();
        int n = index = alertManagerConfig.getReceivers() == null ? -1 : alertManagerConfig.getReceivers().indexOf(new Receiver(name));
        if (index > -1) {
            alertManagerConfig.getReceivers().remove(index);
            if (cascade) {
                return this.removeRoutes(name, alertManagerConfig);
            }
            return alertManagerConfig;
        }
        return null;
    }

    private AlertManagerConfig removeRoutes(String receiver, AlertManagerConfig alertManagerConfig) {
        ArrayList<Route> routesToDelete = new ArrayList<Route>();
        for (Route route : alertManagerConfig.getRoute().getRoutes()) {
            if (!route.getReceiver().equals(receiver)) continue;
            routesToDelete.add(route);
        }
        if (routesToDelete.size() > 0) {
            alertManagerConfig.getRoute().getRoutes().removeAll(routesToDelete);
        }
        return alertManagerConfig;
    }

    public List<Route> getRoutes() throws AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        return alertManagerConfig.getRoute() == null || alertManagerConfig.getRoute().getRoutes() == null ? Collections.emptyList() : alertManagerConfig.getRoute().getRoutes();
    }

    public Route getRoute(String receiver, Map<String, String> match, Map<String, String> matchRe) throws AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        Route route = new Route(receiver).withMatch(match).withMatchRe(matchRe);
        return this.getRoute(route);
    }

    public Route getRoute(Route route) throws AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read();
        int index = this.getIndexOfRoute(alertManagerConfig, route);
        return alertManagerConfig.getRoute().getRoutes().get(index);
    }

    public AlertManagerConfig addRoute(Route route) throws AlertManagerDuplicateEntryException, AlertManagerConfigReadException, AlertManagerNoSuchElementException {
        this.validate(route);
        AlertManagerConfig alertManagerConfig = this.read();
        this.getIndexOfReceiver(alertManagerConfig, route.getReceiver());
        if (alertManagerConfig.getRoute() == null) {
            alertManagerConfig.setRoute(new Route());
        }
        if (alertManagerConfig.getRoute().getRoutes() == null) {
            alertManagerConfig.getRoute().setRoutes(new ArrayList<Route>());
        }
        if (alertManagerConfig.getRoute().getRoutes().contains(route)) {
            throw new AlertManagerDuplicateEntryException("A route with the same match and receiver name already exists.");
        }
        alertManagerConfig.getRoute().getRoutes().add(route);
        return alertManagerConfig;
    }

    public AlertManagerConfig updateRoute(Route routeToUpdate, Route route) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigReadException {
        this.validate(route);
        AlertManagerConfig alertManagerConfig = this.read();
        this.getIndexOfReceiver(alertManagerConfig, route.getReceiver());
        int index = this.getIndexOfRoute(alertManagerConfig, routeToUpdate);
        if (!routeToUpdate.equals(route) && alertManagerConfig.getRoute().getRoutes().contains(route)) {
            throw new AlertManagerDuplicateEntryException("A route with the same mather and receiver name already exists.");
        }
        alertManagerConfig.getRoute().getRoutes().remove(index);
        alertManagerConfig.getRoute().getRoutes().add(route);
        return alertManagerConfig;
    }

    public AlertManagerConfig removeRoute(Route route) throws AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        int index;
        AlertManagerConfig alertManagerConfig = this.read();
        int n = index = alertManagerConfig.getRoute().getRoutes() == null ? -1 : alertManagerConfig.getRoute().getRoutes().indexOf(route);
        if (index > -1) {
            alertManagerConfig.getRoute().getRoutes().remove(index);
            return alertManagerConfig;
        }
        return null;
    }

    private int getIndexOfReceiver(AlertManagerConfig alertManagerConfig, String name) throws AlertManagerNoSuchElementException {
        int index;
        Receiver receiverToUpdate = new Receiver(name);
        int n = index = alertManagerConfig.getReceivers() == null ? -1 : alertManagerConfig.getReceivers().indexOf(receiverToUpdate);
        if (index < 0) {
            throw new AlertManagerNoSuchElementException("A receiver with the given name was not found. Name=" + name);
        }
        return index;
    }

    private int getIndexOfRoute(AlertManagerConfig alertManagerConfig, Route route) throws AlertManagerNoSuchElementException {
        int index;
        int n = index = alertManagerConfig.getRoute() == null || alertManagerConfig.getRoute().getRoutes() == null ? -1 : alertManagerConfig.getRoute().getRoutes().indexOf(route);
        if (index < 0) {
            throw new AlertManagerNoSuchElementException("A route with the given receiver name was not found. Receiver Name=" + route.getReceiver());
        }
        return index;
    }

    private void validate(Receiver receiver) {
        if (Strings.isNullOrEmpty((String)receiver.getName())) {
            throw new IllegalArgumentException("Receiver name can not be empty.");
        }
        if (!(receiver.getEmailConfigs() != null && !receiver.getEmailConfigs().isEmpty() || receiver.getSlackConfigs() != null && !receiver.getSlackConfigs().isEmpty() || receiver.getOpsgenieConfigs() != null && !receiver.getOpsgenieConfigs().isEmpty() || receiver.getPagerdutyConfigs() != null && !receiver.getPagerdutyConfigs().isEmpty() || receiver.getPushoverConfigs() != null && !receiver.getPushoverConfigs().isEmpty() || receiver.getVictoropsConfigs() != null && !receiver.getVictoropsConfigs().isEmpty() || receiver.getWebhookConfigs() != null && !receiver.getWebhookConfigs().isEmpty() || receiver.getWechatConfigs() != null && !receiver.getWechatConfigs().isEmpty())) {
            throw new IllegalArgumentException("Receiver needs at least one configuration.");
        }
    }

    private void validate(EmailConfig emailConfig) {
        if (Strings.isNullOrEmpty((String)emailConfig.getTo())) {
            throw new IllegalArgumentException("EmailConfig to can not be empty.");
        }
    }

    private void validate(SlackConfig slackConfig) {
        if (Strings.isNullOrEmpty((String)slackConfig.getApiUrl()) || Strings.isNullOrEmpty((String)slackConfig.getChannel())) {
            throw new IllegalArgumentException("SlackConfig api url and channel can not be empty.");
        }
    }

    private void validate(PagerdutyConfig pagerdutyConfig) {
        if (!Strings.isNullOrEmpty((String)pagerdutyConfig.getRoutingKey()) && !Strings.isNullOrEmpty((String)pagerdutyConfig.getServiceKey())) {
            throw new IllegalArgumentException("PagerdutyConfig RoutingKey or ServiceKey must be set.");
        }
    }

    private void validate(Route route) {
        if (Strings.isNullOrEmpty((String)route.getReceiver())) {
            throw new IllegalArgumentException("Route receiver can not be empty.");
        }
        if ((route.getMatch() == null || route.getMatch().isEmpty()) && (route.getMatchRe() == null || route.getMatchRe().isEmpty())) {
            throw new IllegalArgumentException("Route needs to set match or match regex.");
        }
    }

    public static class Builder {
        private String configPath;
        private AlertManagerClient client;

        public Builder withConfigPath(String configPath) {
            this.configPath = configPath;
            return this;
        }

        public Builder withClient(AlertManagerClient client) {
            this.client = client;
            return this;
        }

        private File getConfigFile() throws AlertManagerConfigFileNotFoundException {
            File configFile = Strings.isNullOrEmpty((String)this.configPath) ? new File(AlertManagerConfigController.CONFIG_FILE_PATH) : new File(this.configPath);
            if (!configFile.exists() || !configFile.isFile()) {
                throw new AlertManagerConfigFileNotFoundException("Alertmanager configuration file not found. Path: " + configFile.getPath());
            }
            if (!configFile.canWrite()) {
                throw new AlertManagerConfigFileNotFoundException("Failed to access Alertmanager configuration file. Write permission denied on: " + configFile.getPath());
            }
            return configFile;
        }

        public AlertManagerConfigController build() throws ServiceDiscoveryException, AlertManagerConfigFileNotFoundException {
            File configFile = this.getConfigFile();
            if (this.client == null) {
                this.client = new AlertManagerClient.Builder(ClientBuilder.newClient()).build();
            }
            return new AlertManagerConfigController(configFile, this.client);
        }
    }
}

