/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.config.dto;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Strings;
import io.hops.hopsworks.alerting.config.dto.HttpConfig;
import io.hops.hopsworks.alerting.config.dto.Imageconfig;
import io.hops.hopsworks.alerting.config.dto.LinkConfig;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PagerdutyConfig {
    @JsonAlias(value={"send_resolved"})
    private Boolean sendResolved;
    @JsonAlias(value={"routing_key"})
    private String routingKey;
    @JsonAlias(value={"service_key"})
    private String serviceKey;
    private String url;
    private String client;
    @JsonAlias(value={"client_url"})
    private String clientUrl;
    private String description;
    private String severity;
    private Map<String, String> details;
    private List<Imageconfig> images;
    private List<LinkConfig> links;
    @JsonAlias(value={"http_config"})
    private HttpConfig httpConfig;

    public PagerdutyConfig() {
    }

    public PagerdutyConfig(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public PagerdutyConfig withServiceKey(String serviceKey) {
        if (!Strings.isNullOrEmpty((String)this.routingKey) && !Strings.isNullOrEmpty((String)serviceKey)) {
            throw new IllegalArgumentException("The two options serviceKey and routingKey are mutually exclusive.");
        }
        this.serviceKey = serviceKey;
        return this;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public void setSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
    }

    public PagerdutyConfig withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return this;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public PagerdutyConfig withRoutingKey(String routingKey) {
        if (!Strings.isNullOrEmpty((String)this.serviceKey) && !Strings.isNullOrEmpty((String)routingKey)) {
            throw new IllegalArgumentException("The two options serviceKey and routingKey are mutually exclusive.");
        }
        this.routingKey = routingKey;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public PagerdutyConfig withUrl(String url) {
        this.url = url;
        return this;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public PagerdutyConfig withClient(String client) {
        this.client = client;
        return this;
    }

    public String getClientUrl() {
        return this.clientUrl;
    }

    public void setClientUrl(String clientUrl) {
        this.clientUrl = clientUrl;
    }

    public PagerdutyConfig withClientUrl(String clientUrl) {
        this.clientUrl = clientUrl;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PagerdutyConfig withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public PagerdutyConfig withSeverity(String severity) {
        this.severity = severity;
        return this;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public PagerdutyConfig withDetails(Map<String, String> details) {
        this.details = details;
        return this;
    }

    public List<Imageconfig> getImages() {
        return this.images;
    }

    public void setImages(List<Imageconfig> images) {
        this.images = images;
    }

    public PagerdutyConfig withImages(List<Imageconfig> images) {
        this.images = images;
        return this;
    }

    public List<LinkConfig> getLinks() {
        return this.links;
    }

    public void setLinks(List<LinkConfig> links) {
        this.links = links;
    }

    public PagerdutyConfig withLinks(List<LinkConfig> links) {
        this.links = links;
        return this;
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public PagerdutyConfig withHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PagerdutyConfig that = (PagerdutyConfig)o;
        return Objects.equals(this.routingKey, that.routingKey) && Objects.equals(this.serviceKey, that.serviceKey) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.routingKey, this.serviceKey, this.url);
    }

    public String toString() {
        return "PagerdutyConfig{sendResolved=" + this.sendResolved + ", routingKey='" + this.routingKey + '\'' + ", serviceKey='" + this.serviceKey + '\'' + ", url='" + this.url + '\'' + ", client='" + this.client + '\'' + ", clientUrl='" + this.clientUrl + '\'' + ", description='" + this.description + '\'' + ", severity='" + this.severity + '\'' + ", details=" + this.details + ", images=" + this.images + ", links=" + this.links + ", httpConfig=" + this.httpConfig + '}';
    }
}

