/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Strings;
import io.hops.hopsworks.alerting.api.alert.dto.Alert;
import io.hops.hopsworks.alerting.api.alert.dto.AlertGroup;
import io.hops.hopsworks.alerting.api.alert.dto.AlertmanagerStatus;
import io.hops.hopsworks.alerting.api.alert.dto.PostableAlert;
import io.hops.hopsworks.alerting.api.alert.dto.PostableSilence;
import io.hops.hopsworks.alerting.api.alert.dto.ReceiverName;
import io.hops.hopsworks.alerting.api.alert.dto.Silence;
import io.hops.hopsworks.alerting.api.alert.dto.SilenceID;
import io.hops.hopsworks.alerting.exceptions.AlertManagerResponseException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerServerException;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class ClientWrapper
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(ClientWrapper.class.getName());
    private final Client client;
    private final WebTarget webTarget;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ClientWrapper(Client client, URI target) {
        this.client = client;
        this.webTarget = client.target(target);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private void checkResponse(Response response) throws AlertManagerResponseException {
        Response.Status.Family statusFamily = response.getStatusInfo().getFamily();
        if (statusFamily.equals((Object)Response.Status.Family.CLIENT_ERROR) || statusFamily.equals((Object)Response.Status.Family.SERVER_ERROR)) {
            String output = response.hasEntity() ? ": " + (String)response.readEntity(String.class) : "";
            throw new AlertManagerResponseException(response.getStatusInfo().getReasonPhrase() + output);
        }
    }

    private Response sendRequest(Invocation.Builder invocationBuilder, RequestMethod method, Entity<String> entity) throws AlertManagerServerException, AlertManagerResponseException {
        Response response = null;
        try {
            switch (method) {
                case GET: {
                    response = invocationBuilder.get();
                    break;
                }
                case POST: {
                    response = invocationBuilder.post(entity);
                    break;
                }
                case DELETE: {
                    response = invocationBuilder.delete();
                }
            }
        }
        catch (Exception e) {
            throw new AlertManagerServerException(e.getMessage());
        }
        if (response != null) {
            this.checkResponse(response);
        }
        return response;
    }

    private <T> Entity<String> toEntity(T pojo) {
        try {
            return Entity.json((Object)this.objectMapper.writeValueAsString(pojo));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to write json");
        }
    }

    private <T> Entity<String> toEntity(List<T> pojo) {
        try {
            return Entity.json((Object)this.objectMapper.writeValueAsString(pojo));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to write json");
        }
    }

    private <T> T getResponse(Response response, Class<T> type) {
        if (response != null && response.hasEntity()) {
            Object content;
            try {
                content = this.objectMapper.readValue((String)response.readEntity(String.class), type);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read response");
            }
            return (T)content;
        }
        throw new IllegalStateException("Failed to read response");
    }

    private <T> List<T> getResponseList(Response response, Class<T> clazz) {
        if (response != null && response.hasEntity()) {
            List content;
            TypeFactory t = this.objectMapper.getTypeFactory();
            try {
                content = (List)this.objectMapper.readValue((String)response.readEntity(String.class), (JavaType)t.constructCollectionType(ArrayList.class, clazz));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read response");
            }
            return content;
        }
        throw new IllegalStateException("Failed to read response");
    }

    private WebTarget setQueryParams(WebTarget webTarget, Boolean active, Boolean silenced, Boolean inhibited, Boolean unprocessed, Set<String> filters, String receiver) {
        if (active != null) {
            webTarget = webTarget.queryParam("active", new Object[]{active});
        }
        if (silenced != null) {
            webTarget = webTarget.queryParam("silenced", new Object[]{silenced});
        }
        if (inhibited != null) {
            webTarget = webTarget.queryParam("inhibited", new Object[]{inhibited});
        }
        if (unprocessed != null) {
            webTarget = webTarget.queryParam("unprocessed", new Object[]{unprocessed});
        }
        webTarget = this.setFilters(webTarget, filters);
        if (!Strings.isNullOrEmpty((String)receiver)) {
            webTarget = webTarget.queryParam("receiver", new Object[]{receiver});
        }
        return webTarget;
    }

    private WebTarget setFilters(WebTarget webTarget, Set<String> filters) {
        if (filters != null && !filters.isEmpty()) {
            for (String filter : filters) {
                webTarget = webTarget.queryParam("filter", new Object[]{filter});
            }
        }
        return webTarget;
    }

    public Response healthy() throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/-/healthy");
        LOGGER.log(Level.FINE, "Sending request healthy to: {0}", wt.toString());
        return this.sendRequest(wt.request(), RequestMethod.GET, null);
    }

    public Response ready() throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/-/ready");
        LOGGER.log(Level.FINE, "Sending request ready to: {0}", wt.toString());
        return this.sendRequest(wt.request(), RequestMethod.GET, null);
    }

    public Response reload() throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/-/reload");
        LOGGER.log(Level.FINE, "Sending request reload to: {0}", wt.toString());
        return this.sendRequest(wt.request(), RequestMethod.POST, (Entity<String>)Entity.json((Object)""));
    }

    public AlertmanagerStatus getStatus() throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/api/v2/status");
        LOGGER.log(Level.FINE, "Sending request getStatus to: {0}", wt.toString());
        return this.getResponse(this.sendRequest(wt.request(new String[]{"application/json"}), RequestMethod.GET, null), AlertmanagerStatus.class);
    }

    public List<ReceiverName> getReceivers() throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/api/v2/receivers");
        LOGGER.log(Level.FINE, "Sending request getReceivers to: {0}", wt.toString());
        return this.getResponseList(this.sendRequest(wt.request(new String[]{"application/json"}), RequestMethod.GET, null), ReceiverName.class);
    }

    public List<Silence> getSilences() throws AlertManagerResponseException, AlertManagerServerException {
        return this.getSilences(null);
    }

    public List<Silence> getSilences(Set<String> filters) throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/api/v2/silences");
        wt = this.setFilters(wt, filters);
        LOGGER.log(Level.FINE, "Sending request getSilences to: {0}", wt.toString());
        return this.getResponseList(this.sendRequest(wt.request(new String[]{"application/json"}), RequestMethod.GET, null), Silence.class);
    }

    public Silence getSilence(String uuid) throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/api/v2/silence").path(uuid);
        LOGGER.log(Level.FINE, "Sending request getSilence to: {0}", wt.toString());
        return this.getResponse(this.sendRequest(wt.request(new String[]{"application/json"}), RequestMethod.GET, null), Silence.class);
    }

    public SilenceID postSilences(PostableSilence postableSilence) throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/api/v2/silences");
        LOGGER.log(Level.FINE, "Sending request postSilences to: {0}", wt.toString());
        return this.getResponse(this.sendRequest(wt.request(new String[]{"application/json"}), RequestMethod.POST, this.toEntity(postableSilence)), SilenceID.class);
    }

    public Response deleteSilence(String uuid) throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/api/v2/silence").path(uuid);
        LOGGER.log(Level.FINE, "Sending request deleteSilence to: {0}", wt.toString());
        return this.sendRequest(wt.request(new String[]{"application/json"}), RequestMethod.DELETE, null);
    }

    public List<Alert> getAlerts() throws AlertManagerResponseException, AlertManagerServerException {
        return this.getAlerts(null, null, null, null, null, null);
    }

    public List<Alert> getAlerts(Boolean active, Boolean silenced, Boolean inhibited, Boolean unprocessed, Set<String> filters, String receiver) throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/api/v2/alerts");
        wt = this.setQueryParams(wt, active, silenced, inhibited, unprocessed, filters, receiver);
        LOGGER.log(Level.FINE, "Sending request getAlerts to: {0}", wt.toString());
        return this.getResponseList(this.sendRequest(wt.request(new String[]{"application/json"}), RequestMethod.GET, null), Alert.class);
    }

    public Response postAlerts(List<PostableAlert> postableAlerts) throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/api/v2/alerts");
        LOGGER.log(Level.FINE, "Sending request postAlerts to: {0}", wt.toString());
        return this.sendRequest(wt.request(new String[]{"application/json"}), RequestMethod.POST, this.toEntity(postableAlerts));
    }

    public List<AlertGroup> getAlertGroups(Boolean active, Boolean silenced, Boolean inhibited, Set<String> filters, String receiver) throws AlertManagerResponseException, AlertManagerServerException {
        WebTarget wt = this.webTarget.path("/api/v2/alerts/groups");
        wt = this.setQueryParams(wt, active, silenced, inhibited, null, filters, receiver);
        LOGGER.log(Level.FINE, "Sending request getAlertGroups to: {0}", wt.toString());
        return this.getResponseList(this.sendRequest(wt.request(new String[]{"application/json"}), RequestMethod.GET, null), AlertGroup.class);
    }

    public String toString() {
        return this.webTarget.toString();
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

