/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.config;

import io.hops.hopsworks.alerting.config.ConfigValidator;
import io.hops.hopsworks.alerting.config.dto.AlertManagerConfig;
import io.hops.hopsworks.alerting.config.dto.EmailConfig;
import io.hops.hopsworks.alerting.config.dto.Global;
import io.hops.hopsworks.alerting.config.dto.InhibitRule;
import io.hops.hopsworks.alerting.config.dto.PagerdutyConfig;
import io.hops.hopsworks.alerting.config.dto.Receiver;
import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.alerting.config.dto.SlackConfig;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigReadException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigUpdateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerDuplicateEntryException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerNoSuchElementException;
import java.util.ArrayList;
import java.util.List;

public class ConfigUpdater {
    public static AlertManagerConfig updateGlobal(AlertManagerConfig alertManagerConfig, Global global) {
        ConfigValidator.validate(global);
        alertManagerConfig.setGlobal(global);
        return alertManagerConfig;
    }

    public static AlertManagerConfig updateTemplates(AlertManagerConfig alertManagerConfig, List<String> templates) {
        ConfigValidator.validate(templates);
        alertManagerConfig.setTemplates(templates);
        return alertManagerConfig;
    }

    public static AlertManagerConfig updateGlobalRoute(AlertManagerConfig alertManagerConfig, Route route) {
        ConfigValidator.validateGlobalRoute(route);
        alertManagerConfig.setRoute(route);
        return alertManagerConfig;
    }

    public static AlertManagerConfig updateInhibitRules(AlertManagerConfig alertManagerConfig, List<InhibitRule> inhibitRules) {
        ConfigValidator.validateInhibitRules(inhibitRules);
        alertManagerConfig.setInhibitRules(inhibitRules);
        return alertManagerConfig;
    }

    public static AlertManagerConfig addReceiver(AlertManagerConfig alertManagerConfig, Receiver receiver) throws AlertManagerDuplicateEntryException {
        ConfigValidator.validate(receiver);
        if (alertManagerConfig.getReceivers() == null) {
            alertManagerConfig.setReceivers(new ArrayList<Receiver>());
        }
        if (alertManagerConfig.getReceivers().contains(receiver)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same name already exists.");
        }
        alertManagerConfig.getReceivers().add(receiver);
        return alertManagerConfig;
    }

    public static int getIndexOfReceiver(AlertManagerConfig alertManagerConfig, String name) throws AlertManagerNoSuchElementException {
        int index;
        Receiver receiverToUpdate = new Receiver(name);
        int n = index = alertManagerConfig.getReceivers() == null ? -1 : alertManagerConfig.getReceivers().indexOf(receiverToUpdate);
        if (index < 0) {
            throw new AlertManagerNoSuchElementException("A receiver with the given name was not found. Name=" + name);
        }
        return index;
    }

    public static int getIndexOfRoute(AlertManagerConfig alertManagerConfig, Route route) throws AlertManagerNoSuchElementException {
        int index;
        int n = index = alertManagerConfig.getRoute() == null || alertManagerConfig.getRoute().getRoutes() == null ? -1 : alertManagerConfig.getRoute().getRoutes().indexOf(route);
        if (index < 0) {
            throw new AlertManagerNoSuchElementException("A route with the given receiver name was not found. Receiver Name=" + route.getReceiver());
        }
        return index;
    }

    public static AlertManagerConfig updateReceiver(AlertManagerConfig alertManagerConfig, String name, Receiver receiver) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigReadException {
        ConfigValidator.validate(receiver);
        int index = ConfigUpdater.getIndexOfReceiver(alertManagerConfig, name);
        if (!name.equals(receiver.getName()) && alertManagerConfig.getReceivers().contains(receiver)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same name already exists.");
        }
        alertManagerConfig.getReceivers().remove(index);
        alertManagerConfig.getReceivers().add(receiver);
        return alertManagerConfig;
    }

    private static AlertManagerConfig removeRoutes(String receiver, AlertManagerConfig alertManagerConfig) {
        ArrayList<Route> routesToDelete = new ArrayList<Route>();
        for (Route route : alertManagerConfig.getRoute().getRoutes()) {
            if (!route.getReceiver().equals(receiver)) continue;
            routesToDelete.add(route);
        }
        if (routesToDelete.size() > 0) {
            alertManagerConfig.getRoute().getRoutes().removeAll(routesToDelete);
        }
        return alertManagerConfig;
    }

    public static AlertManagerConfig removeReceiver(AlertManagerConfig alertManagerConfig, String name, boolean cascade) throws AlertManagerConfigReadException {
        int index;
        int n = index = alertManagerConfig.getReceivers() == null ? -1 : alertManagerConfig.getReceivers().indexOf(new Receiver(name));
        if (index > -1) {
            alertManagerConfig.getReceivers().remove(index);
            if (cascade) {
                return ConfigUpdater.removeRoutes(name, alertManagerConfig);
            }
            return alertManagerConfig;
        }
        return null;
    }

    public static AlertManagerConfig addRoute(AlertManagerConfig alertManagerConfig, Route route) throws AlertManagerDuplicateEntryException, AlertManagerConfigReadException, AlertManagerNoSuchElementException {
        ConfigValidator.validate(route);
        ConfigUpdater.getIndexOfReceiver(alertManagerConfig, route.getReceiver());
        if (alertManagerConfig.getRoute() == null) {
            alertManagerConfig.setRoute(new Route());
        }
        if (alertManagerConfig.getRoute().getRoutes() == null) {
            alertManagerConfig.getRoute().setRoutes(new ArrayList<Route>());
        }
        if (alertManagerConfig.getRoute().getRoutes().contains(route)) {
            throw new AlertManagerDuplicateEntryException("A route with the same match and receiver name already exists.");
        }
        alertManagerConfig.getRoute().getRoutes().add(route);
        return alertManagerConfig;
    }

    public static AlertManagerConfig updateRoute(AlertManagerConfig alertManagerConfig, Route routeToUpdate, Route route) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigReadException {
        ConfigValidator.validate(route);
        ConfigUpdater.getIndexOfReceiver(alertManagerConfig, route.getReceiver());
        int index = ConfigUpdater.getIndexOfRoute(alertManagerConfig, routeToUpdate);
        if (!routeToUpdate.equals(route) && alertManagerConfig.getRoute().getRoutes().contains(route)) {
            throw new AlertManagerDuplicateEntryException("A route with the same mather and receiver name already exists.");
        }
        alertManagerConfig.getRoute().getRoutes().remove(index);
        alertManagerConfig.getRoute().getRoutes().add(route);
        return alertManagerConfig;
    }

    public static AlertManagerConfig removeRoute(AlertManagerConfig alertManagerConfig, Route route) throws AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        int index;
        int n = index = alertManagerConfig.getRoute().getRoutes() == null ? -1 : alertManagerConfig.getRoute().getRoutes().indexOf(route);
        if (index > -1) {
            alertManagerConfig.getRoute().getRoutes().remove(index);
            return alertManagerConfig;
        }
        return null;
    }

    public static AlertManagerConfig addEmailToReceiver(AlertManagerConfig alertManagerConfig, String name, EmailConfig emailConfig) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException {
        ConfigValidator.validate(emailConfig);
        int index = ConfigUpdater.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        if (receiverToUpdate.getEmailConfigs() == null) {
            receiverToUpdate.setEmailConfigs(new ArrayList<EmailConfig>());
        }
        if (receiverToUpdate.getEmailConfigs().contains(emailConfig)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same email already exists.");
        }
        receiverToUpdate.getEmailConfigs().add(emailConfig);
        return alertManagerConfig;
    }

    public static AlertManagerConfig removeEmailFromReceiver(AlertManagerConfig alertManagerConfig, String name, EmailConfig emailConfig) throws AlertManagerNoSuchElementException {
        int index = ConfigUpdater.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        int n = index = receiverToUpdate.getEmailConfigs() == null ? -1 : receiverToUpdate.getEmailConfigs().indexOf(emailConfig);
        if (index > -1) {
            receiverToUpdate.getEmailConfigs().remove(index);
            return alertManagerConfig;
        }
        return null;
    }

    public static AlertManagerConfig addSlackToReceiver(AlertManagerConfig alertManagerConfig, String name, SlackConfig slackConfig) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException {
        ConfigValidator.validate(slackConfig);
        int index = ConfigUpdater.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        if (receiverToUpdate.getSlackConfigs() == null) {
            receiverToUpdate.setSlackConfigs(new ArrayList<SlackConfig>());
        }
        if (receiverToUpdate.getSlackConfigs().contains(slackConfig)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same api url and channel already exists.");
        }
        receiverToUpdate.getSlackConfigs().add(slackConfig);
        return alertManagerConfig;
    }

    public static AlertManagerConfig removeSlackFromReceiver(AlertManagerConfig alertManagerConfig, String name, SlackConfig slackConfig) throws AlertManagerNoSuchElementException {
        int index = ConfigUpdater.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        int n = index = receiverToUpdate.getSlackConfigs() == null ? -1 : receiverToUpdate.getSlackConfigs().indexOf(slackConfig);
        if (index > -1) {
            receiverToUpdate.getSlackConfigs().remove(index);
            return alertManagerConfig;
        }
        return null;
    }

    public static AlertManagerConfig addPagerdutyToReceiver(AlertManagerConfig alertManagerConfig, String name, PagerdutyConfig pagerdutyConfig) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException {
        ConfigValidator.validate(pagerdutyConfig);
        int index = ConfigUpdater.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        if (receiverToUpdate.getPagerdutyConfigs() == null) {
            receiverToUpdate.setPagerdutyConfigs(new ArrayList<PagerdutyConfig>());
        }
        if (receiverToUpdate.getPagerdutyConfigs().contains(pagerdutyConfig)) {
            throw new AlertManagerDuplicateEntryException("A receiver with the same api url and channel already exists.");
        }
        receiverToUpdate.getPagerdutyConfigs().add(pagerdutyConfig);
        return alertManagerConfig;
    }

    public static AlertManagerConfig removePagerdutyFromReceiver(AlertManagerConfig alertManagerConfig, String name, PagerdutyConfig pagerdutyConfig) throws AlertManagerNoSuchElementException {
        int index = ConfigUpdater.getIndexOfReceiver(alertManagerConfig, name);
        Receiver receiverToUpdate = alertManagerConfig.getReceivers().get(index);
        int n = index = receiverToUpdate.getPagerdutyConfigs() == null ? -1 : receiverToUpdate.getPagerdutyConfigs().indexOf(pagerdutyConfig);
        if (index > -1) {
            receiverToUpdate.getPagerdutyConfigs().remove(index);
            return alertManagerConfig;
        }
        return null;
    }
}

