/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.config;

import com.google.common.base.Strings;
import io.hops.hopsworks.alerting.config.dto.EmailConfig;
import io.hops.hopsworks.alerting.config.dto.Global;
import io.hops.hopsworks.alerting.config.dto.InhibitRule;
import io.hops.hopsworks.alerting.config.dto.PagerdutyConfig;
import io.hops.hopsworks.alerting.config.dto.Receiver;
import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.alerting.config.dto.SlackConfig;
import java.util.List;

public class ConfigValidator {
    public static void validate(Global global) {
        if (global == null) {
            throw new IllegalArgumentException("Global config can not be null.");
        }
    }

    public static void validate(List<String> templates) {
        if (templates == null || templates.isEmpty()) {
            throw new IllegalArgumentException("Templates config can not be null or empty.");
        }
    }

    public static void validateGlobalRoute(Route route) {
        if (route == null) {
            throw new IllegalArgumentException("Route config can not be null.");
        }
    }

    public static void validateInhibitRules(List<InhibitRule> inhibitRules) {
        if (inhibitRules == null || inhibitRules.isEmpty()) {
            throw new IllegalArgumentException("Inhibit Rules config can not be null or empty.");
        }
    }

    public static void validate(Receiver receiver) {
        if (Strings.isNullOrEmpty((String)receiver.getName())) {
            throw new IllegalArgumentException("Receiver name can not be empty.");
        }
        if (!(receiver.getEmailConfigs() != null && !receiver.getEmailConfigs().isEmpty() || receiver.getSlackConfigs() != null && !receiver.getSlackConfigs().isEmpty() || receiver.getOpsgenieConfigs() != null && !receiver.getOpsgenieConfigs().isEmpty() || receiver.getPagerdutyConfigs() != null && !receiver.getPagerdutyConfigs().isEmpty() || receiver.getPushoverConfigs() != null && !receiver.getPushoverConfigs().isEmpty() || receiver.getVictoropsConfigs() != null && !receiver.getVictoropsConfigs().isEmpty() || receiver.getWebhookConfigs() != null && !receiver.getWebhookConfigs().isEmpty() || receiver.getWechatConfigs() != null && !receiver.getWechatConfigs().isEmpty())) {
            throw new IllegalArgumentException("Receiver needs at least one configuration.");
        }
    }

    public static void validate(EmailConfig emailConfig) {
        if (Strings.isNullOrEmpty((String)emailConfig.getTo())) {
            throw new IllegalArgumentException("EmailConfig to can not be empty.");
        }
    }

    public static void validate(SlackConfig slackConfig) {
        if (Strings.isNullOrEmpty((String)slackConfig.getApiUrl()) || Strings.isNullOrEmpty((String)slackConfig.getChannel())) {
            throw new IllegalArgumentException("SlackConfig api url and channel can not be empty.");
        }
    }

    public static void validate(PagerdutyConfig pagerdutyConfig) {
        if (!Strings.isNullOrEmpty((String)pagerdutyConfig.getRoutingKey()) && !Strings.isNullOrEmpty((String)pagerdutyConfig.getServiceKey())) {
            throw new IllegalArgumentException("PagerdutyConfig RoutingKey or ServiceKey must be set.");
        }
    }

    public static void validate(Route route) {
        if (Strings.isNullOrEmpty((String)route.getReceiver())) {
            throw new IllegalArgumentException("Route receiver can not be empty.");
        }
        if ((route.getMatch() == null || route.getMatch().isEmpty()) && (route.getMatchRe() == null || route.getMatchRe().isEmpty())) {
            throw new IllegalArgumentException("Route needs to set match or match regex.");
        }
    }
}

