/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.api.util;

import com.google.common.base.Strings;
import com.logicalclocks.servicediscoverclient.Builder;
import com.logicalclocks.servicediscoverclient.ServiceDiscoveryClient;
import com.logicalclocks.servicediscoverclient.exceptions.ServiceDiscoveryException;
import com.logicalclocks.servicediscoverclient.resolvers.Type;
import com.logicalclocks.servicediscoverclient.service.Service;
import com.logicalclocks.servicediscoverclient.service.ServiceQuery;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;

@SuppressFBWarnings(justification="Used in a singleton", value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"})
public class Settings {
    private static final Logger LOGGER = Logger.getLogger(Settings.class.getName());
    public static final String MANAGEMENT_API_HEALTH = "/-/healthy";
    public static final String MANAGEMENT_API_READY = "/-/ready";
    public static final String MANAGEMENT_API_RELOAD = "/-/reload";
    public static final String ALERTS_API_STATUS = "/api/v2/status";
    public static final String ALERTS_API_RECEIVERS = "/api/v2/receivers";
    public static final String ALERTS_API_SILENCES = "/api/v2/silences";
    public static final String ALERTS_API_SILENCE = "/api/v2/silence";
    public static final String ALERTS_API_ALERTS = "/api/v2/alerts";
    public static final String ALERTS_API_ALERTS_GROUPS = "/api/v2/alerts/groups";
    public static final String DEFAULT_SERVICE_DISCOVERY_DOMAIN = "consul";
    public static final String DEFAULT_ALERTMANAGER_FQDN = "alertmanager.prometheus.service.consul";
    private static final ConcurrentHashMap<String, URI> alertManagerAddresses = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<URI>> alertManagerPeers = new ConcurrentHashMap();

    public static List<String> getMyIPAddresses() {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface networkInterface = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = networkInterface.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    ipAddresses.add(enumIpAddr.nextElement().getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            LOGGER.log(Level.WARNING, "Failed to get ip address of node. {0}", e.getMessage());
        }
        if (ipAddresses.isEmpty()) {
            LOGGER.log(Level.WARNING, "Failed to get ip address of node. Alert manager can not ensure high availability.");
        }
        return ipAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Service> getAlertManagers(String serviceFQDN) throws ServiceDiscoveryException {
        List<Service> services;
        try (ServiceDiscoveryClient client = null;){
            client = new Builder(Type.DNS).build();
            String name = Strings.isNullOrEmpty((String)serviceFQDN) ? DEFAULT_ALERTMANAGER_FQDN : serviceFQDN;
            services = client.getService(ServiceQuery.of((String)name, Collections.emptySet())).collect(Collectors.toList());
        }
        return services;
    }

    private static Optional<Service> getLocalAM(List<Service> services, List<String> ipAddresses) {
        Optional<Service> service = !ipAddresses.isEmpty() && services.size() > 1 ? services.stream().filter(s -> ipAddresses.contains(s.getAddress())).findAny() : Optional.of(services.get(0));
        return service;
    }

    private static List<Service> getAMPeers(List<Service> services, List<String> ipAddresses) {
        List<Object> peers = !ipAddresses.isEmpty() && services.size() > 1 ? services.stream().filter(s -> !ipAddresses.contains(s.getAddress())).collect(Collectors.toList()) : Collections.emptyList();
        return peers;
    }

    private static URI getURI(String address, String scheme, Integer port) {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)"").scheme(Strings.isNullOrEmpty((String)scheme) ? "http" : scheme).host(address);
        if (port != null && port > 0) {
            uriBuilder.port(port.intValue());
        }
        LOGGER.log(Level.INFO, "");
        return uriBuilder.build(new Object[0]);
    }

    public static URI getAlertManagerAddress(String serviceFQDN, String scheme) throws ServiceDiscoveryException {
        String string = serviceFQDN = Strings.isNullOrEmpty((String)serviceFQDN) ? DEFAULT_ALERTMANAGER_FQDN : serviceFQDN;
        if (alertManagerAddresses.get(serviceFQDN) == null) {
            List<String> ipAddresses = Settings.getMyIPAddresses();
            List<Service> services = Settings.getAlertManagers(serviceFQDN);
            Optional<Service> optionalService = Settings.getLocalAM(services, ipAddresses);
            Service service = optionalService.orElseThrow(() -> new ServiceDiscoveryException("Service not found."));
            alertManagerAddresses.put(serviceFQDN, Settings.getURI(service.getAddress(), scheme, service.getPort()));
        }
        return alertManagerAddresses.get(serviceFQDN);
    }

    public static List<URI> getAlertManagerPeers(String serviceFQDN, String scheme) throws ServiceDiscoveryException {
        String string = serviceFQDN = Strings.isNullOrEmpty((String)serviceFQDN) ? DEFAULT_ALERTMANAGER_FQDN : serviceFQDN;
        if (alertManagerPeers.get(serviceFQDN) == null) {
            List<String> ipAddresses = Settings.getMyIPAddresses();
            List<Service> services = Settings.getAlertManagers(serviceFQDN);
            List<Service> peers = Settings.getAMPeers(services, ipAddresses);
            if (peers != null && !peers.isEmpty()) {
                alertManagerPeers.put(serviceFQDN, peers.stream().map(s -> Settings.getURI(s.getAddress(), scheme, s.getPort())).collect(Collectors.toList()));
            } else {
                alertManagerPeers.put(serviceFQDN, Collections.emptyList());
            }
        }
        return alertManagerPeers.get(serviceFQDN);
    }

    public static URI getAlertManagerAddress() throws ServiceDiscoveryException {
        return Settings.getAlertManagerAddress(null, null);
    }

    public static URI getAlertManagerAddressByFQDN(String serviceFQDN, boolean isHttps) throws ServiceDiscoveryException {
        return Settings.getAlertManagerAddress(serviceFQDN, isHttps ? "https" : null);
    }

    public static URI getAlertManagerAddressByDN(String serviceDiscoveryDomain, boolean isHttps) throws ServiceDiscoveryException {
        String serviceFQDN = DEFAULT_ALERTMANAGER_FQDN;
        if (!Strings.isNullOrEmpty((String)serviceDiscoveryDomain) && !DEFAULT_SERVICE_DISCOVERY_DOMAIN.equals(serviceDiscoveryDomain)) {
            serviceFQDN = DEFAULT_ALERTMANAGER_FQDN.replace(DEFAULT_SERVICE_DISCOVERY_DOMAIN, serviceDiscoveryDomain);
        }
        return Settings.getAlertManagerAddressByFQDN(serviceFQDN, isHttps);
    }

    public static List<URI> getAlertManagerPeers() throws ServiceDiscoveryException {
        return Settings.getAlertManagerPeers(null, null);
    }

    public static List<URI> getAlertManagerPeersByFQDN(String serviceFQDN, boolean isHttps) throws ServiceDiscoveryException {
        return Settings.getAlertManagerPeers(serviceFQDN, isHttps ? "https" : null);
    }

    public static List<URI> getAlertManagerPeersByDN(String serviceDiscoveryDomain, boolean isHttps) throws ServiceDiscoveryException {
        String serviceFQDN = DEFAULT_ALERTMANAGER_FQDN;
        if (!Strings.isNullOrEmpty((String)serviceDiscoveryDomain) && !DEFAULT_SERVICE_DISCOVERY_DOMAIN.equals(serviceDiscoveryDomain)) {
            serviceFQDN = DEFAULT_ALERTMANAGER_FQDN.replace(DEFAULT_SERVICE_DISCOVERY_DOMAIN, serviceDiscoveryDomain);
        }
        return Settings.getAlertManagerPeersByFQDN(serviceFQDN, isHttps);
    }

    public static void clearCache() {
        alertManagerAddresses.clear();
    }
}

