/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alerting.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.hops.hopsworks.alerting.api.AlertManagerClient;
import io.hops.hopsworks.alerting.config.dto.AlertManagerConfig;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigFileNotFoundException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigReadException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigUpdateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerResponseException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerServerException;
import java.io.File;
import java.io.IOException;

@SuppressFBWarnings(justification="Used only as default", value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public class AlertManagerConfigController {
    private static final String CONFIG_FILE_PATH = "/srv/hops/alertmanager/alertmanager/alertmanager.yml";
    private final File configFile;

    private AlertManagerConfigController(File configFile) {
        this.configFile = configFile;
    }

    public AlertManagerConfig read() throws AlertManagerConfigReadException {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            return (AlertManagerConfig)objectMapper.readValue(this.configFile, AlertManagerConfig.class);
        }
        catch (IOException e) {
            throw new AlertManagerConfigReadException("Failed to read configuration file. Error " + e.getMessage());
        }
    }

    public void write(AlertManagerConfig alertManagerConfig) throws AlertManagerConfigUpdateException {
        YAMLFactory yamlFactory = new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)yamlFactory);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.SnakeCaseStrategy());
        try {
            objectMapper.writeValue(this.configFile, (Object)alertManagerConfig);
        }
        catch (IOException e) {
            throw new AlertManagerConfigUpdateException("Failed to update configuration file. Error " + e.getMessage());
        }
    }

    public void writeAndReload(AlertManagerConfig alertManagerConfig, AlertManagerClient client) throws AlertManagerConfigUpdateException, AlertManagerServerException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfigTmp = this.read();
        this.write(alertManagerConfig);
        try {
            client.reload();
        }
        catch (AlertManagerResponseException e) {
            this.write(alertManagerConfigTmp);
            throw new AlertManagerConfigUpdateException("Failed to update AlertManagerConfig. " + e.getMessage(), e);
        }
        catch (AlertManagerServerException se) {
            this.write(alertManagerConfigTmp);
            throw se;
        }
    }

    public static class Builder {
        private String configPath;

        public Builder withConfigPath(String configPath) {
            this.configPath = configPath;
            return this;
        }

        private File getConfigFile() throws AlertManagerConfigFileNotFoundException {
            File configFile = Strings.isNullOrEmpty((String)this.configPath) ? new File(AlertManagerConfigController.CONFIG_FILE_PATH) : new File(this.configPath);
            if (!configFile.exists() || !configFile.isFile()) {
                throw new AlertManagerConfigFileNotFoundException("Alertmanager configuration file not found. Path: " + configFile.getPath());
            }
            if (!configFile.canWrite()) {
                throw new AlertManagerConfigFileNotFoundException("Failed to access Alertmanager configuration file. Write permission denied on: " + configFile.getPath());
            }
            return configFile;
        }

        public AlertManagerConfigController build() throws AlertManagerConfigFileNotFoundException {
            return new AlertManagerConfigController(this.getConfigFile());
        }
    }
}

