/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.hops.hopsworks.alert.dao.AlertManagerConfigFacade;
import io.hops.hopsworks.alert.dao.AlertReceiverFacade;
import io.hops.hopsworks.alert.exception.AlertManagerAccessControlException;
import io.hops.hopsworks.alert.exception.AlertManagerUnreachableException;
import io.hops.hopsworks.alert.util.ConfigUtil;
import io.hops.hopsworks.alert.util.Constants;
import io.hops.hopsworks.alert.util.JsonObjectHelper;
import io.hops.hopsworks.alert.util.VariablesFacade;
import io.hops.hopsworks.alerting.api.AlertManagerClient;
import io.hops.hopsworks.alerting.api.util.Settings;
import io.hops.hopsworks.alerting.config.AlertManagerConfigController;
import io.hops.hopsworks.alerting.config.dto.AlertManagerConfig;
import io.hops.hopsworks.alerting.config.dto.Global;
import io.hops.hopsworks.alerting.config.dto.HttpConfig;
import io.hops.hopsworks.alerting.config.dto.InhibitRule;
import io.hops.hopsworks.alerting.config.dto.Receiver;
import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.alerting.exceptions.AlertManagerClientCreateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigCtrlCreateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigReadException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigUpdateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerDuplicateEntryException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerNoSuchElementException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerServerException;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertManagerConfigEntity;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertReceiver;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.alert.FeatureGroupAlert;
import io.hops.hopsworks.persistence.entity.jobs.description.JobAlert;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.AccessTimeout;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ws.rs.client.ClientBuilder;
import org.json.JSONObject;

@Singleton
@AccessTimeout(value=60L, unit=TimeUnit.SECONDS)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AlertManagerConfiguration {
    private static final Logger LOGGER = Logger.getLogger(AlertManagerConfiguration.class.getName());
    @Resource
    TimerService timerService;
    private AlertManagerConfigController alertManagerConfigController;
    private AlertManagerClient client;
    private Exception initException;
    private int clientCount = 0;
    private int configCount = 0;
    private int serverErrorCount = 0;
    @EJB
    private VariablesFacade variablesFacade;
    @EJB
    private AlertManagerConfigFacade alertManagerConfigFacade;
    @EJB
    private AlertReceiverFacade alertReceiverFacade;

    public AlertManagerConfiguration() {
    }

    public AlertManagerConfiguration(AlertManagerClient client, AlertManagerConfigController alertManagerConfigController, AlertManagerConfigFacade alertManagerConfigFacade, AlertReceiverFacade alertReceiverFacade) {
        this.client = client;
        this.alertManagerConfigController = alertManagerConfigController;
        this.alertManagerConfigFacade = alertManagerConfigFacade;
        this.alertReceiverFacade = alertReceiverFacade;
    }

    @PostConstruct
    public void init() {
        this.tryBuildClient();
        this.tryBuildAlertManagerConfigCtrl();
    }

    private void tryBuildClient() {
        String domain = this.variablesFacade.getVariableValue("service_discovery_domain").orElse("");
        try {
            this.client = new AlertManagerClient.Builder(ClientBuilder.newClient()).withServiceDN(domain).build();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to init Alertmanager client. " + e.getMessage());
            this.initException = e;
            this.createRetryTimer(Constants.TimerType.CLIENT);
        }
    }

    private void tryBuildAlertManagerConfigCtrl() {
        Optional<String> alertManagerConfFile = this.variablesFacade.getVariableValue("alert_manager_config");
        String configFile = alertManagerConfFile.orElse(null);
        try {
            this.alertManagerConfigController = new AlertManagerConfigController.Builder().withClient(this.getClient()).withConfigPath(configFile).build();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to init Alertmanager config controller. " + e.getMessage());
            this.initException = e;
            this.createRetryTimer(Constants.TimerType.CONFIG);
        }
    }

    private void doClientSanityCheck() throws AlertManagerClientCreateException {
        if (this.client == null) {
            if (this.initException != null) {
                throw new AlertManagerClientCreateException((Throwable)this.initException);
            }
            throw new AlertManagerClientCreateException("Failed to instantiate AlertManagerClient");
        }
    }

    private AlertManagerClient getClient() throws AlertManagerClientCreateException {
        this.doClientSanityCheck();
        return this.client;
    }

    private void registerServerError() {
        ++this.serverErrorCount;
        if (this.serverErrorCount > 5) {
            this.clientCount = 0;
            this.serverErrorCount = 0;
            this.client.close();
            this.client = null;
            Settings.clearCache();
            this.tryBuildClient();
        }
    }

    private void registerSuccess() {
        this.serverErrorCount = 0;
    }

    public int getServerErrorCount() {
        return this.serverErrorCount;
    }

    private void createRetryTimer(Constants.TimerType type) {
        long duration = 20000L;
        switch (type) {
            case CLIENT: {
                if (this.clientCount > 6) {
                    duration *= 6L;
                    break;
                }
                ++this.clientCount;
                break;
            }
            case CONFIG: {
                if (this.configCount > 6) {
                    duration *= 6L;
                    break;
                }
                ++this.configCount;
            }
        }
        TimerConfig config = new TimerConfig();
        config.setInfo((Serializable)((Object)type.name()));
        this.timerService.createSingleActionTimer(duration, config);
    }

    private void doSanityCheck() throws AlertManagerConfigCtrlCreateException {
        if (this.alertManagerConfigController == null) {
            if (this.initException != null) {
                throw new AlertManagerConfigCtrlCreateException((Throwable)this.initException);
            }
            throw new AlertManagerConfigCtrlCreateException("Failed to instantiate AlertManagerConfigController");
        }
    }

    private void registerServerError(AlertManagerServerException e) throws AlertManagerUnreachableException {
        this.registerServerError();
        throw new AlertManagerUnreachableException("Alertmanager not reachable.", e);
    }

    @PreDestroy
    public void preDestroy() {
        for (Timer timer : this.timerService.getTimers()) {
            timer.cancel();
        }
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void performTimeout(Timer timer) {
        if (Constants.TimerType.CONFIG.name().equals(timer.getInfo())) {
            this.tryBuildAlertManagerConfigCtrl();
        } else if (Constants.TimerType.CLIENT.name().equals(timer.getInfo())) {
            this.tryBuildClient();
        }
    }

    @Lock(value=LockType.READ)
    public AlertManagerConfig read() throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        return this.alertManagerConfigController.read();
    }

    public void writeAndReload(AlertManagerConfig alertManagerConfig) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerConfigReadException {
        if (alertManagerConfig != null) {
            this.doSanityCheck();
            this.doClientSanityCheck();
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JSONObject jsonObject = new JSONObject(objectMapper.writeValueAsString((Object)alertManagerConfig));
                this.alertManagerConfigController.writeAndReload(alertManagerConfig);
                this.saveToDatabase(jsonObject);
                this.registerSuccess();
            }
            catch (AlertManagerServerException e) {
                this.registerServerError(e);
            }
            catch (JsonProcessingException e) {
                throw new AlertManagerConfigUpdateException("Can not save config to database. Failed to parse config to json. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void writeAndReload(AlertManagerConfig alertManagerConfig, String name, Receiver receiver) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerConfigReadException {
        if (alertManagerConfig != null) {
            this.doSanityCheck();
            this.doClientSanityCheck();
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JSONObject jsonObject = new JSONObject(objectMapper.writeValueAsString((Object)alertManagerConfig));
                this.alertManagerConfigController.writeAndReload(alertManagerConfig);
                this.saveToDatabase(jsonObject);
                if (receiver != null) {
                    this.saveReceiverToDatabase(name, receiver);
                } else {
                    this.removeReceiverFromDatabase(name);
                }
                this.registerSuccess();
            }
            catch (AlertManagerServerException e) {
                this.registerServerError(e);
            }
            catch (JsonProcessingException e) {
                throw new AlertManagerConfigUpdateException("Can not save config to database. Failed to parse config to json. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void saveToDatabase(JSONObject jsonObject) {
        Optional<AlertManagerConfigEntity> optionalAlertManagerConfigEntity = this.alertManagerConfigFacade.getLatest();
        if (!optionalAlertManagerConfigEntity.isPresent()) {
            AlertManagerConfigEntity alertManagerConfigEntity = new AlertManagerConfigEntity();
            alertManagerConfigEntity.setContent(jsonObject);
            alertManagerConfigEntity.setCreated(new Date());
            this.alertManagerConfigFacade.save(alertManagerConfigEntity);
        } else {
            AlertManagerConfigEntity alertManagerConfigEntity = optionalAlertManagerConfigEntity.get();
            alertManagerConfigEntity.setContent(jsonObject);
            alertManagerConfigEntity.setCreated(new Date());
            this.alertManagerConfigFacade.update(alertManagerConfigEntity);
        }
    }

    private void saveReceiverToDatabase(String name, Receiver receiver) throws AlertManagerConfigUpdateException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JSONObject jsonObject = new JSONObject(objectMapper.writeValueAsString((Object)receiver));
            Optional<AlertReceiver> optionalAlertReceiver = this.alertReceiverFacade.findByName(name);
            if (optionalAlertReceiver.isPresent()) {
                AlertReceiver alertReceiver = optionalAlertReceiver.get();
                alertReceiver.setName(receiver.getName());
                alertReceiver.setConfig(jsonObject);
                this.alertReceiverFacade.update(alertReceiver);
            } else {
                AlertReceiver alertReceiver = new AlertReceiver(receiver.getName(), jsonObject);
                this.alertReceiverFacade.save(alertReceiver);
            }
        }
        catch (JsonProcessingException e) {
            throw new AlertManagerConfigUpdateException("Failed to save receiver to database. Failed to parse receiver to json. " + e.getMessage(), (Throwable)e);
        }
    }

    private void removeReceiverFromDatabase(String name) {
        Optional<AlertReceiver> optionalAlertReceiver = this.alertReceiverFacade.findByName(name);
        optionalAlertReceiver.ifPresent(receiver -> this.alertReceiverFacade.remove((AlertReceiver)receiver));
    }

    public void restoreFromBackup() throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, IOException, AlertManagerUnreachableException, AlertManagerConfigUpdateException, AlertManagerClientCreateException {
        AlertManagerConfig alertManagerConfigBackup;
        AlertManagerConfig alertManagerConfig = this.read();
        Optional<AlertManagerConfigEntity> optionalAlertManagerConfigEntity = this.alertManagerConfigFacade.getLatest();
        ObjectMapper objectMapper = new ObjectMapper();
        JSONObject jsonAlertManagerConfig = alertManagerConfig != null ? new JSONObject(objectMapper.writeValueAsString((Object)alertManagerConfig)) : null;
        JSONObject jsonAlertManagerConfigBackup = optionalAlertManagerConfigEntity.map(AlertManagerConfigEntity::getContent).orElse(null);
        AlertManagerConfig alertManagerConfig2 = alertManagerConfigBackup = jsonAlertManagerConfigBackup != null ? (AlertManagerConfig)objectMapper.readValue(jsonAlertManagerConfigBackup.toString(), AlertManagerConfig.class) : null;
        if (jsonAlertManagerConfig != null && jsonAlertManagerConfigBackup != null) {
            if (!JsonObjectHelper.similar(jsonAlertManagerConfig, jsonAlertManagerConfigBackup)) {
                boolean updated = this.merge(alertManagerConfig, alertManagerConfigBackup);
                if (updated) {
                    this.writeAndReload(alertManagerConfig);
                    LOGGER.log(Level.INFO, "Fixed Alert manager config from backup.");
                } else {
                    this.saveToDatabase(jsonAlertManagerConfig);
                    LOGGER.log(Level.INFO, "Alert manager config backup saved.");
                }
            } else {
                LOGGER.log(Level.INFO, "Alert manager config is up to date with backup.");
            }
        } else if (jsonAlertManagerConfig == null && jsonAlertManagerConfigBackup != null) {
            this.writeAndReload(alertManagerConfigBackup);
            LOGGER.log(Level.INFO, "Replace Alert manager config with backup.");
        } else if (jsonAlertManagerConfig != null) {
            this.saveToDatabase(jsonAlertManagerConfig);
            LOGGER.log(Level.INFO, "Alert manager config backup saved.");
        }
    }

    private boolean merge(AlertManagerConfig alertManagerConfig1, AlertManagerConfig alertManagerConfig2) {
        boolean updated = false;
        if (alertManagerConfig1.getGlobal() == null && alertManagerConfig2.getGlobal() != null) {
            alertManagerConfig1.setGlobal(alertManagerConfig2.getGlobal());
            updated = true;
        } else if (alertManagerConfig1.getGlobal() != null && alertManagerConfig2.getGlobal() != null) {
            updated = this.merge(alertManagerConfig1.getGlobal(), alertManagerConfig2.getGlobal());
        }
        if (alertManagerConfig1.getTemplates() == null && alertManagerConfig2.getTemplates() != null) {
            alertManagerConfig1.setTemplates(alertManagerConfig2.getTemplates());
            updated = true;
        }
        if (alertManagerConfig1.getRoute() == null && alertManagerConfig2.getRoute() != null) {
            alertManagerConfig1.setRoute(alertManagerConfig2.getRoute());
            updated = true;
        } else if (alertManagerConfig2.getRoute() != null && alertManagerConfig2.getRoute().getRoutes() != null && !alertManagerConfig2.getRoute().getRoutes().isEmpty()) {
            if (alertManagerConfig1.getRoute().getRoutes() == null || alertManagerConfig1.getRoute().getRoutes().isEmpty()) {
                alertManagerConfig1.getRoute().setRoutes(alertManagerConfig2.getRoute().getRoutes());
                updated = true;
            } else {
                for (Route route : alertManagerConfig2.getRoute().getRoutes()) {
                    if (alertManagerConfig1.getRoute().getRoutes().contains(route)) continue;
                    alertManagerConfig1.getRoute().getRoutes().add(route);
                    updated = true;
                }
            }
        }
        if ((alertManagerConfig1.getInhibitRules() == null || alertManagerConfig1.getInhibitRules().isEmpty()) && alertManagerConfig2.getInhibitRules() != null) {
            alertManagerConfig1.setInhibitRules(alertManagerConfig2.getInhibitRules());
            updated = true;
        }
        if ((alertManagerConfig1.getReceivers() == null || alertManagerConfig1.getReceivers().isEmpty()) && alertManagerConfig2.getReceivers() != null) {
            alertManagerConfig1.setReceivers(alertManagerConfig2.getReceivers());
            updated = true;
        } else if (alertManagerConfig2.getReceivers() != null && !alertManagerConfig2.getReceivers().isEmpty()) {
            for (Receiver receiver : alertManagerConfig2.getReceivers()) {
                if (alertManagerConfig1.getReceivers().contains(receiver)) continue;
                alertManagerConfig1.getReceivers().add(receiver);
                updated = true;
            }
        }
        return updated;
    }

    private boolean merge(Global global, Global global1) {
        boolean updated = false;
        if (Strings.isNullOrEmpty((String)global.getSmtpSmarthost()) && !Strings.isNullOrEmpty((String)global1.getSmtpSmarthost())) {
            global.setSmtpSmarthost(global1.getSmtpSmarthost());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getSmtpFrom()) && !Strings.isNullOrEmpty((String)global1.getSmtpFrom())) {
            global.setSmtpFrom(global1.getSmtpFrom());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getSmtpAuthUsername()) && !Strings.isNullOrEmpty((String)global1.getSmtpAuthUsername())) {
            global.setSmtpAuthUsername(global1.getSmtpAuthUsername());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getSmtpAuthPassword()) && !Strings.isNullOrEmpty((String)global1.getSmtpAuthPassword())) {
            global.setSmtpAuthPassword(global1.getSmtpAuthPassword());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getSmtpAuthIdentity()) && !Strings.isNullOrEmpty((String)global1.getSmtpAuthIdentity())) {
            global.setSmtpAuthIdentity(global1.getSmtpAuthIdentity());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getSmtpAuthSecret()) && !Strings.isNullOrEmpty((String)global1.getSmtpAuthSecret())) {
            global.setSmtpAuthSecret(global1.getSmtpAuthSecret());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getSmtpRequireTls()) && !Strings.isNullOrEmpty((String)global1.getSmtpRequireTls())) {
            global.setSmtpRequireTls(global1.getSmtpRequireTls());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getSlackApiUrl()) && !Strings.isNullOrEmpty((String)global1.getSlackApiUrl())) {
            global.setSlackApiUrl(global1.getSlackApiUrl());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getVictoropsApiKey()) && !Strings.isNullOrEmpty((String)global1.getVictoropsApiKey())) {
            global.setVictoropsApiKey(global1.getVictoropsApiKey());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getVictoropsApiUrl()) && !Strings.isNullOrEmpty((String)global1.getVictoropsApiUrl())) {
            global.setVictoropsApiUrl(global1.getVictoropsApiUrl());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getPagerdutyUrl()) && !Strings.isNullOrEmpty((String)global1.getPagerdutyUrl())) {
            global.setPagerdutyUrl(global1.getPagerdutyUrl());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getOpsgenieApiKey()) && !Strings.isNullOrEmpty((String)global1.getOpsgenieApiKey())) {
            global.setOpsgenieApiKey(global1.getOpsgenieApiKey());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getOpsgenieApiUrl()) && !Strings.isNullOrEmpty((String)global1.getOpsgenieApiUrl())) {
            global.setOpsgenieApiUrl(global1.getOpsgenieApiUrl());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getWechatApiUrl()) && !Strings.isNullOrEmpty((String)global1.getWechatApiUrl())) {
            global.setWechatApiUrl(global1.getWechatApiUrl());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getWechatApiSecret()) && !Strings.isNullOrEmpty((String)global1.getWechatApiSecret())) {
            global.setWechatApiSecret(global1.getWechatApiSecret());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getWechatApiCorpId()) && !Strings.isNullOrEmpty((String)global1.getWechatApiCorpId())) {
            global.setWechatApiCorpId(global1.getWechatApiCorpId());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)global.getResolveTimeout()) && !Strings.isNullOrEmpty((String)global1.getResolveTimeout())) {
            global.setResolveTimeout(global1.getResolveTimeout());
            updated = true;
        }
        if (global.getHttpConfig() == null && global1.getHttpConfig() != null) {
            global.setHttpConfig(global1.getHttpConfig());
        } else if (global.getHttpConfig() != null && global1.getHttpConfig() != null) {
            updated = this.merge(global.getHttpConfig(), global1.getHttpConfig());
        }
        return updated;
    }

    private boolean merge(HttpConfig httpConfig, HttpConfig httpConfig1) {
        boolean updated = false;
        if (Strings.isNullOrEmpty((String)httpConfig.getBearerToken()) && !Strings.isNullOrEmpty((String)httpConfig1.getBearerToken())) {
            httpConfig.setBearerToken(httpConfig1.getBearerToken());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)httpConfig.getBearerTokenFile()) && !Strings.isNullOrEmpty((String)httpConfig1.getBearerTokenFile())) {
            httpConfig.setBearerTokenFile(httpConfig1.getBearerTokenFile());
            updated = true;
        }
        if (Strings.isNullOrEmpty((String)httpConfig.getProxyUrl()) && !Strings.isNullOrEmpty((String)httpConfig1.getProxyUrl())) {
            httpConfig.setProxyUrl(httpConfig1.getProxyUrl());
            updated = true;
        }
        if (httpConfig.getBasicAuth() == null && httpConfig1.getBasicAuth() != null) {
            httpConfig.setBasicAuth(httpConfig1.getBasicAuth());
            updated = true;
        } else if (httpConfig.getBasicAuth() != null && httpConfig1.getBasicAuth() != null) {
            if (Strings.isNullOrEmpty((String)httpConfig.getBasicAuth().getUsername()) && !Strings.isNullOrEmpty((String)httpConfig1.getBasicAuth().getUsername())) {
                httpConfig.getBasicAuth().setUsername(httpConfig1.getBasicAuth().getUsername());
                updated = true;
            }
            if (Strings.isNullOrEmpty((String)httpConfig.getBasicAuth().getPassword()) && !Strings.isNullOrEmpty((String)httpConfig1.getBasicAuth().getPassword())) {
                httpConfig.getBasicAuth().setPassword(httpConfig1.getBasicAuth().getPassword());
                updated = true;
            }
            if (Strings.isNullOrEmpty((String)httpConfig.getBasicAuth().getPasswordFile()) && !Strings.isNullOrEmpty((String)httpConfig1.getBasicAuth().getPasswordFile())) {
                httpConfig.getBasicAuth().setPasswordFile(httpConfig1.getBasicAuth().getPasswordFile());
                updated = true;
            }
        }
        if (httpConfig.getTlsConfig() == null && httpConfig1.getTlsConfig() != null) {
            httpConfig.setTlsConfig(httpConfig1.getTlsConfig());
        } else if (httpConfig.getTlsConfig() != null && httpConfig1.getTlsConfig() != null) {
            if (Strings.isNullOrEmpty((String)httpConfig.getTlsConfig().getCaFile()) && !Strings.isNullOrEmpty((String)httpConfig1.getTlsConfig().getCaFile())) {
                httpConfig.getTlsConfig().setCaFile(httpConfig1.getTlsConfig().getCaFile());
                updated = true;
            }
            if (Strings.isNullOrEmpty((String)httpConfig.getTlsConfig().getCertFile()) && !Strings.isNullOrEmpty((String)httpConfig1.getTlsConfig().getCertFile())) {
                httpConfig.getTlsConfig().setCertFile(httpConfig1.getTlsConfig().getCertFile());
                updated = true;
            }
            if (Strings.isNullOrEmpty((String)httpConfig.getTlsConfig().getKeyFile()) && !Strings.isNullOrEmpty((String)httpConfig1.getTlsConfig().getKeyFile())) {
                httpConfig.getTlsConfig().setKeyFile(httpConfig1.getTlsConfig().getKeyFile());
                updated = true;
            }
            if (Strings.isNullOrEmpty((String)httpConfig.getTlsConfig().getServerName()) && !Strings.isNullOrEmpty((String)httpConfig1.getTlsConfig().getServerName())) {
                httpConfig.getTlsConfig().setServerName(httpConfig1.getTlsConfig().getServerName());
                updated = true;
            }
            if (Strings.isNullOrEmpty((String)httpConfig.getTlsConfig().getInsecureSkipVerify()) && !Strings.isNullOrEmpty((String)httpConfig1.getTlsConfig().getInsecureSkipVerify())) {
                httpConfig.getTlsConfig().setInsecureSkipVerify(httpConfig1.getTlsConfig().getInsecureSkipVerify());
                updated = true;
            }
        }
        return updated;
    }

    public Global getGlobal() throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        return this.alertManagerConfigController.getGlobal();
    }

    public void updateGlobal(Global global) throws AlertManagerConfigCtrlCreateException, AlertManagerClientCreateException, AlertManagerUnreachableException, AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.updateGlobal(global);
        this.writeAndReload(alertManagerConfig);
    }

    public List<String> getTemplates() throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        return this.alertManagerConfigController.getTemplates();
    }

    public void updateTemplates(List<String> templates) throws AlertManagerConfigCtrlCreateException, AlertManagerClientCreateException, AlertManagerUnreachableException, AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.updateTemplates(templates);
        this.writeAndReload(alertManagerConfig);
    }

    public Route getGlobalRoute() throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        return this.alertManagerConfigController.getGlobalRoute();
    }

    public void updateRoute(Route route) throws AlertManagerConfigCtrlCreateException, AlertManagerClientCreateException, AlertManagerUnreachableException, AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.updateGlobalRoute(route);
        this.writeAndReload(alertManagerConfig);
    }

    public List<InhibitRule> getInhibitRules() throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        return this.alertManagerConfigController.getInhibitRules();
    }

    public void updateInhibitRules(List<InhibitRule> inhibitRules) throws AlertManagerConfigCtrlCreateException, AlertManagerClientCreateException, AlertManagerUnreachableException, AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.updateInhibitRules(inhibitRules);
        this.writeAndReload(alertManagerConfig);
    }

    private void fixReceiverName(Receiver receiver, Project project) {
        if (receiver.getName() != null && !receiver.getName().startsWith("%%project%%__".replace("%%project%%", project.getName()))) {
            receiver.setName("%%project%%__%%receiverName%%".replace("%%project%%", project.getName()).replace("%%receiverName%%", receiver.getName()));
        }
    }

    public Receiver getReceiver(String name, Project project) throws AlertManagerConfigCtrlCreateException, AlertManagerNoSuchElementException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        this.doSanityCheck();
        this.checkPermission(name, project, true);
        return this.alertManagerConfigController.getReceiver(name);
    }

    public Receiver getReceiver(String name) throws AlertManagerConfigCtrlCreateException, AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        this.doSanityCheck();
        return this.alertManagerConfigController.getReceiver(name);
    }

    public void addReceiver(Receiver receiver, Project project) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerConfigReadException {
        this.fixReceiverName(receiver, project);
        this.addReceiver(receiver);
    }

    public void addReceiver(Receiver receiver) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.addReceiver(receiver);
        this.writeAndReload(alertManagerConfig, receiver.getName(), receiver);
    }

    private void checkPermission(String name, Project project, boolean includeGlobal) throws AlertManagerAccessControlException {
        if (Strings.isNullOrEmpty((String)name) || !name.startsWith("%%project%%__".replace("%%project%%", project.getName())) && (!includeGlobal || !name.startsWith("global-receiver__"))) {
            throw new AlertManagerAccessControlException("You do not have permission to access this receiver. Receiver=" + name);
        }
    }

    public void updateReceiver(String name, Receiver receiver, Project project) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        this.checkPermission(name, project, false);
        this.fixReceiverName(receiver, project);
        this.updateReceiver(name, receiver);
    }

    public void updateReceiver(String name, Receiver receiver) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.updateReceiver(name, receiver);
        this.writeAndReload(alertManagerConfig, name, receiver);
    }

    public void removeReceiver(String name, Project project, boolean cascade) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        this.checkPermission(name, project, false);
        this.removeReceiver(name, cascade);
    }

    public void removeReceiver(String name, boolean cascade) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.removeReceiver(name, cascade);
        this.writeAndReload(alertManagerConfig, name, null);
    }

    private void fixRoute(Route route, Project project) {
        if ((route.getMatch() == null || route.getMatch().isEmpty()) && (route.getMatchRe() == null || route.getMatchRe().isEmpty())) {
            route.setMatch(new HashMap());
            route.getMatch().put("type", AlertType.PROJECT_ALERT.getValue());
            route.getMatch().put("project", project.getName());
        } else {
            if (route.getMatch() != null && !route.getMatch().isEmpty()) {
                route.getMatch().put("type", AlertType.PROJECT_ALERT.getValue());
                route.getMatch().put("project", project.getName());
            }
            if (route.getMatchRe() != null && !route.getMatchRe().isEmpty()) {
                route.getMatchRe().put("type", AlertType.PROJECT_ALERT.getValue());
                route.getMatchRe().put("project", project.getName());
            }
        }
    }

    private boolean isRouteInProject(Route route, Project project) {
        return !Strings.isNullOrEmpty((String)route.getReceiver()) && route.getReceiver().startsWith("%%project%%__".replace("%%project%%", project.getName())) && (route.getMatch() != null && route.getMatch().get("project") != null && ((String)route.getMatch().get("project")).equals(project.getName()) || route.getMatchRe() != null && route.getMatchRe().get("project") != null && ((String)route.getMatchRe().get("project")).equals(project.getName()));
    }

    private boolean isRouteGlobal(Route route) {
        return route.getMatch() != null && route.getMatch().get("type") != null && AlertType.fromValue((String)((String)route.getMatch().get("type"))).isGlobal() || route.getMatchRe() != null && route.getMatchRe().get("type") != null && AlertType.fromValue((String)((String)route.getMatchRe().get("type"))).isGlobal();
    }

    public List<Route> getRoutes(Project project) throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        ArrayList<Route> projectRoutes = new ArrayList<Route>();
        List<Route> routeList = this.getRoutes();
        for (Route route : routeList) {
            if (this.isRouteInProject(route, project)) {
                projectRoutes.add(route);
                continue;
            }
            if (!this.isRouteGlobal(route)) continue;
            projectRoutes.add(route);
        }
        return projectRoutes;
    }

    public List<Route> getRoutes() throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        return this.alertManagerConfigController.getRoutes();
    }

    public Route getRoute(Route route, Project project) throws AlertManagerAccessControlException, AlertManagerNoSuchElementException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        if (project != null) {
            return this.getRoute(route.getReceiver(), route.getMatch(), route.getMatchRe(), project);
        }
        return this.getRoute(route.getReceiver(), route.getMatch(), route.getMatchRe());
    }

    public Route getRoute(String receiver, Map<String, String> match, Map<String, String> matchRe, Project project) throws AlertManagerConfigCtrlCreateException, AlertManagerNoSuchElementException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        this.doSanityCheck();
        Route route = new Route(receiver).withMatch(match).withMatchRe(matchRe);
        List<Route> routes = this.getRoutes(project);
        int index = routes.indexOf(route);
        if (index < 0) {
            throw new AlertManagerNoSuchElementException("A route with the given receiver name was not found. Receiver Name=" + route.getReceiver());
        }
        return routes.get(index);
    }

    public Route getRoute(String receiver, Map<String, String> match, Map<String, String> matchRe) throws AlertManagerConfigCtrlCreateException, AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        this.doSanityCheck();
        return this.alertManagerConfigController.getRoute(receiver, match, matchRe);
    }

    public void addRoute(Route route, Project project) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerAccessControlException, AlertManagerConfigReadException, AlertManagerNoSuchElementException {
        this.fixRoute(route, project);
        if (!Strings.isNullOrEmpty((String)route.getReceiver()) && !route.getReceiver().startsWith("%%project%%__".replace("%%project%%", project.getName()))) {
            throw new AlertManagerAccessControlException("You do not have permission to add a route with receiver=" + route.getReceiver());
        }
        this.addRoute(route);
    }

    public void addRoute(Route route) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigReadException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerNoSuchElementException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.addRoute(route);
        this.writeAndReload(alertManagerConfig);
    }

    private void checkPermission(Route route, Project project) throws AlertManagerAccessControlException {
        if (!this.isRouteInProject(route, project)) {
            throw new AlertManagerAccessControlException("You do not have permission to change this route. " + route);
        }
    }

    public void updateRoute(Route routeToUpdate, Route route, Project project) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        if ((route.getMatch() == null || route.getMatch().isEmpty()) && (route.getMatchRe() == null || route.getMatchRe().isEmpty())) {
            throw new AlertManagerNoSuchElementException("Need to set match or matchRe to find a route.");
        }
        this.checkPermission(routeToUpdate, project);
        this.fixRoute(route, project);
        this.updateRoute(routeToUpdate, route);
    }

    public void updateRoute(Route routeToUpdate, Route route) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.updateRoute(routeToUpdate, route);
        this.writeAndReload(alertManagerConfig);
    }

    public void removeRoute(Route route, Project project) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        List<Route> routes = this.getRoutes(project);
        if (!routes.isEmpty() && routes.contains(route)) {
            this.removeRoute(route);
        }
    }

    public void removeRoute(Route route) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerUnreachableException, AlertManagerClientCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.removeRoute(route);
        this.writeAndReload(alertManagerConfig);
    }

    public void cleanProject(Project project) throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerConfigUpdateException, AlertManagerUnreachableException, AlertManagerClientCreateException {
        AlertManagerConfig alertManagerConfig = this.read();
        List routes = alertManagerConfig.getRoute() == null || alertManagerConfig.getRoute().getRoutes() == null ? Collections.emptyList() : alertManagerConfig.getRoute().getRoutes();
        List receivers = alertManagerConfig.getReceivers() == null ? Collections.emptyList() : alertManagerConfig.getReceivers();
        ArrayList<Receiver> receiversToRemove = new ArrayList<Receiver>();
        for (Receiver receiver : receivers) {
            if (!receiver.getName().startsWith("%%project%%__".replace("%%project%%", project.getName()))) continue;
            receiversToRemove.add(receiver);
        }
        ArrayList<Route> routesToRemove = new ArrayList<Route>();
        for (Route route : routes) {
            if (!this.isRouteInProject(route, project) && !receiversToRemove.contains(new Receiver(route.getReceiver()))) continue;
            routesToRemove.add(route);
        }
        if (!routesToRemove.isEmpty() || !receiversToRemove.isEmpty()) {
            if (!routesToRemove.isEmpty()) {
                alertManagerConfig.getRoute().getRoutes().removeAll(routesToRemove);
            }
            if (!receiversToRemove.isEmpty()) {
                alertManagerConfig.getReceivers().removeAll(receiversToRemove);
                for (Receiver receiver : receiversToRemove) {
                    this.removeReceiverFromDatabase(receiver.getName());
                }
            }
            this.writeAndReload(alertManagerConfig);
        }
    }

    private boolean fixReceivers(AlertManagerConfig alertManagerConfig, ObjectMapper objectMapper, List<AlertReceiver> alertReceivers) throws IOException {
        List<Route> routes = this.getRoutes(alertManagerConfig);
        List<Receiver> receivers = alertManagerConfig.getReceivers() == null ? new ArrayList() : alertManagerConfig.getReceivers();
        ArrayList<Receiver> receiversToAdd = new ArrayList<Receiver>();
        for (AlertReceiver alertReceiver : alertReceivers) {
            Receiver receiver = this.receiverToAdd(receivers, alertReceiver, objectMapper);
            if (receiver == null || receiversToAdd.contains(receiver)) continue;
            receiversToAdd.add(receiver);
        }
        ArrayList<Receiver> receiversToRemove = new ArrayList<Receiver>();
        for (Receiver receiver : receivers) {
            Optional<AlertReceiver> alertReceiver = this.alertReceiverFacade.findByName(receiver.getName());
            if (alertReceiver.isPresent() || !this.isNotSystemReceiver(alertManagerConfig, receiver)) continue;
            receiversToRemove.add(receiver);
        }
        if (!receiversToAdd.isEmpty() || !receiversToRemove.isEmpty()) {
            if (!receiversToAdd.isEmpty()) {
                receivers.addAll(receiversToAdd);
                LOGGER.log(Level.INFO, "Alert manager config updated. Added {0} receivers.", receiversToAdd.size());
            }
            if (!receiversToRemove.isEmpty()) {
                ArrayList<Route> arrayList = new ArrayList<Route>();
                for (Route route : routes) {
                    if (!receiversToRemove.contains(new Receiver(route.getReceiver()))) continue;
                    arrayList.add(route);
                }
                if (!arrayList.isEmpty()) {
                    alertManagerConfig.getRoute().getRoutes().removeAll(arrayList);
                    LOGGER.log(Level.INFO, "Alert manager config updated. Removed {0} routes.", arrayList.size());
                }
                receivers.removeAll(receiversToRemove);
                LOGGER.log(Level.INFO, "Alert manager config updated. Removed {0} receivers.", receiversToRemove.size());
            }
            alertManagerConfig.setReceivers(receivers);
            return true;
        }
        return false;
    }

    private boolean isNotSystemReceiver(AlertManagerConfig alertManagerConfig, Receiver receiver) {
        if (alertManagerConfig.getRoute() == null) {
            return true;
        }
        if (alertManagerConfig.getRoute().getReceiver().equals(receiver.getName())) {
            return false;
        }
        List routes = alertManagerConfig.getRoute().getRoutes();
        for (Route route : routes) {
            Map match = route.getMatch() != null ? route.getMatch() : route.getMatchRe();
            String alertType = match != null && match.get("type") != null ? (String)match.get("type") : null;
            if (alertType == null || !alertType.equals(AlertType.SYSTEM_ALERT.getValue()) || !route.getReceiver().equals(receiver.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean fixRoutes(AlertManagerConfig alertManagerConfig, List<AlertReceiver> alertReceivers) {
        List<Route> routes = this.getRoutes(alertManagerConfig);
        ArrayList<Route> routesToAdd = new ArrayList<Route>();
        for (AlertReceiver alertReceiver : alertReceivers) {
            if (alertReceiver.getName().equals(AlertType.DEFAULT.getValue())) continue;
            routesToAdd.addAll(this.getRoutesToAdd(alertReceiver, routes));
        }
        if (!routesToAdd.isEmpty()) {
            alertManagerConfig.getRoute().getRoutes().addAll(routesToAdd);
            LOGGER.log(Level.INFO, "Alert manager config updated. Added {0} routes.", routesToAdd.size());
            return true;
        }
        return false;
    }

    private List<Route> getRoutes(AlertManagerConfig alertManagerConfig) {
        if (alertManagerConfig.getRoute() == null) {
            alertManagerConfig.setRoute(new Route().withRoutes(new ArrayList()));
        } else if (alertManagerConfig.getRoute().getRoutes() == null) {
            alertManagerConfig.getRoute().setRoutes(new ArrayList());
        }
        return alertManagerConfig.getRoute().getRoutes();
    }

    private List<Route> getRoutesToAdd(AlertReceiver alertReceiver, List<Route> routes) {
        Route route;
        Collection jobAlerts = alertReceiver.getJobAlertCollection();
        Collection featureGroupAlerts = alertReceiver.getFeatureGroupAlertCollection();
        Collection projectServiceAlerts = alertReceiver.getProjectServiceAlertCollection();
        ArrayList<Route> routesToAdd = new ArrayList<Route>();
        for (JobAlert jobAlert : jobAlerts) {
            route = jobAlert.getAlertType().isGlobal() ? ConfigUtil.getRoute(jobAlert.getAlertType()) : ConfigUtil.getRoute(jobAlert);
            if (routes.contains(route) || routesToAdd.contains(route)) continue;
            routesToAdd.add(route);
        }
        for (FeatureGroupAlert featureGroupAlert : featureGroupAlerts) {
            route = featureGroupAlert.getAlertType().isGlobal() ? ConfigUtil.getRoute(featureGroupAlert.getAlertType()) : ConfigUtil.getRoute(featureGroupAlert);
            if (routes.contains(route) || routesToAdd.contains(route)) continue;
            routesToAdd.add(route);
        }
        for (ProjectServiceAlert projectServiceAlert : projectServiceAlerts) {
            route = projectServiceAlert.getAlertType().isGlobal() ? ConfigUtil.getRoute(projectServiceAlert.getAlertType()) : ConfigUtil.getRoute(projectServiceAlert);
            if (routes.contains(route) || routesToAdd.contains(route)) continue;
            routesToAdd.add(route);
        }
        return routesToAdd;
    }

    private Receiver receiverToAdd(List<Receiver> receivers, AlertReceiver alertReceiver, ObjectMapper objectMapper) throws IOException {
        Receiver receiverToAdd = null;
        if (!receivers.contains(new Receiver(alertReceiver.getName()))) {
            receiverToAdd = (Receiver)objectMapper.readValue(alertReceiver.getConfig().toString(), Receiver.class);
        }
        return receiverToAdd;
    }

    public void runFixConfig() throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, IOException, AlertManagerUnreachableException, AlertManagerConfigUpdateException, AlertManagerClientCreateException {
        AlertManagerConfig alertManagerConfig = this.read();
        ObjectMapper objectMapper = new ObjectMapper();
        List<AlertReceiver> alertReceivers = this.alertReceiverFacade.findAll();
        boolean updatedReceivers = this.fixReceivers(alertManagerConfig, objectMapper, alertReceivers);
        boolean updatedRoutes = this.fixRoutes(alertManagerConfig, alertReceivers);
        if (updatedReceivers || updatedRoutes) {
            this.writeAndReload(alertManagerConfig);
        }
    }
}

