/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert.util;

import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.alert.FeatureGroupAlert;
import io.hops.hopsworks.persistence.entity.jobs.description.JobAlert;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ConfigUtil {
    public static Map<String, String> getMatch(ProjectServiceAlert alert) {
        Project project = alert.getProject();
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("type", alert.getAlertType().getValue());
        match.put("project", project.getName());
        match.put("status", alert.getStatus().getName());
        return match;
    }

    public static Map<String, String> getMatch(FeatureGroupAlert alert) {
        Project project = alert.getFeatureGroup().getFeaturestore().getProject();
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("type", alert.getAlertType().getValue());
        match.put("project", project.getName());
        match.put("featureGroup", alert.getFeatureGroup().getName());
        match.put("status", alert.getStatus().getName());
        return match;
    }

    public static Map<String, String> getMatch(JobAlert alert) {
        Project project = alert.getJobId().getProject();
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("type", alert.getAlertType().getValue());
        match.put("project", project.getName());
        match.put("job", alert.getJobId().getName());
        match.put("status", alert.getStatus().getName());
        return match;
    }

    public static Route getRoute(ProjectServiceAlert alert) {
        if (alert.getAlertType().isGlobal()) {
            return ConfigUtil.getRoute(alert.getAlertType());
        }
        Map<String, String> match = ConfigUtil.getMatch(alert);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("project");
        groupBy.add("job");
        groupBy.add("featureGroup");
        groupBy.add("status");
        return new Route(alert.getReceiver().getName()).withContinue(Boolean.valueOf(true)).withMatch(match).withGroupBy(groupBy);
    }

    public static Route getRoute(FeatureGroupAlert alert) {
        if (alert.getAlertType().isGlobal()) {
            return ConfigUtil.getRoute(alert.getAlertType());
        }
        Map<String, String> match = ConfigUtil.getMatch(alert);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("project");
        groupBy.add("featureGroup");
        groupBy.add("status");
        return new Route(alert.getReceiver().getName()).withContinue(Boolean.valueOf(true)).withMatch(match).withGroupBy(groupBy);
    }

    public static Route getRoute(JobAlert alert) {
        if (alert.getAlertType().isGlobal()) {
            return ConfigUtil.getRoute(alert.getAlertType());
        }
        Map<String, String> match = ConfigUtil.getMatch(alert);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("project");
        groupBy.add("job");
        groupBy.add("status");
        return new Route(alert.getReceiver().getName()).withContinue(Boolean.valueOf(true)).withMatch(match).withGroupBy(groupBy);
    }

    public static Route getRoute(AlertType alertType) {
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("type", alertType.getValue());
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("project");
        groupBy.add("job");
        groupBy.add("featureGroup");
        groupBy.add("status");
        return new Route(alertType.getReceiverName()).withContinue(Boolean.valueOf(true)).withMatch(match).withGroupBy(groupBy);
    }
}

