/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import io.hops.hopsworks.alert.AMClient;
import io.hops.hopsworks.alert.AMConfigUpdater;
import io.hops.hopsworks.alert.dao.AlertManagerConfigFacade;
import io.hops.hopsworks.alert.dao.AlertReceiverFacade;
import io.hops.hopsworks.alert.exception.AlertManagerAccessControlException;
import io.hops.hopsworks.alert.util.ConfigUtil;
import io.hops.hopsworks.alert.util.JsonObjectHelper;
import io.hops.hopsworks.alert.util.VariablesFacade;
import io.hops.hopsworks.alerting.config.AlertManagerConfigController;
import io.hops.hopsworks.alerting.config.ConfigUpdater;
import io.hops.hopsworks.alerting.config.dto.AlertManagerConfig;
import io.hops.hopsworks.alerting.config.dto.Global;
import io.hops.hopsworks.alerting.config.dto.InhibitRule;
import io.hops.hopsworks.alerting.config.dto.Receiver;
import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigCtrlCreateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigReadException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigUpdateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerDuplicateEntryException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerNoSuchElementException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerServerException;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertManagerConfigEntity;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.AccessTimeout;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.json.JSONObject;

@Singleton
@AccessTimeout(value=60L, unit=TimeUnit.SECONDS)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AlertManagerConfiguration {
    private static final Logger LOGGER = Logger.getLogger(AlertManagerConfiguration.class.getName());
    private AlertManagerConfigController alertManagerConfigController;
    private Exception initException;
    private ITopic<String> configUpdatedTopic;
    @Inject
    private HazelcastInstance hazelcastInstance;
    @EJB
    private VariablesFacade variablesFacade;
    @EJB
    private AlertManagerConfigFacade alertManagerConfigFacade;
    @EJB
    private AMConfigUpdater amConfigUpdater;
    @EJB
    private AMClient amClient;
    @EJB
    private AlertReceiverFacade alertReceiverFacade;

    public AlertManagerConfiguration() {
    }

    @VisibleForTesting
    public AlertManagerConfiguration(AlertManagerConfigController alertManagerConfigController, AlertManagerConfigFacade alertManagerConfigFacade, AMClient amClient, AMConfigUpdater amConfigUpdater) {
        this.alertManagerConfigController = alertManagerConfigController;
        this.alertManagerConfigFacade = alertManagerConfigFacade;
        this.amClient = amClient;
        this.amConfigUpdater = amConfigUpdater;
    }

    @PostConstruct
    public void init() {
        this.tryBuildAlertManagerConfigCtrl();
        if (this.hazelcastInstance != null) {
            this.configUpdatedTopic = this.hazelcastInstance.getTopic("alertmanager_config_updated");
        }
    }

    private void tryBuildAlertManagerConfigCtrl() {
        Optional<String> alertManagerConfFile = this.variablesFacade.getVariableValue("alert_manager_config");
        String configFile = alertManagerConfFile.orElse(null);
        try {
            this.alertManagerConfigController = new AlertManagerConfigController.Builder().withConfigPath(configFile).build();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to init Alertmanager config controller. " + e.getMessage());
            this.initException = e;
        }
    }

    private void doSanityCheck() throws AlertManagerConfigCtrlCreateException {
        if (this.alertManagerConfigController == null) {
            if (this.initException != null) {
                throw new AlertManagerConfigCtrlCreateException((Throwable)this.initException);
            }
            throw new AlertManagerConfigCtrlCreateException("Failed to instantiate AlertManagerConfigController");
        }
    }

    @Lock(value=LockType.READ)
    public Optional<AlertManagerConfig> read() throws AlertManagerConfigReadException {
        ObjectMapper objectMapper = new ObjectMapper();
        return this.alertManagerConfigFacade.read(objectMapper);
    }

    private void broadcast(String message) {
        if (this.configUpdatedTopic != null) {
            this.configUpdatedTopic.publishAsync((Object)("Update configuration. " + message));
        }
    }

    private void updateAlertManagerConfig(AlertManagerConfig alertManagerConfig) throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        if (alertManagerConfig != null) {
            this.doSanityCheck();
            try {
                this.alertManagerConfigController.writeAndReload(alertManagerConfig, this.amClient.getClient());
            }
            catch (AlertManagerServerException e) {
                throw new AlertManagerConfigUpdateException("AlertManager server unreachable.", (Throwable)e);
            }
        }
    }

    @Lock(value=LockType.READ)
    public void restoreFromDb() throws AlertManagerConfigUpdateException {
        Optional<AlertManagerConfigEntity> optionalAlertManagerConfigEntity = this.alertManagerConfigFacade.getLatest();
        if (optionalAlertManagerConfigEntity.isPresent()) {
            ObjectMapper objectMapper = new ObjectMapper();
            JSONObject jsonAlertManagerConfigBackup = optionalAlertManagerConfigEntity.get().getContent();
            try {
                AlertManagerConfig alertManagerConfigBackup = (AlertManagerConfig)objectMapper.readValue(jsonAlertManagerConfigBackup.toString(), AlertManagerConfig.class);
                this.updateAlertManagerConfig(alertManagerConfigBackup);
            }
            catch (Exception e) {
                throw new AlertManagerConfigUpdateException("Failed to revert alert manger config from database. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void writeAndReload(AlertManagerConfig alertManagerConfig) throws AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        if (alertManagerConfig != null) {
            this.amConfigUpdater.writeAndReload(this.alertManagerConfigController, this.amClient.getClient(), alertManagerConfig, this.alertManagerConfigFacade);
            this.broadcast("Alert Manager Config updated");
        }
    }

    public void restoreFromBackup() throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, IOException, AlertManagerConfigUpdateException {
        AlertManagerConfig alertManagerConfigBackup;
        AlertManagerConfig alertManagerConfig = this.alertManagerConfigController.read();
        Optional<AlertManagerConfigEntity> optionalAlertManagerConfigEntity = this.alertManagerConfigFacade.getLatest();
        ObjectMapper objectMapper = new ObjectMapper();
        JSONObject jsonAlertManagerConfig = alertManagerConfig != null ? new JSONObject(objectMapper.writeValueAsString((Object)alertManagerConfig)) : null;
        JSONObject jsonAlertManagerConfigBackup = optionalAlertManagerConfigEntity.map(AlertManagerConfigEntity::getContent).orElse(null);
        AlertManagerConfig alertManagerConfig2 = alertManagerConfigBackup = jsonAlertManagerConfigBackup != null ? (AlertManagerConfig)objectMapper.readValue(jsonAlertManagerConfigBackup.toString(), AlertManagerConfig.class) : null;
        if (jsonAlertManagerConfigBackup != null) {
            if (jsonAlertManagerConfig == null || !JsonObjectHelper.similar(jsonAlertManagerConfig, jsonAlertManagerConfigBackup)) {
                this.updateAlertManagerConfig(alertManagerConfigBackup);
                LOGGER.log(Level.FINE, "Alert manager config restored from backup.");
            }
        } else if (jsonAlertManagerConfig != null) {
            this.alertManagerConfigFacade.saveToDatabase(jsonAlertManagerConfig);
            LOGGER.log(Level.INFO, "Alert manager config backup saved.");
        }
    }

    @Lock(value=LockType.READ)
    public Global getGlobal() throws AlertManagerConfigReadException {
        Optional<AlertManagerConfig> alertManagerConfig = this.read();
        return alertManagerConfig.map(AlertManagerConfig::getGlobal).orElse(null);
    }

    public void updateGlobal(Global global) throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        this.doSanityCheck();
        this.amConfigUpdater.updateGlobal(this.alertManagerConfigController, this.amClient.getClient(), global, this.alertManagerConfigFacade);
        this.broadcast("Alert Manager Config global updated");
    }

    @Lock(value=LockType.READ)
    public List<String> getTemplates() throws AlertManagerConfigReadException {
        Optional<AlertManagerConfig> alertManagerConfig = this.read();
        return alertManagerConfig.map(AlertManagerConfig::getTemplates).orElse(null);
    }

    public void updateTemplates(List<String> templates) throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        this.doSanityCheck();
        this.amConfigUpdater.updateTemplates(this.alertManagerConfigController, this.amClient.getClient(), templates, this.alertManagerConfigFacade);
        this.broadcast("Alert Manager Config templates updated");
    }

    @Lock(value=LockType.READ)
    public Route getGlobalRoute() throws AlertManagerConfigReadException {
        Optional<AlertManagerConfig> alertManagerConfig = this.read();
        return alertManagerConfig.map(AlertManagerConfig::getRoute).orElse(null);
    }

    public void updateRoute(Route route) throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        this.doSanityCheck();
        this.amConfigUpdater.updateGlobalRoute(this.alertManagerConfigController, this.amClient.getClient(), route, this.alertManagerConfigFacade);
        this.broadcast("Alert Manager Config route updated");
    }

    @Lock(value=LockType.READ)
    public List<InhibitRule> getInhibitRules() throws AlertManagerConfigReadException {
        Optional<AlertManagerConfig> alertManagerConfig = this.read();
        return alertManagerConfig.map(AlertManagerConfig::getInhibitRules).orElse(null);
    }

    public void updateInhibitRules(List<InhibitRule> inhibitRules) throws AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        this.doSanityCheck();
        this.amConfigUpdater.updateInhibitRules(this.alertManagerConfigController, this.amClient.getClient(), inhibitRules, this.alertManagerConfigFacade);
        this.broadcast("Alert Manager Config inhibitRules updated");
    }

    @Lock(value=LockType.READ)
    public Receiver getReceiver(String name, Project project) throws AlertManagerNoSuchElementException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        this.checkPermission(name, project, true);
        return this.getReceiver(name);
    }

    @Lock(value=LockType.READ)
    public Receiver getReceiver(String name) throws AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        Optional<AlertManagerConfig> alertManagerConfig = this.read();
        if (alertManagerConfig.isPresent()) {
            int index = ConfigUpdater.getIndexOfReceiver((AlertManagerConfig)alertManagerConfig.get(), (String)name);
            return (Receiver)alertManagerConfig.get().getReceivers().get(index);
        }
        return null;
    }

    public void addReceiver(Receiver receiver, Project project) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        ConfigUtil.fixReceiverName(receiver, project);
        this.addReceiver(receiver);
    }

    public void addReceiver(Receiver receiver) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        this.amConfigUpdater.addReceiver(this.alertManagerConfigController, this.amClient.getClient(), receiver, this.alertManagerConfigFacade, this.alertReceiverFacade);
        this.broadcast("Alert Manager Config receiver added");
    }

    private void checkPermission(String name, Project project, boolean includeGlobal) throws AlertManagerAccessControlException {
        if (Strings.isNullOrEmpty((String)name) || !name.startsWith("%%project%%__".replace("%%project%%", project.getName())) && (!includeGlobal || !name.startsWith("global-receiver__"))) {
            throw new AlertManagerAccessControlException("You do not have permission to access this receiver. Receiver=" + name);
        }
    }

    public void updateReceiver(String name, Receiver receiver, Project project) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        this.checkPermission(name, project, false);
        ConfigUtil.fixReceiverName(receiver, project);
        this.updateReceiver(name, receiver);
    }

    public void updateReceiver(String name, Receiver receiver) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        this.amConfigUpdater.updateReceiver(this.alertManagerConfigController, this.amClient.getClient(), name, receiver, this.alertManagerConfigFacade, this.alertReceiverFacade);
        this.broadcast("Alert Manager Config receiver updated");
    }

    public void removeReceiver(String name, Project project, boolean cascade) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        this.checkPermission(name, project, false);
        this.removeReceiver(name, cascade);
    }

    public void removeReceiver(String name, boolean cascade) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        boolean remover = this.amConfigUpdater.removeReceiver(this.alertManagerConfigController, this.amClient.getClient(), name, cascade, this.alertManagerConfigFacade, this.alertReceiverFacade);
        if (remover) {
            this.broadcast("Alert Manager Config receiver removed");
        }
    }

    @Lock(value=LockType.READ)
    public List<Route> getRoutes(Project project) throws AlertManagerConfigReadException {
        ArrayList<Route> projectRoutes = new ArrayList<Route>();
        List<Route> routeList = this.getRoutes();
        for (Route route : routeList) {
            if (!ConfigUtil.isRouteGlobal(route) && !ConfigUtil.isRouteInProject(route, project)) continue;
            projectRoutes.add(route);
        }
        return projectRoutes;
    }

    @Lock(value=LockType.READ)
    public List<Route> getRoutes() throws AlertManagerConfigReadException {
        Optional<AlertManagerConfig> alertManagerConfig = this.read();
        return alertManagerConfig.map(AlertManagerConfig::getRoute).orElse(new Route()).getRoutes();
    }

    @Lock(value=LockType.READ)
    public Route getRoute(Route route, Project project) throws AlertManagerNoSuchElementException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        if (project != null) {
            return this.getRoute(route.getReceiver(), route.getMatch(), route.getMatchRe(), project);
        }
        return this.getRoute(route.getReceiver(), route.getMatch(), route.getMatchRe());
    }

    @Lock(value=LockType.READ)
    public Route getRoute(String receiver, Map<String, String> match, Map<String, String> matchRe, Project project) throws AlertManagerConfigCtrlCreateException, AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        this.doSanityCheck();
        Route route = new Route(receiver).withMatch(match).withMatchRe(matchRe);
        List<Route> routes = this.getRoutes(project);
        int index = routes.indexOf(route);
        if (index < 0) {
            throw new AlertManagerNoSuchElementException("A route with the given receiver name was not found. Receiver Name=" + route.getReceiver());
        }
        return routes.get(index);
    }

    @Lock(value=LockType.READ)
    public Route getRoute(String receiver, Map<String, String> match, Map<String, String> matchRe) throws AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        Route route = new Route(receiver).withMatch(match).withMatchRe(matchRe);
        return this.getRoute(route);
    }

    @Lock(value=LockType.READ)
    public Route getRoute(Route route) throws AlertManagerNoSuchElementException, AlertManagerConfigReadException {
        Optional<AlertManagerConfig> alertManagerConfig = this.read();
        if (alertManagerConfig.isPresent()) {
            int index = ConfigUpdater.getIndexOfRoute((AlertManagerConfig)alertManagerConfig.get(), (Route)route);
            return (Route)alertManagerConfig.get().getRoute().getRoutes().get(index);
        }
        return null;
    }

    public void addRoute(Route route, Project project) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerAccessControlException, AlertManagerConfigReadException, AlertManagerNoSuchElementException {
        ConfigUtil.fixRoute(route, project);
        if (!Strings.isNullOrEmpty((String)route.getReceiver()) && !route.getReceiver().startsWith("%%project%%__".replace("%%project%%", project.getName()))) {
            throw new AlertManagerAccessControlException("You do not have permission to add a route with receiver=" + route.getReceiver());
        }
        this.addRoute(route);
    }

    public void addRoute(Route route) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigReadException, AlertManagerConfigCtrlCreateException, AlertManagerNoSuchElementException {
        this.doSanityCheck();
        this.amConfigUpdater.addRoute(this.alertManagerConfigController, this.amClient.getClient(), route, this.alertManagerConfigFacade);
        this.broadcast("Alert Manager Config route added");
    }

    private void checkPermission(Route route, Project project) throws AlertManagerAccessControlException {
        if (!ConfigUtil.isRouteInProject(route, project)) {
            throw new AlertManagerAccessControlException("You do not have permission to change this route. " + route);
        }
    }

    public void updateRoute(Route routeToUpdate, Route route, Project project) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerAccessControlException, AlertManagerConfigReadException {
        if ((route.getMatch() == null || route.getMatch().isEmpty()) && (route.getMatchRe() == null || route.getMatchRe().isEmpty())) {
            throw new AlertManagerNoSuchElementException("Need to set match or matchRe to find a route.");
        }
        this.checkPermission(routeToUpdate, project);
        ConfigUtil.fixRoute(route, project);
        this.updateRoute(routeToUpdate, route);
    }

    public void updateRoute(Route routeToUpdate, Route route) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        this.amConfigUpdater.updateRoute(this.alertManagerConfigController, this.amClient.getClient(), routeToUpdate, route, this.alertManagerConfigFacade);
        this.broadcast("Alert Manager Config route updated");
    }

    public void removeRoute(Route route, Project project) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        List<Route> routes = this.getRoutes(project);
        if (!routes.isEmpty() && routes.contains(route)) {
            this.removeRoute(route);
        }
    }

    public void removeRoute(Route route) throws AlertManagerConfigUpdateException, AlertManagerConfigCtrlCreateException, AlertManagerConfigReadException {
        this.doSanityCheck();
        boolean remover = this.amConfigUpdater.removeRoute(this.alertManagerConfigController, this.amClient.getClient(), route, this.alertManagerConfigFacade);
        if (remover) {
            this.broadcast("Alert Manager Config route removed");
        }
    }

    public void cleanProject(Project project) throws AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        boolean cleaned = this.amConfigUpdater.cleanProject(this.alertManagerConfigController, this.amClient.getClient(), project, this.alertManagerConfigFacade, this.alertReceiverFacade);
        if (cleaned) {
            this.broadcast("Alert Manager Config project cleanup for: " + project.getName());
        }
    }
}

