/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert.dao;

import io.hops.hopsworks.persistence.entity.alertmanager.AlertReceiver;
import java.util.List;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.json.JSONObject;

@Stateless
public class AlertReceiverFacade {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public void save(AlertReceiver entity) {
        this.em.persist((Object)entity);
    }

    public AlertReceiver update(AlertReceiver entity) {
        return (AlertReceiver)this.em.merge((Object)entity);
    }

    public void remove(AlertReceiver entity) {
        if (entity == null) {
            return;
        }
        this.em.remove(this.em.merge((Object)entity));
        this.em.flush();
    }

    public AlertReceiver find(Integer id) {
        return (AlertReceiver)this.em.find(AlertReceiver.class, (Object)id);
    }

    public List<AlertReceiver> findAll() {
        TypedQuery query = this.em.createNamedQuery("AlertReceiver.findAll", AlertReceiver.class);
        return query.getResultList();
    }

    public Optional<AlertReceiver> findByName(String name) {
        TypedQuery query = this.em.createNamedQuery("AlertReceiver.findByName", AlertReceiver.class).setParameter("name", (Object)name);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public void saveReceiverToDatabase(String oldName, String newName, JSONObject jsonObject) {
        Optional<AlertReceiver> optionalAlertReceiver = this.findByName(oldName);
        if (optionalAlertReceiver.isPresent()) {
            AlertReceiver alertReceiver = optionalAlertReceiver.get();
            alertReceiver.setName(newName);
            alertReceiver.setConfig(jsonObject);
            this.update(alertReceiver);
        } else {
            AlertReceiver alertReceiver = new AlertReceiver(newName, jsonObject);
            this.save(alertReceiver);
        }
    }

    public void removeReceiverFromDatabase(String name) {
        Optional<AlertReceiver> optionalAlertReceiver = this.findByName(name);
        optionalAlertReceiver.ifPresent(this::remove);
    }
}

