/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert.util;

import com.google.common.base.Strings;
import io.hops.hopsworks.alerting.api.alert.dto.PostableAlert;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertSeverity;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class PostableAlertBuilder {

    public static class Builder {
        private String projectName;
        private String jobName;
        private Integer executionId;
        private Integer featureGroupId;
        private String featureStoreName;
        private String featureGroupName;
        private Integer featureGroupVersion;
        private AlertType type;
        private AlertSeverity severity;
        private String status;
        private String summary;
        private String description;
        private URL generatorURL;

        public Builder(String projectName, AlertType type, AlertSeverity severity, String status) {
            this.projectName = projectName;
            this.type = type;
            this.severity = severity;
            this.status = status;
        }

        public Builder withJobName(String jobName) {
            if (this.featureGroupName != null || this.featureGroupId != null) {
                throw new IllegalArgumentException("Alert can be either job or feature group validation.");
            }
            this.jobName = jobName;
            return this;
        }

        public Builder withExecutionId(Integer executionId) {
            if (this.featureGroupName != null || this.featureGroupId != null) {
                throw new IllegalArgumentException("Alert can be either job or feature group validation.");
            }
            this.executionId = executionId;
            return this;
        }

        public Builder withFeatureGroupName(String featureGroupName) {
            if (this.jobName != null || this.executionId != null) {
                throw new IllegalArgumentException("Alert can be either job or feature group validation.");
            }
            this.featureGroupName = featureGroupName;
            return this;
        }

        public Builder withFeatureGroupId(Integer featureGroupId) {
            if (this.jobName != null || this.executionId != null) {
                throw new IllegalArgumentException("Alert can be either job or feature group validation.");
            }
            this.featureGroupId = featureGroupId;
            return this;
        }

        public Builder withFeatureStoreName(String featureStoreName) {
            if (this.jobName != null || this.executionId != null) {
                throw new IllegalArgumentException("Alert can be either job or feature group validation.");
            }
            this.featureStoreName = featureStoreName;
            return this;
        }

        public Builder withFeatureGroupVersion(Integer featureGroupVersion) {
            if (this.jobName != null || this.executionId != null) {
                throw new IllegalArgumentException("Alert can be either job or feature group validation.");
            }
            this.featureGroupVersion = featureGroupVersion;
            return this;
        }

        public Builder withSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withGeneratorURL(String generatorURL) {
            try {
                this.generatorURL = new URL(generatorURL);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("GeneratorURL should be a valid url. " + e.getMessage());
            }
            return this;
        }

        public PostableAlert build() {
            HashMap<String, String> labels = new HashMap<String, String>();
            HashMap<String, String> annotations = new HashMap<String, String>();
            labels.put("type", this.type.getValue());
            labels.put("project", this.projectName);
            labels.put("severity", this.severity.getName());
            labels.put("status", this.status);
            if (!Strings.isNullOrEmpty((String)this.jobName)) {
                labels.put("alertname", "JobExecution");
                labels.put("job", this.jobName);
                annotations.put("title", this.jobName);
            }
            if (this.executionId != null) {
                labels.put("executionId", this.executionId.toString());
            }
            if (!Strings.isNullOrEmpty((String)this.featureGroupName)) {
                labels.put("alertname", "FeatureValidation");
                labels.put("featureGroup", this.featureGroupName);
                annotations.put("title", this.featureGroupName);
            }
            if (!Strings.isNullOrEmpty((String)this.featureStoreName)) {
                labels.put("featureStore", this.featureStoreName);
            }
            if (this.featureGroupId != null) {
                labels.put("featureGroupId", this.featureGroupId.toString());
            }
            if (this.featureGroupVersion != null) {
                labels.put("featureGroupVersion", this.featureGroupVersion.toString());
            }
            if (Strings.isNullOrEmpty((String)this.summary) || Strings.isNullOrEmpty((String)this.description)) {
                throw new IllegalArgumentException("Summary and description can not be empty.");
            }
            annotations.put("summary", this.summary);
            annotations.put("description", this.description);
            PostableAlert postableAlert = new PostableAlert(labels, annotations);
            if (this.generatorURL != null) {
                postableAlert.setGeneratorURL(this.generatorURL);
            }
            return postableAlert;
        }
    }
}

