/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert.dao;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.hops.hopsworks.alerting.config.dto.AlertManagerConfig;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigReadException;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertManagerConfigEntity;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.json.JSONObject;

@Stateless
public class AlertManagerConfigFacade {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public void save(AlertManagerConfigEntity entity) {
        this.em.persist((Object)entity);
    }

    public AlertManagerConfigEntity update(AlertManagerConfigEntity entity) {
        return (AlertManagerConfigEntity)this.em.merge((Object)entity);
    }

    public void remove(AlertManagerConfigEntity entity) {
        if (entity == null) {
            return;
        }
        this.em.remove(this.em.merge((Object)entity));
        this.em.flush();
    }

    public AlertManagerConfigEntity find(Integer id) {
        return (AlertManagerConfigEntity)this.em.find(AlertManagerConfigEntity.class, (Object)id);
    }

    public List<AlertManagerConfigEntity> findAllSortedByCreated() {
        TypedQuery query = this.em.createNamedQuery("AlertManagerConfigEntity.findAllSortedByCreated", AlertManagerConfigEntity.class);
        return query.getResultList();
    }

    public Optional<AlertManagerConfigEntity> getLatest() {
        List<AlertManagerConfigEntity> alertManagerConfigEntities = this.findAllSortedByCreated();
        if (alertManagerConfigEntities == null || alertManagerConfigEntities.size() < 1) {
            return Optional.empty();
        }
        return Optional.of(alertManagerConfigEntities.get(0));
    }

    public Optional<AlertManagerConfig> read(ObjectMapper objectMapper) throws AlertManagerConfigReadException {
        Optional<AlertManagerConfigEntity> optionalAlertManagerConfigEntity = this.getLatest();
        if (optionalAlertManagerConfigEntity.isPresent()) {
            try {
                JSONObject jsonAlertManagerConfigBackup = optionalAlertManagerConfigEntity.get().getContent();
                return Optional.of(objectMapper.readValue(jsonAlertManagerConfigBackup.toString(), AlertManagerConfig.class));
            }
            catch (Exception e) {
                throw new AlertManagerConfigReadException("Failed to revert alert manger config from database. " + e.getMessage(), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public void saveToDatabase(JSONObject jsonObject) {
        Optional<AlertManagerConfigEntity> optionalAlertManagerConfigEntity = this.getLatest();
        if (!optionalAlertManagerConfigEntity.isPresent()) {
            AlertManagerConfigEntity alertManagerConfigEntity = new AlertManagerConfigEntity();
            alertManagerConfigEntity.setContent(jsonObject);
            alertManagerConfigEntity.setCreated(new Date());
            this.save(alertManagerConfigEntity);
        } else {
            AlertManagerConfigEntity alertManagerConfigEntity = optionalAlertManagerConfigEntity.get();
            alertManagerConfigEntity.setContent(jsonObject);
            alertManagerConfigEntity.setCreated(new Date());
            this.update(alertManagerConfigEntity);
        }
    }
}

