/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.hops.hopsworks.alert.exception.AlertManagerAccessControlException;
import io.hops.hopsworks.alert.exception.AlertManagerUnreachableException;
import io.hops.hopsworks.alert.util.VariablesFacade;
import io.hops.hopsworks.alerting.api.AlertManagerClient;
import io.hops.hopsworks.alerting.api.alert.dto.Alert;
import io.hops.hopsworks.alerting.api.alert.dto.AlertGroup;
import io.hops.hopsworks.alerting.api.alert.dto.AlertmanagerStatus;
import io.hops.hopsworks.alerting.api.alert.dto.Matcher;
import io.hops.hopsworks.alerting.api.alert.dto.PostableAlert;
import io.hops.hopsworks.alerting.api.alert.dto.PostableSilence;
import io.hops.hopsworks.alerting.api.alert.dto.ReceiverName;
import io.hops.hopsworks.alerting.api.alert.dto.Silence;
import io.hops.hopsworks.alerting.api.alert.dto.SilenceID;
import io.hops.hopsworks.alerting.api.util.Settings;
import io.hops.hopsworks.alerting.exceptions.AlertManagerClientCreateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerResponseException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerServerException;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertType;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.user.Users;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Response;

@Singleton
@Lock(value=LockType.READ)
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AMClient {
    private static final Logger LOGGER = Logger.getLogger(AMClient.class.getName());
    private AlertManagerClient client;
    private Exception initException;
    private int count = 0;
    private int serverErrorCount = 0;
    @EJB
    private VariablesFacade variablesFacade;
    @Resource
    TimerService timerService;

    @PostConstruct
    public void init() {
        this.tryBuildClient();
    }

    void registerServerError() {
        ++this.serverErrorCount;
        if (this.serverErrorCount > 5) {
            this.count = 0;
            this.serverErrorCount = 0;
            this.client.close();
            this.client = null;
            Settings.clearCache();
            this.tryBuildClient();
        }
    }

    public AMClient() {
    }

    @VisibleForTesting
    public AMClient(AlertManagerClient client) {
        this.client = client;
    }

    void registerSuccess() {
        this.serverErrorCount = 0;
    }

    public int getServerErrorCount() {
        return this.serverErrorCount;
    }

    void tryBuildClient() {
        String domain = this.variablesFacade.getVariableValue("service_discovery_domain").orElse("");
        try {
            this.client = new AlertManagerClient.Builder(ClientBuilder.newClient()).withServiceDN(domain).build();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to init Alertmanager client. " + e.getMessage());
            this.initException = e;
            this.createRetryTimer();
        }
    }

    void createRetryTimer() {
        long duration = 20000L;
        if (this.count > 6) {
            duration *= 6L;
        } else {
            ++this.count;
        }
        TimerConfig config = new TimerConfig();
        config.setInfo((Serializable)((Object)"Retry client"));
        config.setPersistent(false);
        this.timerService.createSingleActionTimer(duration, config);
    }

    @PreDestroy
    public void preDestroy() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void performTimeout(Timer timer) {
        this.tryBuildClient();
    }

    private void doClientSanityCheck() throws AlertManagerClientCreateException {
        if (this.client == null) {
            if (this.initException != null) {
                throw new AlertManagerClientCreateException((Throwable)this.initException);
            }
            throw new AlertManagerClientCreateException("Failed to instantiate AlertManagerClient");
        }
    }

    public AlertManagerClient getClient() {
        return this.client;
    }

    public Response healthy() throws AlertManagerClientCreateException, AlertManagerResponseException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            Response response = this.client.healthy();
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public Response ready() throws AlertManagerClientCreateException, AlertManagerResponseException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            Response response = this.client.ready();
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public Response reload() throws AlertManagerClientCreateException, AlertManagerResponseException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            Response response = this.client.reload();
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public AlertmanagerStatus getStatus() throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            AlertmanagerStatus response = this.client.getStatus();
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public List<ReceiverName> getReceivers(Project project, boolean includeGlobal) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        List<ReceiverName> receivers = this.getReceivers();
        if (receivers == null || receivers.isEmpty()) {
            return Collections.emptyList();
        }
        return receivers.stream().filter(receiver -> receiver.getName().startsWith("%%project%%__".replace("%%project%%", project.getName())) || includeGlobal && receiver.getName().startsWith("global-receiver__")).collect(Collectors.toList());
    }

    public List<ReceiverName> getReceivers() throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            List response = this.client.getReceivers();
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public List<Silence> getSilences(Set<String> filters, Project project) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException, AlertManagerAccessControlException {
        filters = this.getFilters(filters, project);
        return this.getSilences(filters);
    }

    public List<Silence> getSilences(Set<String> filters) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            List response = this.client.getSilences(filters);
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public Optional<Silence> getSilence(String uuid, Project project) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        Silence silence = this.getSilence(uuid);
        if (silence == null) {
            return Optional.empty();
        }
        for (Matcher matcher : silence.getMatchers()) {
            if (!matcher.getName().equals("project") || !matcher.getValue().startsWith(project.getName())) continue;
            return Optional.of(silence);
        }
        return Optional.empty();
    }

    public Silence getSilence(String uuid) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            Silence response = this.client.getSilence(uuid);
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public SilenceID postSilences(PostableSilence postableSilence, Project project, Users user) throws AlertManagerClientCreateException, AlertManagerResponseException, AlertManagerUnreachableException, AlertManagerAccessControlException {
        postableSilence.setCreatedBy("%%user%%@%%project%%".replace("%%user%%", user.getUsername()).replace("%%project%%", project.getName()));
        if (Strings.isNullOrEmpty((String)postableSilence.getComment())) {
            throw new IllegalArgumentException("Comment is required.");
        }
        if (postableSilence.getMatchers() == null || postableSilence.getMatchers().isEmpty()) {
            throw new IllegalArgumentException("Matchers can not be empty.");
        }
        boolean containsProject = false;
        for (Matcher matcher : postableSilence.getMatchers()) {
            if (!matcher.getName().equals("project")) continue;
            containsProject = true;
            if (matcher.getValue().startsWith(project.getName())) continue;
            throw new AlertManagerAccessControlException("You do not have permission to access silence with " + matcher.getName() + "=" + matcher.getValue());
        }
        if (!containsProject) {
            postableSilence.getMatchers().add(new Matcher(Boolean.valueOf(false), "project", project.getName()));
        }
        return this.postSilences(postableSilence);
    }

    public SilenceID postSilences(PostableSilence postableSilence) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            SilenceID response = this.client.postSilences(postableSilence);
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public Response deleteSilence(String uuid, Project project) throws AlertManagerClientCreateException, AlertManagerResponseException, AlertManagerUnreachableException {
        Optional<Silence> silence = this.getSilence(uuid, project);
        if (silence.isPresent()) {
            return this.deleteSilence(uuid);
        }
        return Response.ok().build();
    }

    public Response deleteSilence(String uuid) throws AlertManagerClientCreateException, AlertManagerResponseException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            Response response = this.client.deleteSilence(uuid);
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public List<Alert> getAlerts(Project project) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        List<Alert> alerts = this.getAlerts();
        ArrayList<Alert> projectAlerts = new ArrayList<Alert>();
        for (Alert alert : alerts) {
            if (alert.getLabels().get("project") == null || !((String)alert.getLabels().get("project")).equals(project.getName())) continue;
            projectAlerts.add(alert);
        }
        return projectAlerts;
    }

    public List<Alert> getAlerts() throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            List response = this.client.getAlerts();
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public List<Alert> getAlerts(Boolean active, Boolean silenced, Boolean inhibited, Boolean unprocessed, Set<String> filters, String receiver, Project project) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException, AlertManagerAccessControlException {
        filters = this.getFilters(filters, project);
        return this.getAlerts(active, silenced, inhibited, unprocessed, filters, receiver);
    }

    public List<Alert> getAlerts(Boolean active, Boolean silenced, Boolean inhibited, Boolean unprocessed, Set<String> filters, String receiver) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            List response = this.client.getAlerts(active, silenced, inhibited, unprocessed, filters, receiver);
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public Response postAlert(PostableAlert postableAlert, Project project) throws AlertManagerClientCreateException, AlertManagerResponseException, AlertManagerUnreachableException, AlertManagerAccessControlException {
        ArrayList<PostableAlert> postableAlerts = new ArrayList<PostableAlert>();
        postableAlerts.add(postableAlert);
        return this.postAlerts(postableAlerts, project);
    }

    public Response postAlerts(List<PostableAlert> postableAlerts, Project project) throws AlertManagerClientCreateException, AlertManagerResponseException, AlertManagerUnreachableException, AlertManagerAccessControlException {
        for (PostableAlert postableAlert : postableAlerts) {
            if (postableAlert.getLabels() == null) {
                throw new IllegalArgumentException("Labels can not be empty.");
            }
            if (postableAlert.getLabels().get("project") != null) {
                if (!((String)postableAlert.getLabels().get("project")).startsWith(project.getName())) {
                    throw new AlertManagerAccessControlException("You do not have permission to create alerts for project=" + (String)postableAlert.getLabels().get("project"));
                }
            } else {
                postableAlert.getLabels().put("project", project.getName());
            }
            if (postableAlert.getLabels().get("type") != null) {
                AlertType type = AlertType.fromValue((String)((String)postableAlert.getLabels().get("type")));
                if (type == null) {
                    throw new IllegalArgumentException("Value for label type not recognized.");
                }
                if (!AlertType.SYSTEM_ALERT.equals((Object)type)) continue;
                throw new AlertManagerAccessControlException("You do not have permission to create alerts for type=" + AlertType.SYSTEM_ALERT.getValue());
            }
            postableAlert.getLabels().put("type", AlertType.PROJECT_ALERT.getValue());
        }
        return this.postAlerts(postableAlerts);
    }

    @Asynchronous
    public void asyncPostAlerts(List<PostableAlert> postableAlerts) {
        try {
            this.postAlerts(postableAlerts);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not send alert", e);
        }
    }

    public Response postAlerts(List<PostableAlert> postableAlerts) throws AlertManagerClientCreateException, AlertManagerResponseException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            Response response = this.client.postAlerts(postableAlerts);
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    public List<AlertGroup> getAlertGroups(Boolean active, Boolean silenced, Boolean inhibited, Set<String> filters, String receiver, Project project) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException, AlertManagerAccessControlException {
        filters = this.getFilters(filters, project);
        return this.getAlertGroups(active, silenced, inhibited, filters, receiver);
    }

    public List<AlertGroup> getAlertGroups(Boolean active, Boolean silenced, Boolean inhibited, Set<String> filters, String receiver) throws AlertManagerResponseException, AlertManagerClientCreateException, AlertManagerUnreachableException {
        this.doClientSanityCheck();
        try {
            List response = this.client.getAlertGroups(active, silenced, inhibited, filters, receiver);
            this.registerSuccess();
            return response;
        }
        catch (AlertManagerServerException e) {
            this.registerServerError();
            throw new AlertManagerUnreachableException("Alertmanager not reachable." + e.getMessage(), e);
        }
    }

    private Set<String> getFilters(Set<String> filters, Project project) throws AlertManagerAccessControlException {
        if (filters == null) {
            filters = new HashSet<String>();
        }
        boolean containsProject = false;
        String projectFilter = "project=\"%%project%%\"".replace("%%project%%", project.getName());
        for (String filter : filters) {
            if (!filter.startsWith("project=\"")) continue;
            containsProject = true;
            if (filter.equals(projectFilter)) continue;
            throw new AlertManagerAccessControlException("You do not have permission to create alerts for " + filter);
        }
        if (!containsProject) {
            filters.add(projectFilter);
        }
        return filters;
    }
}

