/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import io.hops.hopsworks.alert.AlertManagerConfiguration;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;

@Startup
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AMConfigMessageListener {
    private static final Logger LOGGER = Logger.getLogger(AMConfigMessageListener.class.getName());
    private ITopic<String> configUpdatedTopic;
    private UUID msgListenerId;
    @Inject
    private HazelcastInstance hazelcastInstance;
    @EJB
    private AlertManagerConfiguration alertManagerConfiguration;

    @PostConstruct
    public void init() {
        if (this.hazelcastInstance != null) {
            this.configUpdatedTopic = this.hazelcastInstance.getTopic("alertmanager_config_updated");
            this.msgListenerId = this.configUpdatedTopic.addMessageListener((MessageListener)new MessageListenerImpl());
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.configUpdatedTopic != null) {
            this.configUpdatedTopic.removeMessageListener(this.msgListenerId);
        }
    }

    public class MessageListenerImpl
    implements MessageListener<String> {
        public void onMessage(Message<String> message) {
            LOGGER.log(Level.INFO, "Got notification from UUID: {0}, This: {1}, Message: {2}", new Object[]{message.getPublishingMember().getUuid(), message.getPublishingMember().localMember(), message.getMessageObject()});
            if (!message.getPublishingMember().localMember()) {
                try {
                    AMConfigMessageListener.this.alertManagerConfiguration.restoreFromDb();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to update alert manager configuration from database. Got notification from UUID={0}. {1}", new Object[]{message.getPublishingMember().getUuid(), e.getMessage()});
                }
            }
        }
    }
}

