/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.hops.hopsworks.alert.AlertManagerConfiguration;
import io.hops.hopsworks.alert.dao.AlertManagerConfigFacade;
import io.hops.hopsworks.alert.dao.AlertReceiverFacade;
import io.hops.hopsworks.alert.util.ConfigUtil;
import io.hops.hopsworks.alerting.config.dto.AlertManagerConfig;
import io.hops.hopsworks.alerting.config.dto.Receiver;
import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigReadException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigUpdateException;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertReceiver;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.alert.FeatureGroupAlert;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.alert.FeatureViewAlert;
import io.hops.hopsworks.persistence.entity.jobs.description.JobAlert;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;

@Singleton
public class FixReceiversTimer {
    private static final Logger LOGGER = Logger.getLogger(FixReceiversTimer.class.getName());
    @EJB
    private AlertManagerConfigFacade alertManagerConfigFacade;
    @EJB
    private AlertReceiverFacade alertReceiverFacade;
    @EJB
    private AlertManagerConfiguration alertManagerConfiguration;

    public FixReceiversTimer() {
    }

    @VisibleForTesting
    public FixReceiversTimer(AlertManagerConfigFacade alertManagerConfigFacade, AlertReceiverFacade alertReceiverFacade, AlertManagerConfiguration alertManagerConfiguration) {
        this.alertManagerConfigFacade = alertManagerConfigFacade;
        this.alertReceiverFacade = alertReceiverFacade;
        this.alertManagerConfiguration = alertManagerConfiguration;
    }

    @Schedule(hour="*", info="Fix Alert Manager config receivers from backup.")
    public void fixReceiversTimer() {
        try {
            this.runFixConfig();
            LOGGER.log(Level.FINE, "Fix Alert Manager config receivers from backup.");
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to fix Alert Manager config from backup. {0}", e.getMessage());
        }
    }

    public Optional<AlertManagerConfig> read(ObjectMapper objectMapper) throws AlertManagerConfigReadException {
        return this.alertManagerConfigFacade.read(objectMapper);
    }

    private boolean fixReceivers(AlertManagerConfig alertManagerConfig, ObjectMapper objectMapper, List<AlertReceiver> alertReceivers) throws IOException {
        List<Route> routes = this.getRoutes(alertManagerConfig);
        List<Receiver> receivers = alertManagerConfig.getReceivers() == null ? new ArrayList() : alertManagerConfig.getReceivers();
        ArrayList<Receiver> receiversToAdd = new ArrayList<Receiver>();
        for (AlertReceiver alertReceiver : alertReceivers) {
            Receiver receiver = this.receiverToAdd(receivers, alertReceiver, objectMapper);
            if (receiver == null || receiversToAdd.contains(receiver)) continue;
            receiversToAdd.add(receiver);
        }
        ArrayList<Receiver> receiversToRemove = new ArrayList<Receiver>();
        for (Receiver receiver : receivers) {
            Optional<AlertReceiver> alertReceiver = this.alertReceiverFacade.findByName(receiver.getName());
            if (alertReceiver.isPresent() || !this.isNotSystemReceiver(alertManagerConfig, receiver)) continue;
            receiversToRemove.add(receiver);
        }
        if (!receiversToAdd.isEmpty() || !receiversToRemove.isEmpty()) {
            if (!receiversToAdd.isEmpty()) {
                receivers.addAll(receiversToAdd);
                LOGGER.log(Level.INFO, "Alert manager config updated. Added {0} receivers.", receiversToAdd.size());
            }
            if (!receiversToRemove.isEmpty()) {
                ArrayList<Route> arrayList = new ArrayList<Route>();
                for (Route route : routes) {
                    if (!receiversToRemove.contains(new Receiver(route.getReceiver()))) continue;
                    arrayList.add(route);
                }
                if (!arrayList.isEmpty()) {
                    alertManagerConfig.getRoute().getRoutes().removeAll(arrayList);
                    LOGGER.log(Level.INFO, "Alert manager config updated. Removed {0} routes.", arrayList.size());
                }
                receivers.removeAll(receiversToRemove);
                LOGGER.log(Level.INFO, "Alert manager config updated. Removed {0} receivers.", receiversToRemove.size());
            }
            alertManagerConfig.setReceivers(receivers);
            return true;
        }
        return false;
    }

    private boolean isNotSystemReceiver(AlertManagerConfig alertManagerConfig, Receiver receiver) {
        if (alertManagerConfig.getRoute() == null) {
            return true;
        }
        if (alertManagerConfig.getRoute().getReceiver().equals(receiver.getName())) {
            return false;
        }
        List routes = alertManagerConfig.getRoute().getRoutes();
        for (Route route : routes) {
            Map match = route.getMatch() != null ? route.getMatch() : route.getMatchRe();
            String alertType = match != null && match.get("type") != null ? (String)match.get("type") : null;
            if (alertType == null || !alertType.equals(AlertType.SYSTEM_ALERT.getValue()) || !route.getReceiver().equals(receiver.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean fixRoutes(AlertManagerConfig alertManagerConfig, List<AlertReceiver> alertReceivers) {
        List<Route> routes = this.getRoutes(alertManagerConfig);
        ArrayList<Route> routesToAdd = new ArrayList<Route>();
        for (AlertReceiver alertReceiver : alertReceivers) {
            if (alertReceiver.getName().equals(AlertType.DEFAULT.getValue())) continue;
            routesToAdd.addAll(this.getRoutesToAdd(alertReceiver, routes));
        }
        if (!routesToAdd.isEmpty()) {
            alertManagerConfig.getRoute().getRoutes().addAll(routesToAdd);
            LOGGER.log(Level.INFO, "Alert manager config updated. Added {0} routes.", routesToAdd.size());
            return true;
        }
        return false;
    }

    private List<Route> getRoutesToAdd(AlertReceiver alertReceiver, List<Route> routes) {
        Route route;
        Collection jobAlerts = alertReceiver.getJobAlertCollection();
        Collection featureGroupAlerts = alertReceiver.getFeatureGroupAlertCollection();
        Collection projectServiceAlerts = alertReceiver.getProjectServiceAlertCollection();
        Collection featureViewAlerts = alertReceiver.getFeatureViewAlertCollection();
        ArrayList<Route> routesToAdd = new ArrayList<Route>();
        for (JobAlert jobAlert : jobAlerts) {
            route = jobAlert.getAlertType().isGlobal() ? ConfigUtil.getRoute(jobAlert.getAlertType()) : ConfigUtil.getRoute(jobAlert);
            if (routes.contains(route) || routesToAdd.contains(route)) continue;
            routesToAdd.add(route);
        }
        for (FeatureGroupAlert featureGroupAlert : featureGroupAlerts) {
            route = featureGroupAlert.getAlertType().isGlobal() ? ConfigUtil.getRoute(featureGroupAlert.getAlertType()) : ConfigUtil.getRoute(featureGroupAlert);
            if (routes.contains(route) || routesToAdd.contains(route)) continue;
            routesToAdd.add(route);
        }
        for (ProjectServiceAlert projectServiceAlert : projectServiceAlerts) {
            route = projectServiceAlert.getAlertType().isGlobal() ? ConfigUtil.getRoute(projectServiceAlert.getAlertType()) : ConfigUtil.getRoute(projectServiceAlert);
            if (routes.contains(route) || routesToAdd.contains(route)) continue;
            routesToAdd.add(route);
        }
        if (featureViewAlerts != null) {
            for (FeatureViewAlert featureViewAlert : featureViewAlerts) {
                route = featureViewAlert.getAlertType().isGlobal() ? ConfigUtil.getRoute(featureViewAlert.getAlertType()) : ConfigUtil.getRoute(featureViewAlert);
                if (routes.contains(route) || routesToAdd.contains(route)) continue;
                routesToAdd.add(route);
            }
        }
        return routesToAdd;
    }

    private Receiver receiverToAdd(List<Receiver> receivers, AlertReceiver alertReceiver, ObjectMapper objectMapper) throws IOException {
        Receiver receiverToAdd = null;
        if (!receivers.contains(new Receiver(alertReceiver.getName()))) {
            receiverToAdd = (Receiver)objectMapper.readValue(alertReceiver.getConfig().toString(), Receiver.class);
        }
        return receiverToAdd;
    }

    private List<Route> getRoutes(AlertManagerConfig alertManagerConfig) {
        if (alertManagerConfig.getRoute() == null) {
            alertManagerConfig.setRoute(new Route().withRoutes(new ArrayList()));
        } else if (alertManagerConfig.getRoute().getRoutes() == null) {
            alertManagerConfig.getRoute().setRoutes(new ArrayList());
        }
        return alertManagerConfig.getRoute().getRoutes();
    }

    public void runFixConfig() throws AlertManagerConfigReadException, IOException, AlertManagerConfigUpdateException {
        ObjectMapper objectMapper = new ObjectMapper();
        Optional<AlertManagerConfig> alertManagerConfig = this.read(objectMapper);
        if (alertManagerConfig.isPresent()) {
            List<AlertReceiver> alertReceivers = this.alertReceiverFacade.findAll();
            AlertManagerConfig aMConfig = alertManagerConfig.get();
            boolean updatedReceivers = this.fixReceivers(aMConfig, objectMapper, alertReceivers);
            boolean updatedRoutes = this.fixRoutes(aMConfig, alertReceivers);
            if (updatedReceivers || updatedRoutes) {
                this.alertManagerConfiguration.writeAndReload(aMConfig);
            }
        }
    }
}

