/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import fish.payara.cluster.Clustered;
import io.hops.hopsworks.alert.dao.AlertManagerConfigFacade;
import io.hops.hopsworks.alert.dao.AlertReceiverFacade;
import io.hops.hopsworks.alert.util.ConfigUtil;
import io.hops.hopsworks.alerting.api.AlertManagerClient;
import io.hops.hopsworks.alerting.config.AlertManagerConfigController;
import io.hops.hopsworks.alerting.config.ConfigUpdater;
import io.hops.hopsworks.alerting.config.dto.AlertManagerConfig;
import io.hops.hopsworks.alerting.config.dto.Global;
import io.hops.hopsworks.alerting.config.dto.InhibitRule;
import io.hops.hopsworks.alerting.config.dto.Receiver;
import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigReadException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerConfigUpdateException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerDuplicateEntryException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerNoSuchElementException;
import io.hops.hopsworks.alerting.exceptions.AlertManagerServerException;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertManagerConfigEntity;
import io.hops.hopsworks.persistence.entity.project.Project;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.ejb.Singleton;
import org.json.JSONObject;

@Clustered
@Singleton
public class AMConfigUpdater
implements Serializable {
    private static final long serialVersionUID = 7243440946325768353L;

    @VisibleForTesting
    public AMConfigUpdater() {
    }

    public void updateAlertManagerConfig(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, AlertManagerConfig alertManagerConfig) throws AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        try {
            alertManagerConfigController.writeAndReload(alertManagerConfig, client);
        }
        catch (AlertManagerServerException e) {
            throw new AlertManagerConfigUpdateException("AlertManager server unreachable.", (Throwable)e);
        }
    }

    public void restoreFromDb(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerConfigUpdateException {
        Optional<AlertManagerConfigEntity> optionalAlertManagerConfigEntity = alertManagerConfigFacade.getLatest();
        if (optionalAlertManagerConfigEntity.isPresent()) {
            ObjectMapper objectMapper = new ObjectMapper();
            JSONObject jsonAlertManagerConfigBackup = optionalAlertManagerConfigEntity.get().getContent();
            try {
                AlertManagerConfig alertManagerConfigBackup = (AlertManagerConfig)objectMapper.readValue(jsonAlertManagerConfigBackup.toString(), AlertManagerConfig.class);
                this.updateAlertManagerConfig(alertManagerConfigController, client, alertManagerConfigBackup);
            }
            catch (Exception e) {
                throw new AlertManagerConfigUpdateException("Failed to revert alert manger config from database. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void saveToDatabase(AlertManagerConfig alertManagerConfig, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerConfigUpdateException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JSONObject jsonObject = new JSONObject(objectMapper.writeValueAsString((Object)alertManagerConfig));
            alertManagerConfigFacade.saveToDatabase(jsonObject);
        }
        catch (JsonProcessingException e) {
            throw new AlertManagerConfigUpdateException("Can not save config to database. Failed to parse config to json. " + e.getMessage(), (Throwable)e);
        }
    }

    private void saveConfigAndReceiver(JSONObject alertManagerConfig, String oldName, String newName, JSONObject alertReceiver, AlertManagerConfigFacade alertManagerConfigFacade, AlertReceiverFacade alertReceiverFacade) {
        alertManagerConfigFacade.saveToDatabase(alertManagerConfig);
        if (alertReceiver != null) {
            alertReceiverFacade.saveReceiverToDatabase(oldName, newName, alertReceiver);
        } else {
            alertReceiverFacade.removeReceiverFromDatabase(oldName);
        }
    }

    private void saveToDatabase(AlertManagerConfig alertManagerConfig, String receiverName, Receiver receiver, AlertManagerConfigFacade alertManagerConfigFacade, AlertReceiverFacade alertReceiverFacade) throws AlertManagerConfigUpdateException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JSONObject alertManagerConfigJson = new JSONObject(objectMapper.writeValueAsString((Object)alertManagerConfig));
            JSONObject receiverJson = null;
            String newReceiverName = null;
            if (receiver != null) {
                receiverJson = new JSONObject(objectMapper.writeValueAsString((Object)receiver));
                newReceiverName = receiver.getName();
            }
            this.saveConfigAndReceiver(alertManagerConfigJson, receiverName, newReceiverName, receiverJson, alertManagerConfigFacade, alertReceiverFacade);
        }
        catch (JsonProcessingException e) {
            throw new AlertManagerConfigUpdateException("Can not save config to database. Failed to parse config to json. " + e.getMessage(), (Throwable)e);
        }
    }

    public void writeAndReload(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, AlertManagerConfig alertManagerConfig, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        if (alertManagerConfig != null) {
            this.updateAlertManagerConfig(alertManagerConfigController, client, alertManagerConfig);
            try {
                this.saveToDatabase(alertManagerConfig, alertManagerConfigFacade);
            }
            catch (Exception e) {
                this.restoreFromDb(alertManagerConfigController, client, alertManagerConfigFacade);
                throw e;
            }
        }
    }

    public void writeAndReload(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, AlertManagerConfig alertManagerConfig, String name, Receiver receiver, AlertManagerConfigFacade alertManagerConfigFacade, AlertReceiverFacade alertReceiverFacade) throws AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        if (alertManagerConfig != null) {
            this.updateAlertManagerConfig(alertManagerConfigController, client, alertManagerConfig);
            try {
                this.saveToDatabase(alertManagerConfig, name, receiver, alertManagerConfigFacade, alertReceiverFacade);
            }
            catch (Exception e) {
                this.restoreFromDb(alertManagerConfigController, client, alertManagerConfigFacade);
                throw e;
            }
        }
    }

    private AlertManagerConfig read(AlertManagerConfigController alertManagerConfigController, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerConfigReadException {
        ObjectMapper objectMapper = new ObjectMapper();
        Optional<AlertManagerConfig> alertManagerConfig = alertManagerConfigFacade.read(objectMapper);
        return alertManagerConfig.orElse(alertManagerConfigController.read());
    }

    public void updateGlobal(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, Global global, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        ConfigUpdater.updateGlobal((AlertManagerConfig)alertManagerConfig, (Global)global);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, alertManagerConfigFacade);
    }

    public void updateTemplates(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, List<String> templates, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        ConfigUpdater.updateTemplates((AlertManagerConfig)alertManagerConfig, templates);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, alertManagerConfigFacade);
    }

    public void updateGlobalRoute(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, Route route, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        ConfigUpdater.updateGlobalRoute((AlertManagerConfig)alertManagerConfig, (Route)route);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, alertManagerConfigFacade);
    }

    public void updateInhibitRules(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, List<InhibitRule> inhibitRules, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        ConfigUpdater.updateInhibitRules((AlertManagerConfig)alertManagerConfig, inhibitRules);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, alertManagerConfigFacade);
    }

    public void addReceiver(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, Receiver receiver, AlertManagerConfigFacade alertManagerConfigFacade, AlertReceiverFacade alertReceiverFacade) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        ConfigUpdater.addReceiver((AlertManagerConfig)alertManagerConfig, (Receiver)receiver);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, receiver.getName(), receiver, alertManagerConfigFacade, alertReceiverFacade);
    }

    public void updateReceiver(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, String name, Receiver receiver, AlertManagerConfigFacade alertManagerConfigFacade, AlertReceiverFacade alertReceiverFacade) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        ConfigUpdater.updateReceiver((AlertManagerConfig)alertManagerConfig, (String)name, (Receiver)receiver);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, name, receiver, alertManagerConfigFacade, alertReceiverFacade);
    }

    public boolean removeReceiver(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, String name, boolean cascade, AlertManagerConfigFacade alertManagerConfigFacade, AlertReceiverFacade alertReceiverFacade) throws AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        alertManagerConfig = ConfigUpdater.removeReceiver((AlertManagerConfig)alertManagerConfig, (String)name, (boolean)cascade);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, name, null, alertManagerConfigFacade, alertReceiverFacade);
        return alertManagerConfig != null;
    }

    public void addRoute(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, Route route, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigReadException, AlertManagerNoSuchElementException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        ConfigUpdater.addRoute((AlertManagerConfig)alertManagerConfig, (Route)route);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, alertManagerConfigFacade);
    }

    public void updateRoute(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, Route routeToUpdate, Route route, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerNoSuchElementException, AlertManagerDuplicateEntryException, AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        ConfigUpdater.updateRoute((AlertManagerConfig)alertManagerConfig, (Route)routeToUpdate, (Route)route);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, alertManagerConfigFacade);
    }

    public boolean removeRoute(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, Route route, AlertManagerConfigFacade alertManagerConfigFacade) throws AlertManagerConfigUpdateException, AlertManagerConfigReadException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        alertManagerConfig = ConfigUpdater.removeRoute((AlertManagerConfig)alertManagerConfig, (Route)route);
        this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, alertManagerConfigFacade);
        return alertManagerConfig != null;
    }

    public boolean cleanProject(AlertManagerConfigController alertManagerConfigController, AlertManagerClient client, Project project, AlertManagerConfigFacade alertManagerConfigFacade, AlertReceiverFacade alertReceiverFacade) throws AlertManagerConfigReadException, AlertManagerConfigUpdateException {
        AlertManagerConfig alertManagerConfig = this.read(alertManagerConfigController, alertManagerConfigFacade);
        List routes = alertManagerConfig.getRoute() == null || alertManagerConfig.getRoute().getRoutes() == null ? Collections.emptyList() : alertManagerConfig.getRoute().getRoutes();
        List receivers = alertManagerConfig.getReceivers() == null ? Collections.emptyList() : alertManagerConfig.getReceivers();
        ArrayList<Receiver> receiversToRemove = new ArrayList<Receiver>();
        for (Receiver receiver : receivers) {
            if (!receiver.getName().startsWith("%%project%%__".replace("%%project%%", project.getName()))) continue;
            receiversToRemove.add(receiver);
        }
        ArrayList<Route> routesToRemove = new ArrayList<Route>();
        for (Route route : routes) {
            if (!ConfigUtil.isRouteInProject(route, project) && !receiversToRemove.contains(new Receiver(route.getReceiver()))) continue;
            routesToRemove.add(route);
        }
        if (!routesToRemove.isEmpty() || !receiversToRemove.isEmpty()) {
            if (!routesToRemove.isEmpty()) {
                alertManagerConfig.getRoute().getRoutes().removeAll(routesToRemove);
            }
            if (!receiversToRemove.isEmpty()) {
                alertManagerConfig.getReceivers().removeAll(receiversToRemove);
                for (Receiver receiver : receiversToRemove) {
                    alertReceiverFacade.removeReceiverFromDatabase(receiver.getName());
                }
            }
            this.writeAndReload(alertManagerConfigController, client, alertManagerConfig, alertManagerConfigFacade);
            return true;
        }
        return false;
    }
}

