/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert;

import io.hops.hopsworks.alert.AlertManagerConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Schedule;
import javax.ejb.Singleton;
import javax.ejb.Startup;

@Startup
@Singleton
public class RestoreAlertManagerConfigTimer {
    private static final Logger LOGGER = Logger.getLogger(RestoreAlertManagerConfigTimer.class.getName());
    @EJB
    private AlertManagerConfiguration alertManagerConfiguration;

    @PostConstruct
    public void init() {
        try {
            this.alertManagerConfiguration.restoreFromDb();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to restore Alert Manager config from database backup. {0}", e.getMessage());
        }
    }

    @Schedule(persistent=false, hour="*", info="Restore Alert Manager config from backup.")
    public void restoreAlertManagerConfigTimer() {
        try {
            this.alertManagerConfiguration.restoreFromBackup();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to fix Alert Manager config from backup. {0}", e.getMessage());
            e.printStackTrace();
        }
    }
}

