/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.alert.util;

import com.google.common.base.Strings;
import io.hops.hopsworks.alerting.config.dto.Receiver;
import io.hops.hopsworks.alerting.config.dto.Route;
import io.hops.hopsworks.persistence.entity.alertmanager.AlertType;
import io.hops.hopsworks.persistence.entity.featurestore.featuregroup.datavalidation.alert.FeatureGroupAlert;
import io.hops.hopsworks.persistence.entity.featurestore.featureview.alert.FeatureViewAlert;
import io.hops.hopsworks.persistence.entity.jobs.description.JobAlert;
import io.hops.hopsworks.persistence.entity.project.Project;
import io.hops.hopsworks.persistence.entity.project.alert.ProjectServiceAlert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ConfigUtil {
    public static void fixReceiverName(Receiver receiver, Project project) {
        if (receiver.getName() != null && !receiver.getName().startsWith("%%project%%__".replace("%%project%%", project.getName()))) {
            receiver.setName("%%project%%__%%receiverName%%".replace("%%project%%", project.getName()).replace("%%receiverName%%", receiver.getName()));
        }
    }

    public static void fixRoute(Route route, Project project) {
        if ((route.getMatch() == null || route.getMatch().isEmpty()) && (route.getMatchRe() == null || route.getMatchRe().isEmpty())) {
            route.setMatch(new HashMap());
            route.getMatch().put("type", AlertType.PROJECT_ALERT.getValue());
            route.getMatch().put("project", project.getName());
        } else {
            if (route.getMatch() != null && !route.getMatch().isEmpty()) {
                route.getMatch().put("type", AlertType.PROJECT_ALERT.getValue());
                route.getMatch().put("project", project.getName());
            }
            if (route.getMatchRe() != null && !route.getMatchRe().isEmpty()) {
                route.getMatchRe().put("type", AlertType.PROJECT_ALERT.getValue());
                route.getMatchRe().put("project", project.getName());
            }
        }
    }

    public static boolean isRouteInProject(Route route, Project project) {
        return !Strings.isNullOrEmpty((String)route.getReceiver()) && route.getReceiver().startsWith("%%project%%__".replace("%%project%%", project.getName())) && (route.getMatch() != null && route.getMatch().get("project") != null && ((String)route.getMatch().get("project")).equals(project.getName()) || route.getMatchRe() != null && route.getMatchRe().get("project") != null && ((String)route.getMatchRe().get("project")).equals(project.getName()));
    }

    public static boolean isRouteGlobal(Route route) {
        return route.getMatch() != null && route.getMatch().get("type") != null && AlertType.fromValue((String)((String)route.getMatch().get("type"))).isGlobal() || route.getMatchRe() != null && route.getMatchRe().get("type") != null && AlertType.fromValue((String)((String)route.getMatchRe().get("type"))).isGlobal();
    }

    public static Map<String, String> getMatch(ProjectServiceAlert alert) {
        Project project = alert.getProject();
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("type", alert.getAlertType().getValue());
        match.put("project", project.getName());
        match.put("status", alert.getStatus().getName());
        return match;
    }

    public static Map<String, String> getMatch(FeatureGroupAlert alert) {
        Project project = alert.getFeatureGroup().getFeaturestore().getProject();
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("type", alert.getAlertType().getValue());
        match.put("project", project.getName());
        match.put("featureGroup", alert.getFeatureGroup().getName());
        match.put("status", alert.getStatus().getName());
        return match;
    }

    public static Map<String, String> getMatch(JobAlert alert) {
        Project project = alert.getJobId().getProject();
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("type", alert.getAlertType().getValue());
        match.put("project", project.getName());
        match.put("job", alert.getJobId().getName());
        match.put("status", alert.getStatus().getName());
        return match;
    }

    public static Route getRoute(ProjectServiceAlert alert) {
        if (alert.getAlertType().isGlobal()) {
            return ConfigUtil.getRoute(alert.getAlertType());
        }
        Map<String, String> match = ConfigUtil.getMatch(alert);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("project");
        groupBy.add("job");
        groupBy.add("featureGroup");
        groupBy.add("status");
        return new Route(alert.getReceiver().getName()).withContinue(Boolean.valueOf(true)).withMatch(match).withGroupBy(groupBy);
    }

    public static Route getRoute(FeatureGroupAlert alert) {
        if (alert.getAlertType().isGlobal()) {
            return ConfigUtil.getRoute(alert.getAlertType());
        }
        Map<String, String> match = ConfigUtil.getMatch(alert);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("project");
        groupBy.add("featureGroup");
        groupBy.add("status");
        return new Route(alert.getReceiver().getName()).withContinue(Boolean.valueOf(true)).withMatch(match).withGroupBy(groupBy);
    }

    public static Route getRoute(JobAlert alert) {
        if (alert.getAlertType().isGlobal()) {
            return ConfigUtil.getRoute(alert.getAlertType());
        }
        Map<String, String> match = ConfigUtil.getMatch(alert);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("project");
        groupBy.add("job");
        groupBy.add("status");
        return new Route(alert.getReceiver().getName()).withContinue(Boolean.valueOf(true)).withMatch(match).withGroupBy(groupBy);
    }

    public static Route getRoute(AlertType alertType) {
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("type", alertType.getValue());
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("project");
        groupBy.add("job");
        groupBy.add("featureGroup");
        groupBy.add("status");
        return new Route(alertType.getReceiverName()).withContinue(Boolean.valueOf(true)).withMatch(match).withGroupBy(groupBy);
    }

    public static Route getRoute(FeatureViewAlert alert) {
        if (alert.getAlertType().isGlobal()) {
            return ConfigUtil.getRoute(alert.getAlertType());
        }
        Map<String, String> match = ConfigUtil.getMatch(alert);
        ArrayList<String> groupBy = new ArrayList<String>();
        groupBy.add("project");
        groupBy.add("featureViewName");
        groupBy.add("status");
        return new Route(alert.getReceiver().getName()).withContinue(Boolean.valueOf(true)).withMatch(match).withGroupBy(groupBy);
    }

    public static Map<String, String> getMatch(FeatureViewAlert alert) {
        Project project = alert.getFeatureView().getFeaturestore().getProject();
        HashMap<String, String> match = new HashMap<String, String>();
        match.put("type", alert.getAlertType().getValue());
        match.put("project", project.getName());
        match.put("featureViewName", alert.getFeatureView().getName());
        match.put("status", alert.getStatus().getName());
        return match;
    }
}

