/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.dataset;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.dataset.DataSetDTO;
import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.hdfs.inode.Inode;
import io.hops.hopsworks.common.dao.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class DatasetFacade
extends AbstractFacade<Dataset> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public DatasetFacade() {
        super(Dataset.class);
    }

    @Override
    public List<Dataset> findAll() {
        TypedQuery query = this.em.createNamedQuery("Dataset.findAll", Dataset.class);
        return query.getResultList();
    }

    public Dataset find(Integer id) {
        return (Dataset)this.em.find(Dataset.class, (Object)id);
    }

    public List<Dataset> findByInode(Inode inode) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByInode", Dataset.class).setParameter("inode", (Object)inode);
        return query.getResultList();
    }

    public List<Dataset> findByInodeId(long inodeId) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByInodeId", Dataset.class).setParameter("inodeId", (Object)inodeId);
        return query.getResultList();
    }

    public Optional<Dataset> findByPublicDsIdProject(String publicDsId, Project project) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByPublicDsIdProject", Dataset.class).setParameter("publicDsId", (Object)publicDsId).setParameter("project", (Object)project);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public Optional<Dataset> findByPublicDsId(String publicDsId) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByPublicDsId", Dataset.class).setParameter("publicDsId", (Object)publicDsId);
        try {
            return Optional.of(query.getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
    }

    public List<Project> findProjectSharedWith(Project project, Inode inode) {
        List<Dataset> datasets = this.findByInode(inode);
        if (datasets == null) {
            return null;
        }
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Dataset ds : datasets) {
            if (ds.getProject().equals(project)) continue;
            projects.add(ds.getProject());
        }
        return projects;
    }

    public Dataset findByProjectAndInode(Project project, Inode inode) {
        if (project == null || inode == null) {
            throw new IllegalArgumentException("Project and/or inode were not provided.");
        }
        try {
            return (Dataset)this.em.createNamedQuery("Dataset.findByProjectAndInode", Dataset.class).setParameter("projectId", (Object)project).setParameter("inode", (Object)inode).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<Dataset> findByProject(Project project) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findByProject", Dataset.class).setParameter("projectId", (Object)project);
        return query.getResultList();
    }

    public List<DataSetDTO> findPublicDatasets() {
        TypedQuery query = this.em.createNamedQuery("Dataset.findAllPublic", Dataset.class);
        List datasets = query.getResultList();
        ArrayList<DataSetDTO> ds = new ArrayList<DataSetDTO>();
        for (Dataset d : datasets) {
            DataSetDTO dto = new DataSetDTO();
            dto.setDescription(d.getDescription());
            dto.setName(d.getInode().getInodePK().getName());
            dto.setInodeId(d.getInode().getId());
            ds.add(dto);
        }
        return ds;
    }

    public List<Dataset> findAllPublicDatasets() {
        TypedQuery query = this.em.createNamedQuery("Dataset.findAllPublic", Dataset.class);
        return query.getResultList();
    }

    public List<Dataset> findAllDatasetsByState(int state, boolean shared) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findAllByState", Dataset.class).setParameter("state", (Object)state).setParameter("shared", (Object)shared);
        return query.getResultList();
    }

    public List<Dataset> findSharedWithProject(Project project) {
        TypedQuery query = this.em.createNamedQuery("Dataset.findSharedWithProject", Dataset.class).setParameter("projectId", (Object)project);
        return query.getResultList();
    }

    public void persistDataset(Dataset dataset) {
        this.em.persist((Object)dataset);
    }

    public void flushEm() {
        this.em.flush();
    }

    public void merge(Dataset dataset) {
        this.em.merge((Object)dataset);
        this.em.flush();
    }

    public void removeDataset(Dataset dataset) {
        Dataset ds = (Dataset)this.em.find(Dataset.class, (Object)dataset.getId());
        if (ds != null) {
            this.em.remove((Object)ds);
        }
    }
}

