/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore;

import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.dataset.DatasetType;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.FeaturestoreDTO;
import io.hops.hopsworks.common.dao.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.dao.featurestore.app.FeaturestoreUtilJobDTO;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.hopsfs.FeaturestoreHopsfsConnectorController;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.jdbc.FeaturestoreJdbcConnectorController;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFlag;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.eclipse.persistence.jaxb.JAXBContextFactory;

@Stateless
public class FeaturestoreController {
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private FeaturestoreJdbcConnectorController featurestoreJdbcConnectorController;
    @EJB
    private FeaturestoreHopsfsConnectorController featurestoreHopsfsConnectorController;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private DistributedFsService distributedFsService;
    private static JAXBContext featurestoreUtilJobArgsJaxbContext = null;
    private static Marshaller featurestoreUtilJobArgsMarshaller = null;
    private static final String FEATURESTORE_UTIL_ARGS_PATH = "/Projects/%s/Resources/%s";
    private static final String HDFS_FILE_PATH = "hdfs://%s";

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<FeaturestoreDTO> getFeaturestoresForProject(Project project) {
        List<Featurestore> featurestores = this.getProjectFeaturestores(project);
        return featurestores.stream().map(fs -> this.convertFeaturestoretoDTO((Featurestore)fs)).collect(Collectors.toList());
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private List<Featurestore> getProjectFeaturestores(Project project) {
        Collection<Dataset> dsInProject = project.getDatasetCollection();
        Collection featurestoresDsInproject = dsInProject.stream().filter(ds -> ds.getType() == DatasetType.FEATURESTORE).collect(Collectors.toList());
        return featurestoresDsInproject.stream().map(ds -> ds.getFeaturestore()).collect(Collectors.toList());
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturestoreDTO getFeaturestoreForProjectWithName(Project project, String featurestoreName) throws FeaturestoreException {
        List<Featurestore> featurestores = this.getProjectFeaturestores(project);
        List featurestoreDTOs = featurestores.stream().map(fs -> this.convertFeaturestoretoDTO((Featurestore)fs)).collect(Collectors.toList());
        List featurestoresDTOWithName = featurestoreDTOs.stream().filter(fs -> fs.getFeaturestoreName().equals(featurestoreName)).collect(Collectors.toList());
        if (featurestoresDTOWithName.size() != 1) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.FINE, "featurestoreName: " + featurestoreName + " , project: " + project.getName());
        }
        return (FeaturestoreDTO)featurestoresDTOWithName.get(0);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturestoreDTO getFeaturestoreForProjectWithId(Project project, Integer featurestoreId) throws FeaturestoreException {
        List<Featurestore> featurestores = this.getProjectFeaturestores(project);
        List featurestoresWithId = featurestores.stream().filter(fs -> fs.getId().equals(featurestoreId)).collect(Collectors.toList());
        if (featurestoresWithId.size() != 1) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.FINE, "featurestoreId: " + featurestoreId + " , project: " + project.getName());
        }
        return this.convertFeaturestoretoDTO((Featurestore)featurestoresWithId.get(0));
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Featurestore getFeaturestoreWithId(Integer id) throws FeaturestoreException {
        Featurestore featurestore = this.featurestoreFacade.findById(id);
        if (featurestore == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND, Level.FINE, "featurestoreId: " + id);
        }
        return featurestore;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Featurestore createProjectFeatureStore(Project project, String featurestoreName, Dataset trainingDatasetsFolder) throws FeaturestoreException {
        Long hiveDbId = this.featurestoreFacade.getHiveDatabaseId(featurestoreName);
        Featurestore featurestore = new Featurestore();
        featurestore.setProject(project);
        featurestore.setHiveDbId(hiveDbId);
        featurestore.setCreated(new Date());
        this.featurestoreFacade.persist(featurestore);
        this.activityFacade.persistActivity(" created a new feature store named " + featurestoreName, project, project.getOwner(), ActivityFlag.SERVICE);
        this.featurestoreJdbcConnectorController.createDefaultJdbcConnectorForFeaturestore(featurestore, this.getFeaturestoreDbName(project), "JDBC connection to Hopsworks Project Feature Store Hive Database");
        this.activityFacade.persistActivity(" added a storage connector for the featurestore with name: " + this.getFeaturestoreDbName(project), project, project.getOwner(), ActivityFlag.SERVICE);
        this.featurestoreJdbcConnectorController.createDefaultJdbcConnectorForFeaturestore(featurestore, project.getName(), "JDBC connection to Hopsworks Project Hive Warehouse");
        this.activityFacade.persistActivity(" added a storage connector for the featurestore with name: " + project.getName(), project, project.getOwner(), ActivityFlag.SERVICE);
        this.featurestoreHopsfsConnectorController.createHopsFsBackendForFeaturestoreConnector(featurestore, trainingDatasetsFolder);
        this.activityFacade.persistActivity(" added a storage connector for the featurestore with name: " + trainingDatasetsFolder.getName(), project, project.getOwner(), ActivityFlag.SERVICE);
        return featurestore;
    }

    public FeaturestoreDTO convertFeaturestoretoDTO(Featurestore featurestore) {
        String hiveDbDescription = this.featurestoreFacade.getHiveDatabaseDescription(featurestore.getHiveDbId());
        FeaturestoreDTO featurestoreDTO = new FeaturestoreDTO(featurestore);
        featurestoreDTO.setFeaturestoreDescription(hiveDbDescription);
        String hiveDbName = this.featurestoreFacade.getHiveDbName(featurestore.getHiveDbId());
        featurestoreDTO.setFeaturestoreName(hiveDbName);
        String hdfsPath = this.featurestoreFacade.getHiveDbHdfsPath(featurestore.getHiveDbId());
        featurestoreDTO.setHdfsStorePath(hdfsPath);
        Long inodeId = this.featurestoreFacade.getFeaturestoreInodeId(featurestore.getHiveDbId());
        featurestoreDTO.setInodeId(inodeId);
        return featurestoreDTO;
    }

    public String getFeaturestoreDbName(Project project) {
        return project.getName() + "_featurestore";
    }

    public String writeUtilArgsToHdfs(Users user, Project project, FeaturestoreUtilJobDTO featurestoreUtilJobDTO) throws FeaturestoreException, JAXBException {
        if (featurestoreUtilJobArgsMarshaller == null) {
            try {
                featurestoreUtilJobArgsJaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{FeaturestoreUtilJobDTO.class}, null);
                featurestoreUtilJobArgsMarshaller = featurestoreUtilJobArgsJaxbContext.createMarshaller();
                featurestoreUtilJobArgsMarshaller.setProperty("eclipselink.json.include-root", (Object)false);
                featurestoreUtilJobArgsMarshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            }
            catch (JAXBException e) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_INITIALIZATION_ERROR, Level.SEVERE, "Error initialization feature store controller");
            }
        }
        StringWriter sw = new StringWriter();
        featurestoreUtilJobArgsMarshaller.marshal((Object)featurestoreUtilJobDTO, (Writer)sw);
        Path hdfsPath = new Path(String.format(FEATURESTORE_UTIL_ARGS_PATH, project.getName(), featurestoreUtilJobDTO.getFileName()));
        this.writeToHDFS(project, user, hdfsPath, sw.toString());
        return String.format(HDFS_FILE_PATH, hdfsPath.toString());
    }

    private void writeToHDFS(Project project, Users user, Path path2file, String content) throws FeaturestoreException {
        DistributedFileSystemOps udfso = null;
        try {
            String hdfsUsername = this.hdfsUsersController.getHdfsUserName(project, user);
            udfso = this.distributedFsService.getDfsOps(hdfsUsername);
            try (FSDataOutputStream outStream = udfso.create(path2file);){
                outStream.writeBytes(content);
                outStream.hflush();
            }
            if (udfso != null) {
                this.distributedFsService.closeDfsClient(udfso);
            }
        }
        catch (IOException ex) {
            try {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_UTIL_ARGS_FAILURE, Level.WARNING, "Failed to write featurestore util args to HDFS", ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                if (udfso != null) {
                    this.distributedFsService.closeDfsClient(udfso);
                }
                throw throwable;
            }
        }
    }
}

