/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.featuregroup;

import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.FeaturestoreFacade;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.FeaturegroupFacade;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup.CachedFeaturegroup;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup.CachedFeaturegroupController;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup.RowValueQueryResult;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.on_demand_featuregroup.OnDemandFeaturegroup;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.on_demand_featuregroup.OnDemandFeaturegroupController;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.on_demand_featuregroup.OnDemandFeaturegroupDTO;
import io.hops.hopsworks.common.dao.featurestore.jobs.FeaturestoreJobController;
import io.hops.hopsworks.common.dao.featurestore.jobs.FeaturestoreJobDTO;
import io.hops.hopsworks.common.dao.featurestore.stats.FeaturestoreStatisticController;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.dao.jobs.description.Jobs;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.parquet.Strings;

@Stateless
public class FeaturegroupController {
    @EJB
    private FeaturegroupFacade featuregroupFacade;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private FeaturestoreStatisticController featurestoreStatisticController;
    @EJB
    private CachedFeaturegroupController cachedFeaturegroupController;
    @EJB
    private OnDemandFeaturegroupController onDemandFeaturegroupController;
    @EJB
    private FeaturestoreFacade featurestoreFacade;
    @EJB
    private FeaturestoreJobController featurestoreJobController;
    @EJB
    private JobFacade jobFacade;

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<FeaturegroupDTO> getFeaturegroupsForFeaturestore(Featurestore featurestore) {
        List<Featuregroup> featuregroups = this.featuregroupFacade.findByFeaturestore(featurestore);
        return featuregroups.stream().map(fg -> this.convertFeaturegrouptoDTO((Featuregroup)fg)).collect(Collectors.toList());
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturegroupDTO clearFeaturegroup(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Users user) throws FeaturestoreException, HopsSecurityException, SQLException {
        switch (featuregroupDTO.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                this.deleteFeaturegroupIfExists(featurestore, featuregroupDTO, user);
                return this.createFeaturegroup(featurestore, featuregroupDTO, user);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CLEAR_OPERATION_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroupDTO.getId());
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + (Object)((Object)FeaturegroupType.ON_DEMAND_FEATURE_GROUP) + ", and: " + (Object)((Object)FeaturegroupType.CACHED_FEATURE_GROUP) + ". The provided feature group type was not recognized: " + (Object)((Object)featuregroupDTO.getFeaturegroupType()));
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturegroupDTO createFeaturegroup(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Users user) throws FeaturestoreException, HopsSecurityException, SQLException {
        this.verifyFeaturegroupUserInput(featuregroupDTO, featurestore);
        this.verifyStatisticsInput(featuregroupDTO);
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(featurestore.getProject(), user);
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        OnDemandFeaturegroup onDemandFeaturegroup = null;
        CachedFeaturegroup cachedFeaturegroup = null;
        switch (featuregroupDTO.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                cachedFeaturegroup = this.cachedFeaturegroupController.createCachedFeaturegroup(featurestore, (CachedFeaturegroupDTO)featuregroupDTO, user);
                break;
            }
            case ON_DEMAND_FEATURE_GROUP: {
                onDemandFeaturegroup = this.onDemandFeaturegroupController.createOnDemandFeaturegroup((OnDemandFeaturegroupDTO)featuregroupDTO);
                break;
            }
            default: {
                throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + (Object)((Object)FeaturegroupType.ON_DEMAND_FEATURE_GROUP) + ", and: " + (Object)((Object)FeaturegroupType.CACHED_FEATURE_GROUP) + ". The provided feature group type was not recognized: " + (Object)((Object)featuregroupDTO.getFeaturegroupType()));
            }
        }
        Featuregroup featuregroup = this.persistFeaturegroupMetadata(featurestore, hdfsUser, user, featuregroupDTO, cachedFeaturegroup, onDemandFeaturegroup);
        this.featurestoreStatisticController.updateFeaturestoreStatistics(featuregroup, null, featuregroupDTO.getFeatureCorrelationMatrix(), featuregroupDTO.getDescriptiveStatistics(), featuregroupDTO.getFeaturesHistogram(), featuregroupDTO.getClusterAnalysis());
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobController.insertJobs(featuregroup, jobs);
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    private List<Jobs> getJobs(List<FeaturestoreJobDTO> jobDTOs, Project project) {
        if (jobDTOs != null) {
            return jobDTOs.stream().filter(jobDTO -> jobDTO != null && !Strings.isNullOrEmpty((String)jobDTO.getJobName())).map(jobDTO -> jobDTO.getJobName()).distinct().map(jobName -> this.jobFacade.findByProjectAndName(project, (String)jobName)).collect(Collectors.toList());
        }
        return new ArrayList<Jobs>();
    }

    private FeaturegroupDTO convertFeaturegrouptoDTO(Featuregroup featuregroup) {
        String featurestoreName = this.featurestoreFacade.getHiveDbName(featuregroup.getFeaturestore().getHiveDbId());
        switch (featuregroup.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                CachedFeaturegroupDTO cachedFeaturegroupDTO = this.cachedFeaturegroupController.convertCachedFeaturegroupToDTO(featuregroup);
                cachedFeaturegroupDTO.setFeaturestoreName(featurestoreName);
                return cachedFeaturegroupDTO;
            }
            case ON_DEMAND_FEATURE_GROUP: {
                OnDemandFeaturegroupDTO onDemandFeaturegroupDTO = new OnDemandFeaturegroupDTO(featuregroup);
                onDemandFeaturegroupDTO.setFeaturestoreName(featurestoreName);
                return onDemandFeaturegroupDTO;
            }
        }
        throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + (Object)((Object)FeaturegroupType.ON_DEMAND_FEATURE_GROUP) + ", and: " + (Object)((Object)FeaturegroupType.CACHED_FEATURE_GROUP) + ". The provided feature group type was not recognized: " + (Object)((Object)featuregroup.getFeaturegroupType()));
    }

    public FeaturegroupDTO getFeaturegroupWithIdAndFeaturestore(Featurestore featurestore, Integer id) {
        Featuregroup featuregroup = this.verifyFeaturegroupId(id, featurestore);
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturegroupDTO updateFeaturegroupMetadata(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) throws FeaturestoreException {
        Featuregroup featuregroup = this.verifyFeaturegroupId(featuregroupDTO.getId(), featurestore);
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobController.insertJobs(featuregroup, jobs);
        if (featuregroup.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            this.onDemandFeaturegroupController.updateOnDemandFeaturegroupMetadata(featuregroup.getOnDemandFeaturegroup(), (OnDemandFeaturegroupDTO)featuregroupDTO);
        }
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturegroupDTO updateFeaturegroupStats(Featurestore featurestore, FeaturegroupDTO featuregroupDTO) {
        Featuregroup featuregroup = this.verifyFeaturegroupId(featuregroupDTO.getId(), featurestore);
        this.verifyStatisticsInput(featuregroupDTO);
        this.featurestoreStatisticController.updateFeaturestoreStatistics(featuregroup, null, featuregroupDTO.getFeatureCorrelationMatrix(), featuregroupDTO.getDescriptiveStatistics(), featuregroupDTO.getFeaturesHistogram(), featuregroupDTO.getClusterAnalysis());
        return this.convertFeaturegrouptoDTO(featuregroup);
    }

    public void verifyStatisticsInput(FeaturegroupDTO featuregroupDTO) {
        if (featuregroupDTO.getFeatureCorrelationMatrix() != null && featuregroupDTO.getFeatureCorrelationMatrix().getFeatureCorrelations().size() > 50) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.CORRELATION_MATRIX_EXCEED_MAX_SIZE.getMessage());
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturegroupDTO deleteFeaturegroupIfExists(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        Featuregroup featuregroup = null;
        if (featuregroupDTO.getId() != null) {
            featuregroup = this.verifyFeaturegroupId(featuregroupDTO.getId(), null);
        } else if (featuregroupDTO.getId() == null) {
            List<Featuregroup> featuregroups = this.featuregroupFacade.findByFeaturestore(featurestore);
            if (!(featuregroups = featuregroups.stream().filter(fg -> {
                FeaturegroupDTO convertedFeaturegroupDTO = this.convertFeaturegrouptoDTO((Featuregroup)fg);
                return convertedFeaturegroupDTO.getName().equals(featuregroupDTO.getName()) && convertedFeaturegroupDTO.getVersion() == featuregroupDTO.getVersion();
            }).collect(Collectors.toList())).isEmpty()) {
                featuregroup = featuregroups.get(0);
            }
        } else {
            featuregroup = this.featuregroupFacade.findById(featuregroupDTO.getId());
        }
        if (featuregroup != null) {
            FeaturegroupDTO convertedFeaturegroupDTO = this.convertFeaturegrouptoDTO(featuregroup);
            switch (featuregroup.getFeaturegroupType()) {
                case CACHED_FEATURE_GROUP: {
                    this.cachedFeaturegroupController.dropHiveFeaturegroup(convertedFeaturegroupDTO, featurestore, user);
                    break;
                }
                case ON_DEMAND_FEATURE_GROUP: {
                    this.onDemandFeaturegroupController.removeOnDemandFeaturegroup(featuregroup.getOnDemandFeaturegroup());
                    break;
                }
                default: {
                    throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + (Object)((Object)FeaturegroupType.ON_DEMAND_FEATURE_GROUP) + ", and: " + (Object)((Object)FeaturegroupType.CACHED_FEATURE_GROUP) + ". The provided feature group type was not recognized: " + (Object)((Object)featuregroup.getFeaturegroupType()));
                }
            }
            return convertedFeaturegroupDTO;
        }
        return null;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<RowValueQueryResult> getFeaturegroupPreview(FeaturegroupDTO featuregroupDTO, Featurestore featurestore, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        switch (featuregroupDTO.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupController.getFeaturegroupPreview(featuregroupDTO, featurestore, user);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.PREVIEW_NOT_SUPPORTED_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroupDTO.getId());
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + (Object)((Object)FeaturegroupType.ON_DEMAND_FEATURE_GROUP) + ", and: " + (Object)((Object)FeaturegroupType.CACHED_FEATURE_GROUP) + ". The provided feature group type was not recognized: " + (Object)((Object)featuregroupDTO.getFeaturegroupType()));
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public RowValueQueryResult getDDLSchema(FeaturegroupDTO featuregroupDTO, Users user, Featurestore featurestore) throws SQLException, FeaturestoreException, HopsSecurityException {
        switch (featuregroupDTO.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                return this.cachedFeaturegroupController.getDDLSchema(featuregroupDTO, user, featurestore);
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CANNOT_FETCH_HIVE_SCHEMA_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroupDTO.getId());
            }
        }
        throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + (Object)((Object)FeaturegroupType.ON_DEMAND_FEATURE_GROUP) + ", and: " + (Object)((Object)FeaturegroupType.CACHED_FEATURE_GROUP) + ". The provided feature group type was not recognized: " + (Object)((Object)featuregroupDTO.getFeaturegroupType()));
    }

    private Featuregroup verifyFeaturegroupId(Integer featuregroupId, Featurestore featurestore) {
        Featuregroup featuregroup = null;
        featuregroup = featurestore != null ? this.featuregroupFacade.findByIdAndFeaturestore(featuregroupId, featurestore) : this.featuregroupFacade.findById(featuregroupId);
        if (featuregroup == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_NOT_FOUND + "featuregroupId: " + featuregroupId);
        }
        return featuregroup;
    }

    private void verifyFeaturegroupUserInput(FeaturegroupDTO featuregroupDTO, Featurestore featurestore) throws FeaturestoreException {
        if (featurestore == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.FEATURESTORE_NOT_FOUND.getMessage());
        }
        if (featuregroupDTO.getFeaturegroupType() != FeaturegroupType.CACHED_FEATURE_GROUP && featuregroupDTO.getFeaturegroupType() != FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE, Level.FINE, ", Recognized Feature group types are: " + (Object)((Object)FeaturegroupType.ON_DEMAND_FEATURE_GROUP) + ", and: " + (Object)((Object)FeaturegroupType.CACHED_FEATURE_GROUP) + ". The provided feature group type was not recognized: " + (Object)((Object)featuregroupDTO.getFeaturegroupType()));
        }
        if (featuregroupDTO.getVersion() == null) {
            throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.FEATUREGROUP_VERSION_NOT_PROVIDED.getMessage());
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public FeaturegroupDTO syncHiveTableWithFeaturestore(Featurestore featurestore, FeaturegroupDTO featuregroupDTO, Users user) throws FeaturestoreException {
        this.verifyFeaturegroupUserInput(featuregroupDTO, featurestore);
        this.verifyStatisticsInput(featuregroupDTO);
        String hdfsUsername = this.hdfsUsersController.getHdfsUserName(featurestore.getProject(), user);
        HdfsUsers hdfsUser = this.hdfsUsersFacade.findByName(hdfsUsername);
        CachedFeaturegroup cachedFeaturegroup = null;
        switch (featuregroupDTO.getFeaturegroupType()) {
            case CACHED_FEATURE_GROUP: {
                cachedFeaturegroup = this.cachedFeaturegroupController.syncHiveTableWithFeaturestore(featurestore, (CachedFeaturegroupDTO)featuregroupDTO);
                break;
            }
            case ON_DEMAND_FEATURE_GROUP: {
                throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Only cached feature groups can be synced from an existing Hive table, not on-demand feature groups.");
            }
            default: {
                throw new IllegalArgumentException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_TYPE.getMessage() + ", Recognized Feature group types are: " + (Object)((Object)FeaturegroupType.ON_DEMAND_FEATURE_GROUP) + ", and: " + (Object)((Object)FeaturegroupType.CACHED_FEATURE_GROUP) + ". The provided feature group type was not recognized: " + (Object)((Object)featuregroupDTO.getFeaturegroupType()));
            }
        }
        Featuregroup featuregroup = this.persistFeaturegroupMetadata(featurestore, hdfsUser, user, featuregroupDTO, cachedFeaturegroup, null);
        this.featurestoreStatisticController.updateFeaturestoreStatistics(featuregroup, null, featuregroupDTO.getFeatureCorrelationMatrix(), featuregroupDTO.getDescriptiveStatistics(), featuregroupDTO.getFeaturesHistogram(), featuregroupDTO.getClusterAnalysis());
        List<Jobs> jobs = this.getJobs(featuregroupDTO.getJobs(), featurestore.getProject());
        this.featurestoreJobController.insertJobs(featuregroup, jobs);
        return featuregroupDTO;
    }

    private Featuregroup persistFeaturegroupMetadata(Featurestore featurestore, HdfsUsers hdfsUser, Users user, FeaturegroupDTO featuregroupDTO, CachedFeaturegroup cachedFeaturegroup, OnDemandFeaturegroup onDemandFeaturegroup) {
        Featuregroup featuregroup = new Featuregroup();
        featuregroup.setFeaturestore(featurestore);
        featuregroup.setHdfsUserId(hdfsUser.getId());
        featuregroup.setCreated(new Date());
        featuregroup.setCreator(user);
        featuregroup.setVersion(featuregroupDTO.getVersion());
        featuregroup.setFeaturegroupType(featuregroupDTO.getFeaturegroupType());
        featuregroup.setCachedFeaturegroup(cachedFeaturegroup);
        featuregroup.setOnDemandFeaturegroup(onDemandFeaturegroup);
        this.featuregroupFacade.persist(featuregroup);
        return featuregroup;
    }
}

