/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.FeaturestoreController;
import io.hops.hopsworks.common.dao.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.Featuregroup;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.FeaturegroupDTO;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.FeaturegroupType;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup.CachedFeaturegroup;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup.CachedFeaturegroupDTO;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup.CachedFeaturegroupFacade;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup.ColumnValueQueryResult;
import io.hops.hopsworks.common.dao.featurestore.featuregroup.cached_featuregroup.RowValueQueryResult;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hive.HiveTableType;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.CryptoPasswordNotFoundException;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.exceptions.HopsSecurityException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.lang3.StringUtils;

@Stateless
public class CachedFeaturegroupController {
    @EJB
    private CachedFeaturegroupFacade cachedFeaturegroupFacade;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private Settings settings;
    @EJB
    private FeaturestoreController featurestoreController;
    private static final Logger LOGGER = Logger.getLogger(CachedFeaturegroupController.class.getName());
    private static final String HIVE_DRIVER = "org.apache.hive.jdbc.HiveDriver";

    @PostConstruct
    public void init() {
        try {
            Class.forName(HIVE_DRIVER);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Could not load the Hive driver: org.apache.hive.jdbc.HiveDriver", e);
        }
    }

    private Connection initConnection(String databaseName, Project project, Users user) throws FeaturestoreException {
        try {
            this.certificateMaterializer.materializeCertificatesLocal(user.getUsername(), project.getName());
            String password = String.copyValueOf(this.certificateMaterializer.getUserMaterial(user.getUsername(), project.getName()).getPassword());
            String hiveEndpoint = this.settings.getHiveServerHostName(false);
            String jdbcString = "jdbc:hive2://" + hiveEndpoint + "/" + databaseName + ";auth=noSasl;ssl=true;twoWay=true;sslTrustStore=" + this.certificateMaterializer.getUserTransientTruststorePath(project, user) + ";trustStorePassword=" + password + ";sslKeyStore=" + this.certificateMaterializer.getUserTransientKeystorePath(project, user) + ";keyStorePassword=" + password;
            return DriverManager.getConnection(jdbcString);
        }
        catch (CryptoPasswordNotFoundException | FileNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Could not find user certificates for authenticating with Hive: " + e);
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CERTIFICATES_NOT_FOUND, Level.SEVERE, "project: " + project.getName() + ", hive database: " + databaseName, e.getMessage(), e);
        }
        catch (IOException | SQLException e) {
            LOGGER.log(Level.SEVERE, "Error initiating Hive connection: " + e);
            this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.COULD_NOT_INITIATE_HIVE_CONNECTION, Level.SEVERE, "project: " + project.getName() + ", hive database: " + databaseName, e.getMessage(), (Throwable)e);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public RowValueQueryResult getDDLSchema(FeaturegroupDTO featuregroupDTO, Users user, Featurestore featurestore) throws SQLException, FeaturestoreException, HopsSecurityException {
        if (featuregroupDTO.getFeaturegroupType() == FeaturegroupType.ON_DEMAND_FEATURE_GROUP) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.CANNOT_FETCH_HIVE_SCHEMA_FOR_ON_DEMAND_FEATUREGROUPS, Level.FINE, "featuregroupId: " + featuregroupDTO.getId());
        }
        String sqlSchema = this.parseSqlSchemaResult(this.getSQLSchemaForFeaturegroup(featuregroupDTO, featurestore.getProject(), user, featurestore));
        ColumnValueQueryResult column = new ColumnValueQueryResult("schema", sqlSchema);
        ArrayList<ColumnValueQueryResult> columns = new ArrayList<ColumnValueQueryResult>();
        columns.add(column);
        return new RowValueQueryResult(columns);
    }

    private String parseSqlSchemaResult(List<RowValueQueryResult> rows) {
        return StringUtils.join((Iterable)rows.stream().map(row -> StringUtils.join((Iterable)row.getColumns().stream().map(column -> column.getValue()).collect(Collectors.toList()), (String)"")).collect(Collectors.toList()), (String)"\n");
    }

    private String getTblName(String featuregroupName, Integer version) {
        return featuregroupName + "_" + version.toString();
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<RowValueQueryResult> getFeaturegroupPreview(FeaturegroupDTO featuregroupDTO, Featurestore featurestore, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        String tbl = this.getTblName(featuregroupDTO.getName(), featuregroupDTO.getVersion());
        String query = "SELECT * FROM " + tbl + " LIMIT 20";
        String db = this.featurestoreController.getFeaturestoreDbName(featurestore.getProject());
        try {
            return this.executeReadHiveQuery(query, db, featurestore.getProject(), user);
        }
        catch (Exception e) {
            return this.executeReadHiveQuery(query, db, featurestore.getProject(), user);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public CachedFeaturegroup createCachedFeaturegroup(Featurestore featurestore, CachedFeaturegroupDTO cachedFeaturegroupDTO, Users user) throws FeaturestoreException, HopsSecurityException, SQLException {
        this.verifyCachedFeaturegroupUserInput(cachedFeaturegroupDTO, false);
        String featureStr = this.makeCreateTableColumnsStr(cachedFeaturegroupDTO.getFeatures(), cachedFeaturegroupDTO.getDescription());
        String db = this.featurestoreController.getFeaturestoreDbName(featurestore.getProject());
        String tableName = this.getTblName(cachedFeaturegroupDTO.getName(), cachedFeaturegroupDTO.getVersion());
        String query = "CREATE TABLE " + db + ".`" + tableName + "` " + featureStr + "STORED AS " + this.settings.getFeaturestoreDbDefaultStorageFormat();
        try {
            this.executeUpdateHiveQuery(query, db, featurestore.getProject(), user);
        }
        catch (Exception e) {
            this.executeUpdateHiveQuery(query, db, featurestore.getProject(), user);
        }
        Long hiveTblId = this.cachedFeaturegroupFacade.getHiveTableId(tableName, featurestore.getHiveDbId());
        return this.persistCachedFeaturegroupMetadata(hiveTblId);
    }

    public CachedFeaturegroupDTO convertCachedFeaturegroupToDTO(Featuregroup featuregroup) {
        CachedFeaturegroupDTO cachedFeaturegroupDTO = new CachedFeaturegroupDTO(featuregroup);
        List<FeatureDTO> featureDTOs = this.cachedFeaturegroupFacade.getHiveFeatures(featuregroup.getCachedFeaturegroup().getHiveTableId());
        String primaryKeyName = this.cachedFeaturegroupFacade.getHiveTablePrimaryKey(featuregroup.getCachedFeaturegroup().getHiveTableId());
        if (!featureDTOs.isEmpty() && !Strings.isNullOrEmpty((String)primaryKeyName)) {
            ((FeatureDTO)featureDTOs.stream().filter(f -> f.getName().equals(primaryKeyName)).collect(Collectors.toList()).get(0)).setPrimary(true);
        }
        cachedFeaturegroupDTO.setFeatures(featureDTOs);
        String featuregroupName = this.cachedFeaturegroupFacade.getHiveTableName(featuregroup.getCachedFeaturegroup().getHiveTableId());
        int versionLength = cachedFeaturegroupDTO.getVersion().toString().length();
        featuregroupName = featuregroupName.substring(0, featuregroupName.length() - (1 + versionLength));
        cachedFeaturegroupDTO.setName(featuregroupName);
        List<String> hdfsStorePaths = this.cachedFeaturegroupFacade.getHiveTableHdfsPaths(featuregroup.getCachedFeaturegroup().getHiveTableId());
        cachedFeaturegroupDTO.setHdfsStorePaths(hdfsStorePaths);
        cachedFeaturegroupDTO.setDescription(this.cachedFeaturegroupFacade.getHiveTableComment(featuregroup.getCachedFeaturegroup().getHiveTableId()));
        Long inodeId = this.cachedFeaturegroupFacade.getHiveTableInodeId(featuregroup.getCachedFeaturegroup().getHiveTableId());
        cachedFeaturegroupDTO.setInodeId(inodeId);
        HiveTableType hiveTableType = this.cachedFeaturegroupFacade.getHiveTableType(featuregroup.getCachedFeaturegroup().getHiveTableId());
        cachedFeaturegroupDTO.setHiveTableType(hiveTableType);
        String hiveInputFormat = this.cachedFeaturegroupFacade.getHiveInputFormat(featuregroup.getCachedFeaturegroup().getHiveTableId());
        cachedFeaturegroupDTO.setInputFormat(hiveInputFormat);
        cachedFeaturegroupDTO.setLocation(hdfsStorePaths.get(0));
        return cachedFeaturegroupDTO;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private List<RowValueQueryResult> getSQLSchemaForFeaturegroup(FeaturegroupDTO featuregroupDTO, Project project, Users user, Featurestore featurestore) throws SQLException, FeaturestoreException, HopsSecurityException {
        String tbl = this.getTblName(featuregroupDTO.getName(), featuregroupDTO.getVersion());
        String query = "SHOW CREATE TABLE " + tbl;
        String db = this.featurestoreController.getFeaturestoreDbName(featurestore.getProject());
        return this.executeReadHiveQuery(query, db, project, user);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void dropHiveFeaturegroup(FeaturegroupDTO featuregroupDTO, Featurestore featurestore, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        String db = this.featurestoreController.getFeaturestoreDbName(featurestore.getProject());
        String tableName = this.getTblName(featuregroupDTO.getName(), featuregroupDTO.getVersion());
        String query = "DROP TABLE IF EXISTS `" + tableName + "`";
        try {
            this.executeUpdateHiveQuery(query, db, featurestore.getProject(), user);
        }
        catch (Exception e) {
            this.executeUpdateHiveQuery(query, db, featurestore.getProject(), user);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private void executeUpdateHiveQuery(String query, String databaseName, Project project, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = this.initConnection(databaseName, project, user);
            stmt = conn.createStatement();
            stmt.executeUpdate(query);
        }
        catch (SQLException e) {
            if (e.getMessage().toLowerCase().contains("permission denied")) {
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.HDFS_ACCESS_CONTROL, Level.FINE, "project: " + project.getName() + ", hive database: " + databaseName + " hive query: " + query, e.getMessage(), (Throwable)e);
            }
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HIVE_UPDATE_STATEMENT_ERROR, Level.SEVERE, "project: " + project.getName() + ", hive database: " + databaseName + " hive query: " + query, e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.closeConnection(conn, user, project);
        }
    }

    private List<RowValueQueryResult> parseResultset(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        ArrayList<RowValueQueryResult> rows = new ArrayList<RowValueQueryResult>();
        while (rs.next()) {
            ArrayList<ColumnValueQueryResult> columnValues = new ArrayList<ColumnValueQueryResult>();
            for (int i = 1; i <= columnsNumber; ++i) {
                String columnName = rsmd.getColumnName(i);
                Object columnValue = rs.getObject(i);
                String columnStrValue = columnValue == null ? null : columnValue.toString();
                ColumnValueQueryResult featuredataDTO = new ColumnValueQueryResult(columnName, columnStrValue);
                columnValues.add(featuredataDTO);
            }
            rows.add(new RowValueQueryResult(columnValues));
        }
        return rows;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    private List<RowValueQueryResult> executeReadHiveQuery(String query, String databaseName, Project project, Users user) throws SQLException, FeaturestoreException, HopsSecurityException {
        Connection conn = null;
        Statement stmt = null;
        List<RowValueQueryResult> resultList = null;
        try {
            conn = this.initConnection(databaseName, project, user);
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            resultList = this.parseResultset(rs);
        }
        catch (SQLException e) {
            if (e.getMessage().toLowerCase().contains("permission denied")) {
                throw new HopsSecurityException(RESTCodes.SecurityErrorCode.HDFS_ACCESS_CONTROL, Level.FINE, "project: " + project.getName() + ", hive database: " + databaseName + " hive query: " + query, e.getMessage(), (Throwable)e);
            }
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.HIVE_READ_QUERY_ERROR, Level.SEVERE, "project: " + project.getName() + ", hive database: " + databaseName + " hive query: " + query, e.getMessage(), (Throwable)e);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.closeConnection(conn, user, project);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Connection conn, Users user, Project project) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Error closing Hive JDBC connection: " + e);
        }
        finally {
            this.certificateMaterializer.removeCertificatesLocal(user.getUsername(), project.getName());
        }
    }

    public void verifyCachedFeaturegroupUserInput(CachedFeaturegroupDTO cachedFeaturegroupDTO, Boolean sync) throws FeaturestoreException {
        Pattern namePattern = Pattern.compile("^[a-zA-Z0-9_]+$");
        if (cachedFeaturegroupDTO.getName().length() > 767 || !namePattern.matcher(cachedFeaturegroupDTO.getName()).matches()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_NAME, Level.FINE, ", the name of a cached feature group should be less than 767 characters and match the regular expression: ^[a-zA-Z0-9_]+$");
        }
        if (!Strings.isNullOrEmpty((String)cachedFeaturegroupDTO.getDescription()) && cachedFeaturegroupDTO.getDescription().length() > 256) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATUREGROUP_DESCRIPTION, Level.FINE, ", the descritpion of a cached feature group should be less than 256 characters");
        }
        if (!sync.booleanValue()) {
            if (!cachedFeaturegroupDTO.getFeatures().stream().filter(f -> Strings.isNullOrEmpty((String)f.getName()) || !namePattern.matcher(f.getName()).matches() || f.getName().length() > 767).collect(Collectors.toList()).isEmpty()) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATURE_NAME, Level.FINE, ", the feature name in a cached feature group should be less than 767 characters and match the regular expression: ^[a-zA-Z0-9_]+$");
            }
            if (!cachedFeaturegroupDTO.getFeatures().stream().filter(f -> {
                if (Strings.isNullOrEmpty((String)f.getDescription())) {
                    f.setDescription("-");
                }
                return f.getDescription().length() > 256;
            }).collect(Collectors.toList()).isEmpty()) {
                throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_FEATURE_DESCRIPTION, Level.FINE, ", the feature description in a cached feature group should be less than 256 characters");
            }
        }
    }

    public String makeCreateTableColumnsStr(List<FeatureDTO> features, String featuregroupDoc) throws FeaturestoreException {
        StringBuilder schemaStringBuilder = new StringBuilder();
        StringBuilder partitionStringBuilder = new StringBuilder();
        if (features.isEmpty()) {
            schemaStringBuilder.append("(`temp` int COMMENT 'placeholder') COMMENT '");
            schemaStringBuilder.append(featuregroupDoc);
            schemaStringBuilder.append("' ");
            return schemaStringBuilder.toString();
        }
        List primaryKeys = features.stream().filter(f -> f.getPrimary()).collect(Collectors.toList());
        if (primaryKeys.isEmpty()) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.NO_PRIMARY_KEY_SPECIFIED, Level.SEVERE, "Out of the " + features.size() + " features provided, none is marked as primary");
        }
        FeatureDTO primaryKey = (FeatureDTO)primaryKeys.get(0);
        if (primaryKey.getPartition().booleanValue()) {
            LOGGER.fine("The primary key column: " + primaryKey.getName() + " was specified as a partition column, which is not allowed. Primary key columns can not be partitioned; Ignoring this partition request.");
        }
        schemaStringBuilder.append("(");
        int numPartitions = features.stream().filter(f -> f.getPartition()).collect(Collectors.toList()).size();
        partitionStringBuilder.append("PARTITIONED BY (");
        Boolean firstPartition = true;
        for (int i = 0; i < features.size(); ++i) {
            FeatureDTO feature = features.get(i);
            if (!feature.getPartition().booleanValue() || feature.getPrimary().booleanValue()) {
                schemaStringBuilder.append("`");
                schemaStringBuilder.append(feature.getName());
                schemaStringBuilder.append("` ");
                schemaStringBuilder.append(feature.getType());
                schemaStringBuilder.append(" COMMENT '");
                schemaStringBuilder.append(feature.getDescription());
                schemaStringBuilder.append("'");
                schemaStringBuilder.append(", ");
            } else {
                if (!firstPartition.booleanValue()) {
                    partitionStringBuilder.append(",");
                } else {
                    firstPartition = false;
                }
                partitionStringBuilder.append("`");
                partitionStringBuilder.append(feature.getName());
                partitionStringBuilder.append("` ");
                partitionStringBuilder.append(feature.getType());
                partitionStringBuilder.append(" COMMENT '");
                partitionStringBuilder.append(feature.getDescription());
                partitionStringBuilder.append("'");
            }
            if (i != features.size() - 1) continue;
            schemaStringBuilder.append("PRIMARY KEY (`");
            schemaStringBuilder.append(primaryKey.getName());
            schemaStringBuilder.append("`) DISABLE NOVALIDATE) COMMENT '");
            schemaStringBuilder.append(featuregroupDoc);
            schemaStringBuilder.append("' ");
            if (numPartitions <= 0) continue;
            partitionStringBuilder.append(")");
            schemaStringBuilder.append(" ");
            schemaStringBuilder.append(partitionStringBuilder.toString());
        }
        return schemaStringBuilder.toString();
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public CachedFeaturegroup syncHiveTableWithFeaturestore(Featurestore featurestore, CachedFeaturegroupDTO cachedFeaturegroupDTO) throws FeaturestoreException {
        this.verifyCachedFeaturegroupUserInput(cachedFeaturegroupDTO, true);
        String tableName = this.getTblName(cachedFeaturegroupDTO.getName(), cachedFeaturegroupDTO.getVersion());
        Long hiveTblId = this.cachedFeaturegroupFacade.getHiveTableId(tableName, featurestore.getHiveDbId());
        if (hiveTblId == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.SYNC_TABLE_NOT_FOUND, Level.FINE, ", tried to sync hive table with name: " + tableName + " with the feature store, but the table was not found in the Hive metastore");
        }
        return this.persistCachedFeaturegroupMetadata(hiveTblId);
    }

    private CachedFeaturegroup persistCachedFeaturegroupMetadata(Long hiveTblId) {
        CachedFeaturegroup cachedFeaturegroup = new CachedFeaturegroup();
        cachedFeaturegroup.setHiveTableId(hiveTblId);
        this.cachedFeaturegroupFacade.persist(cachedFeaturegroup);
        return cachedFeaturegroup;
    }
}

