/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.storageconnector.s3;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.FeaturestoreStorageConnectorDTO;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.s3.FeaturestoreS3Connector;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.s3.FeaturestoreS3ConnectorDTO;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.s3.FeaturestoreS3ConnectorFacade;
import io.hops.hopsworks.exceptions.FeaturestoreException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class FeaturestoreS3ConnectorController {
    @EJB
    private FeaturestoreS3ConnectorFacade featurestoreS3ConnectorFacade;

    public FeaturestoreS3ConnectorDTO createFeaturestoreS3Connector(Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException {
        this.verifyUserInput(featurestore, featurestoreS3ConnectorDTO);
        FeaturestoreS3Connector featurestoreS3Connector = new FeaturestoreS3Connector();
        featurestoreS3Connector.setAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
        featurestoreS3Connector.setBucket(featurestoreS3ConnectorDTO.getBucket());
        featurestoreS3Connector.setDescription(featurestoreS3ConnectorDTO.getDescription());
        featurestoreS3Connector.setName(featurestoreS3ConnectorDTO.getName());
        featurestoreS3Connector.setSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
        featurestoreS3Connector.setFeaturestore(featurestore);
        this.featurestoreS3ConnectorFacade.persist(featurestoreS3Connector);
        return new FeaturestoreS3ConnectorDTO(featurestoreS3Connector);
    }

    public FeaturestoreS3ConnectorDTO updateFeaturestoreS3Connector(Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO, Integer storageConnectorId) throws FeaturestoreException {
        FeaturestoreS3Connector featurestoreS3Connector = this.verifyS3ConnectorId(storageConnectorId, featurestore);
        if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getName())) {
            this.verifyS3ConnectorName(featurestoreS3ConnectorDTO.getName(), featurestore, true);
            featurestoreS3Connector.setName(featurestoreS3ConnectorDTO.getName());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getDescription())) {
            this.verifyS3ConnectorDescription(featurestoreS3ConnectorDTO.getDescription());
            featurestoreS3Connector.setDescription(featurestoreS3ConnectorDTO.getDescription());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getAccessKey())) {
            this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
            featurestoreS3Connector.setAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getSecretKey())) {
            this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
            featurestoreS3Connector.setSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
        }
        if (!Strings.isNullOrEmpty((String)featurestoreS3ConnectorDTO.getBucket())) {
            this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getBucket());
            featurestoreS3Connector.setBucket(featurestoreS3ConnectorDTO.getBucket());
        }
        if (featurestore != null) {
            featurestoreS3Connector.setFeaturestore(featurestore);
        }
        FeaturestoreS3Connector updatedFeaturestoreS3Connector = this.featurestoreS3ConnectorFacade.updateS3Connector(featurestoreS3Connector);
        return new FeaturestoreS3ConnectorDTO(updatedFeaturestoreS3Connector);
    }

    public FeaturestoreS3ConnectorDTO removeFeaturestoreS3Connector(Integer featurestoreS3Id) {
        FeaturestoreS3Connector featurestoreS3Connector = (FeaturestoreS3Connector)this.featurestoreS3ConnectorFacade.find(featurestoreS3Id);
        FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO = new FeaturestoreS3ConnectorDTO(featurestoreS3Connector);
        this.featurestoreS3ConnectorFacade.remove(featurestoreS3Connector);
        return featurestoreS3ConnectorDTO;
    }

    private FeaturestoreS3Connector verifyS3ConnectorId(Integer s3ConnectorId, Featurestore featurestore) throws FeaturestoreException {
        FeaturestoreS3Connector featurestoreS3Connector = this.featurestoreS3ConnectorFacade.findByIdAndFeaturestore(s3ConnectorId, featurestore);
        if (featurestoreS3Connector == null) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.S3_CONNECTOR_NOT_FOUND, Level.FINE, "s3ConnectorId: " + s3ConnectorId);
        }
        return featurestoreS3Connector;
    }

    private void verifyFeaturestore(Featurestore featurestore) {
        if (featurestore == null) {
            throw new IllegalArgumentException("Featurestore was not found");
        }
    }

    private void verifyS3ConnectorName(String name, Featurestore featurestore, Boolean edit) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the storage connector name cannot be empty");
        }
        if (name.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the name should be less than 1000 characters.");
        }
        if (!edit.booleanValue() && featurestore.getFeaturestoreS3ConnectorConnections().stream().anyMatch(s3Con -> s3Con.getName().equalsIgnoreCase(name))) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_NAME, Level.FINE, ", the storage connector name should be unique, there already exists a S3 connector with the same name ");
        }
    }

    private void verifyS3ConnectorDescription(String description) throws FeaturestoreException {
        if (description.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_STORAGE_CONNECTOR_DESCRIPTION, Level.FINE, ", the description should be less than: 1000");
        }
    }

    private void verifyS3ConnectorBucket(String bucket) throws FeaturestoreException {
        if (Strings.isNullOrEmpty((String)bucket) || bucket.length() > 5000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_BUCKET, Level.FINE, ", the S3 bucket string should not be empty and not exceed: 5000 characters");
        }
    }

    private void verifyS3ConnectorAccessKey(String accessKey) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)accessKey) && accessKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_ACCESS_KEY, Level.FINE, ", the S3 access key should not exceed: 1000 characters");
        }
    }

    private void verifyS3ConnectorSecretKey(String secretKey) throws FeaturestoreException {
        if (!Strings.isNullOrEmpty((String)secretKey) && secretKey.length() > 1000) {
            throw new FeaturestoreException(RESTCodes.FeaturestoreErrorCode.ILLEGAL_S3_CONNECTOR_SECRET_KEY, Level.FINE, ", the S3 secret key should not exceed: 1000 characters");
        }
    }

    private void verifyUserInput(Featurestore featurestore, FeaturestoreS3ConnectorDTO featurestoreS3ConnectorDTO) throws FeaturestoreException {
        if (featurestoreS3ConnectorDTO == null) {
            throw new IllegalArgumentException("Null input data");
        }
        this.verifyFeaturestore(featurestore);
        this.verifyS3ConnectorName(featurestoreS3ConnectorDTO.getName(), featurestore, false);
        this.verifyS3ConnectorDescription(featurestoreS3ConnectorDTO.getDescription());
        this.verifyS3ConnectorBucket(featurestoreS3ConnectorDTO.getBucket());
        this.verifyS3ConnectorAccessKey(featurestoreS3ConnectorDTO.getAccessKey());
        this.verifyS3ConnectorSecretKey(featurestoreS3ConnectorDTO.getSecretKey());
    }

    public List<FeaturestoreStorageConnectorDTO> getS3ConnectorsForFeaturestore(Featurestore featurestore) {
        List<FeaturestoreS3Connector> s3Connectors = this.featurestoreS3ConnectorFacade.findByFeaturestore(featurestore);
        return s3Connectors.stream().map(s3Connector -> new FeaturestoreS3ConnectorDTO((FeaturestoreS3Connector)s3Connector)).collect(Collectors.toList());
    }

    public FeaturestoreS3ConnectorDTO getS3ConnectorWithIdAndFeaturestore(Featurestore featurestore, Integer id) throws FeaturestoreException {
        FeaturestoreS3Connector featurestoreS3Connector = this.verifyS3ConnectorId(id, featurestore);
        return new FeaturestoreS3ConnectorDTO(featurestoreS3Connector);
    }
}

