/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.storageconnector.s3;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.storageconnector.s3.FeaturestoreS3Connector;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.validation.ConstraintViolationException;

@Stateless
public class FeaturestoreS3ConnectorFacade
extends AbstractFacade<FeaturestoreS3Connector> {
    private static final Logger LOGGER = Logger.getLogger(FeaturestoreS3ConnectorFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    public FeaturestoreS3ConnectorFacade() {
        super(FeaturestoreS3Connector.class);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void persist(FeaturestoreS3Connector featurestoreS3Connector) {
        try {
            this.em.persist((Object)featurestoreS3Connector);
            this.em.flush();
        }
        catch (ConstraintViolationException cve) {
            LOGGER.log(Level.WARNING, "Could not persist the new s3 connection", cve);
            throw cve;
        }
    }

    public List<FeaturestoreS3Connector> findByFeaturestore(Featurestore featurestore) {
        TypedQuery q = this.em.createNamedQuery("FeaturestoreS3Connector.findByFeaturestore", FeaturestoreS3Connector.class).setParameter("featurestore", (Object)featurestore);
        return q.getResultList();
    }

    public FeaturestoreS3Connector findByIdAndFeaturestore(Integer id, Featurestore featurestore) {
        try {
            return (FeaturestoreS3Connector)this.em.createNamedQuery("FeaturestoreS3Connector.findByFeaturestoreAndId", FeaturestoreS3Connector.class).setParameter("featurestore", (Object)featurestore).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public FeaturestoreS3Connector updateS3Connector(FeaturestoreS3Connector featurestoreS3Connector) {
        this.em.merge((Object)featurestoreS3Connector);
        return featurestoreS3Connector;
    }

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }
}

