/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.trainingdataset;

import io.hops.hopsworks.common.dao.featurestore.Featurestore;
import io.hops.hopsworks.common.dao.featurestore.feature.FeaturestoreFeature;
import io.hops.hopsworks.common.dao.featurestore.jobs.FeaturestoreJob;
import io.hops.hopsworks.common.dao.featurestore.stats.FeaturestoreStatistic;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDatasetType;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.external_trainingdataset.ExternalTrainingDataset;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.hopsfs_trainingdataset.HopsfsTrainingDataset;
import io.hops.hopsworks.common.dao.user.Users;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="training_dataset", catalog="hopsworks")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="TrainingDataset.findAll", query="SELECT td FROM TrainingDataset td"), @NamedQuery(name="TrainingDataset.findById", query="SELECT td FROM TrainingDataset td WHERE td.id = :id"), @NamedQuery(name="TrainingDataset.findByFeaturestore", query="SELECT td FROM TrainingDataset td WHERE td.featurestore = :featurestore"), @NamedQuery(name="TrainingDataset.findByFeaturestoreAndId", query="SELECT td FROM TrainingDataset td WHERE td.featurestore = :featurestore AND td.id = :id")})
public class TrainingDataset
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @JoinColumn(name="feature_store_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    private Featurestore featurestore;
    @Basic(optional=false)
    @NotNull
    @Column(name="hdfs_user_id")
    private Integer hdfsUserId;
    @Basic(optional=false)
    @Column(name="created")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created;
    @JoinColumn(name="creator", referencedColumnName="uid")
    @ManyToOne(optional=false)
    private Users creator;
    @Basic(optional=false)
    @NotNull
    @Column(name="version")
    private Integer version;
    @Basic(optional=false)
    @NotNull
    @Column(name="data_format")
    private String dataFormat;
    @Basic(optional=false)
    @Column(name="description")
    private String description;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="trainingDataset")
    private Collection<FeaturestoreStatistic> statistics;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="trainingDataset")
    private Collection<FeaturestoreFeature> features;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="trainingDataset")
    private Collection<FeaturestoreJob> jobs;
    @NotNull
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="training_dataset_type")
    private TrainingDatasetType trainingDatasetType = TrainingDatasetType.HOPSFS_TRAINING_DATASET;
    @JoinColumn(name="hopsfs_training_dataset_id", referencedColumnName="id")
    @OneToOne
    private HopsfsTrainingDataset hopsfsTrainingDataset;
    @JoinColumn(name="external_training_dataset_id", referencedColumnName="id")
    @OneToOne
    private ExternalTrainingDataset externalTrainingDataset;

    public static long getSerialVersionUID() {
        return 1L;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Featurestore getFeaturestore() {
        return this.featurestore;
    }

    public void setFeaturestore(Featurestore featurestore) {
        this.featurestore = featurestore;
    }

    public Integer getHdfsUserId() {
        return this.hdfsUserId;
    }

    public void setHdfsUserId(Integer hdfsUserId) {
        this.hdfsUserId = hdfsUserId;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Users getCreator() {
        return this.creator;
    }

    public void setCreator(Users creator) {
        this.creator = creator;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<FeaturestoreStatistic> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Collection<FeaturestoreStatistic> statistics) {
        this.statistics = statistics;
    }

    public Collection<FeaturestoreFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<FeaturestoreFeature> features) {
        this.features = features;
    }

    public HopsfsTrainingDataset getHopsfsTrainingDataset() {
        return this.hopsfsTrainingDataset;
    }

    public void setHopsfsTrainingDataset(HopsfsTrainingDataset hopsfsTrainingDataset) {
        this.hopsfsTrainingDataset = hopsfsTrainingDataset;
    }

    public ExternalTrainingDataset getExternalTrainingDataset() {
        return this.externalTrainingDataset;
    }

    public void setExternalTrainingDataset(ExternalTrainingDataset externalTrainingDataset) {
        this.externalTrainingDataset = externalTrainingDataset;
    }

    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    public Collection<FeaturestoreJob> getJobs() {
        return this.jobs;
    }

    public void setJobs(Collection<FeaturestoreJob> jobs) {
        this.jobs = jobs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrainingDataset)) {
            return false;
        }
        TrainingDataset that = (TrainingDataset)o;
        if (this.id != null && !this.id.equals(that.id)) {
            return false;
        }
        if (!this.hdfsUserId.equals(that.hdfsUserId)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (!this.dataFormat.equals(that.dataFormat)) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.trainingDatasetType.equals((Object)that.trainingDatasetType)) {
            return false;
        }
        if (this.created != null && !this.created.equals(that.created)) {
            return false;
        }
        if (!this.creator.equals(that.creator)) {
            return false;
        }
        if (this.features != null && !this.features.equals(that.features)) {
            return false;
        }
        return this.featurestore.equals(that.featurestore);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.featurestore.hashCode();
        result = 31 * result + this.hdfsUserId.hashCode();
        result = 31 * result + this.dataFormat.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.trainingDatasetType.hashCode();
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        result = 31 * result + (this.features != null ? this.features.hashCode() : 0);
        result = 31 * result + this.creator.hashCode();
        return result;
    }
}

