/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.featurestore.trainingdataset;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.hops.hopsworks.common.dao.featurestore.FeaturestoreEntityDTO;
import io.hops.hopsworks.common.dao.featurestore.feature.FeatureDTO;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDataset;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.TrainingDatasetType;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.external_trainingdataset.ExternalTrainingDatasetDTO;
import io.hops.hopsworks.common.dao.featurestore.trainingdataset.hopsfs_trainingdataset.HopsfsTrainingDatasetDTO;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlSeeAlso(value={HopsfsTrainingDatasetDTO.class, ExternalTrainingDatasetDTO.class})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=HopsfsTrainingDatasetDTO.class, name="HopsfsTrainingDatasetDTO"), @JsonSubTypes.Type(value=ExternalTrainingDatasetDTO.class, name="ExternalTrainingDatasetDTO")})
public class TrainingDatasetDTO
extends FeaturestoreEntityDTO {
    private String dataFormat;
    private TrainingDatasetType trainingDatasetType;

    public TrainingDatasetDTO() {
    }

    public TrainingDatasetDTO(TrainingDataset trainingDataset) {
        super(trainingDataset.getFeaturestore().getId(), trainingDataset.getCreated(), trainingDataset.getCreator(), trainingDataset.getVersion(), (List)trainingDataset.getStatistics(), (List)trainingDataset.getJobs(), trainingDataset.getId());
        this.setDescription(trainingDataset.getDescription());
        this.setFeatures(trainingDataset.getFeatures().stream().map(tdf -> new FeatureDTO(tdf.getName(), tdf.getType(), tdf.getDescription(), tdf.getPrimary() == 1, false)).collect(Collectors.toList()));
        this.dataFormat = trainingDataset.getDataFormat();
        this.trainingDatasetType = trainingDataset.getTrainingDatasetType();
    }

    @XmlElement
    public String getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
    }

    @XmlElement
    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    @Override
    public String toString() {
        return "TrainingDatasetDTO{dataFormat='" + this.dataFormat + '\'' + ", trainingDatasetType=" + (Object)((Object)this.trainingDatasetType) + '}';
    }
}

