/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.hdfs.inode;

import io.hops.hopsworks.common.dao.hdfs.inode.InodePK;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsGroups;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import io.hops.hopsworks.common.dao.metadata.Template;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@Entity
@Table(name="hops.hdfs_inodes")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Inode.findAll", query="SELECT i FROM Inode i"), @NamedQuery(name="Inode.findById", query="SELECT i FROM Inode i WHERE i.id = :id"), @NamedQuery(name="Inode.findByParentId", query="SELECT i FROM Inode i WHERE i.inodePK.parentId = :parentId"), @NamedQuery(name="Inode.findByHdfsUser", query="SELECT i FROM Inode i WHERE i.hdfsUser = :hdfsUser"), @NamedQuery(name="Inode.findByName", query="SELECT i FROM Inode i WHERE i.inodePK.name = :name"), @NamedQuery(name="Inode.findByModificationTime", query="SELECT i FROM Inode i WHERE i.modificationTime = :modificationTime"), @NamedQuery(name="Inode.findByPrimaryKey", query="SELECT i FROM Inode i WHERE i.inodePK = :inodePk"), @NamedQuery(name="Inode.findByAccessTime", query="SELECT i FROM Inode i WHERE i.accessTime = :accessTime"), @NamedQuery(name="Inode.findByClientName", query="SELECT i FROM Inode i WHERE i.clientName = :clientName"), @NamedQuery(name="Inode.findByClientMachine", query="SELECT i FROM Inode i WHERE i.clientMachine = :clientMachine"), @NamedQuery(name="Inode.findByGenerationStamp", query="SELECT i FROM Inode i WHERE i.generationStamp = :generationStamp"), @NamedQuery(name="Inode.findByHeader", query="SELECT i FROM Inode i WHERE i.header = :header"), @NamedQuery(name="Inode.findBySymlink", query="SELECT i FROM Inode i WHERE i.symlink = :symlink"), @NamedQuery(name="Inode.findByQuotaEnabled", query="SELECT i FROM Inode i WHERE i.quotaEnabled = :quotaEnabled"), @NamedQuery(name="Inode.findByUnderConstruction", query="SELECT i FROM Inode i WHERE i.underConstruction = :underConstruction"), @NamedQuery(name="Inode.findBySubtreeLocked", query="SELECT i FROM Inode i WHERE i.subtreeLocked = :subtreeLocked"), @NamedQuery(name="Inode.findBySubtreeLockOwner", query="SELECT i FROM Inode i WHERE i.subtreeLockOwner = :subtreeLockOwner"), @NamedQuery(name="Inode.findRootByName", query="SELECT i FROM Inode i WHERE i.inodePK.parentId = :parentId AND i.inodePK.name = :name AND i.inodePK.partitionId = :partitionId"), @NamedQuery(name="Inode.findHistoryFileByHdfsUser", query="SELECT i FROM Inode i WHERE i.hdfsUser = :hdfsUser AND i.inodePK.name LIKE '%snappy%'")})
public class Inode
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected InodePK inodePK;
    @Basic(optional=false)
    @NotNull
    @Column(name="id")
    private Long id;
    @Column(name="modification_time")
    private BigInteger modificationTime;
    @Column(name="access_time")
    private BigInteger accessTime;
    @JoinColumn(name="user_id", referencedColumnName="id")
    @OneToOne
    private HdfsUsers hdfsUser;
    @JoinColumn(name="group_id", referencedColumnName="id")
    @OneToOne
    private HdfsGroups hdfsGroup;
    @Column(name="permission")
    private short permission;
    @Size(max=100)
    @Column(name="client_name")
    private String clientName;
    @Size(max=100)
    @Column(name="client_machine")
    private String clientMachine;
    @Column(name="generation_stamp")
    private Integer generationStamp;
    @Column(name="header")
    private BigInteger header;
    @Size(max=255)
    @Column(name="symlink")
    private String symlink;
    @Basic(optional=false)
    @NotNull
    @Column(name="quota_enabled")
    private boolean quotaEnabled;
    @Basic(optional=false)
    @NotNull
    @Column(name="under_construction")
    private boolean underConstruction;
    @Column(name="subtree_locked")
    private boolean subtreeLocked;
    @Column(name="meta_enabled")
    @NotNull
    private boolean metaEnabled;
    @Column(name="is_dir")
    @NotNull
    private boolean dir;
    @Column(name="subtree_lock_owner")
    private BigInteger subtreeLockOwner;
    @Basic(optional=false)
    @NotNull
    @Column(name="size")
    private long size;
    @ManyToMany(mappedBy="inodes", cascade={CascadeType.PERSIST}, fetch=FetchType.LAZY)
    private Collection<Template> templates;

    public Inode() {
    }

    public Inode(InodePK inodePK) {
        this.inodePK = inodePK;
    }

    public Inode(InodePK inodePK, Long id, boolean quotaEnabled, boolean underConstruction, boolean subtreeLocked, boolean metaEnabled, boolean dir) {
        this.inodePK = inodePK;
        this.id = id;
        this.quotaEnabled = quotaEnabled;
        this.underConstruction = underConstruction;
        this.subtreeLocked = subtreeLocked;
        this.metaEnabled = metaEnabled;
        this.dir = dir;
    }

    public Inode(Inode inode) {
        this(new InodePK(inode.getInodePK().getParentId(), inode.getInodePK().getName(), inode.getInodePK().getPartitionId()), inode.getId(), inode.isQuotaEnabled(), inode.isUnderConstruction(), inode.isSubtreeLocked(), inode.isMetaEnabled(), inode.isDir());
    }

    public Inode(long parentId, String name, long partitionId) {
        this.inodePK = new InodePK(parentId, name, partitionId);
    }

    public InodePK getInodePK() {
        return this.inodePK;
    }

    public void setInodePK(InodePK inodePK) {
        this.inodePK = inodePK;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigInteger getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(BigInteger modificationTime) {
        this.modificationTime = modificationTime;
    }

    public BigInteger getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(BigInteger accessTime) {
        this.accessTime = accessTime;
    }

    public short getPermission() {
        return this.permission;
    }

    public void setPermission(short permission) {
        this.permission = permission;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientMachine() {
        return this.clientMachine;
    }

    public void setClientMachine(String clientMachine) {
        this.clientMachine = clientMachine;
    }

    public Integer getGenerationStamp() {
        return this.generationStamp;
    }

    public void setGenerationStamp(Integer generationStamp) {
        this.generationStamp = generationStamp;
    }

    public BigInteger getHeader() {
        return this.header;
    }

    public void setHeader(BigInteger header) {
        this.header = header;
    }

    public String getSymlink() {
        return this.symlink;
    }

    public void setSymlink(String symlink) {
        this.symlink = symlink;
    }

    public BigInteger getSubtreeLockOwner() {
        return this.subtreeLockOwner;
    }

    public void setSubtreeLockOwner(BigInteger subtreeLockOwner) {
        this.subtreeLockOwner = subtreeLockOwner;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @XmlTransient
    public Collection<Template> getTemplates() {
        return this.templates;
    }

    public void setTemplates(Collection<Template> templates) {
        this.templates = templates;
    }

    public void addTemplate(Template template) {
        if (template != null) {
            this.templates.add(template);
        }
    }

    public int getTemplate() {
        int templateId = -1;
        if (this.templates != null && !this.templates.isEmpty()) {
            Iterator<Template> it = this.templates.iterator();
            Template template = it.next();
            templateId = template.getId();
        }
        return templateId;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.inodePK != null ? this.inodePK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Inode)) {
            return false;
        }
        Inode other = (Inode)object;
        return (this.inodePK != null || other.inodePK == null) && (this.inodePK == null || this.inodePK.equals(other.inodePK));
    }

    public String toString() {
        return "se.kth.bbc.project.fb.Inode[ inodePK= " + this.inodePK + " ]";
    }

    public HdfsUsers getHdfsUser() {
        return this.hdfsUser;
    }

    public void setHdfsUser(HdfsUsers hdfsUser) {
        this.hdfsUser = hdfsUser;
    }

    public HdfsGroups getHdfsGroup() {
        return this.hdfsGroup;
    }

    public void setHdfsGroup(HdfsGroups hdfsGroup) {
        this.hdfsGroup = hdfsGroup;
    }

    public void setDir(boolean dir) {
        this.dir = dir;
    }

    public boolean isDir() {
        return this.dir;
    }

    public boolean isMetaEnabled() {
        return this.metaEnabled;
    }

    public void setMetaEnabled(boolean metaEnabled) {
        this.metaEnabled = metaEnabled;
    }

    public boolean isQuotaEnabled() {
        return this.quotaEnabled;
    }

    public void setQuotaEnabled(boolean quotaEnabled) {
        this.quotaEnabled = quotaEnabled;
    }

    public boolean isSubtreeLocked() {
        return this.subtreeLocked;
    }

    public void setSubtreeLocked(boolean subtreeLocked) {
        this.subtreeLocked = subtreeLocked;
    }

    public boolean isUnderConstruction() {
        return this.underConstruction;
    }

    public void setUnderConstruction(boolean underConstruction) {
        this.underConstruction = underConstruction;
    }
}

