/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobhistory;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.jobhistory.YarnAppHeuristicResult;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;

@Stateless
public class YarnAppHeuristicResultFacade
extends AbstractFacade<YarnAppHeuristicResult> {
    private static final Logger logger = Logger.getLogger(YarnAppHeuristicResultFacade.class.getName());
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public YarnAppHeuristicResultFacade() {
        super(YarnAppHeuristicResult.class);
    }

    public Integer searchByIdAndClass(String yarnAppResultId, String heuristicClass) {
        TypedQuery q = this.em.createNamedQuery("YarnAppHeuristicResult.findByIdAndHeuristicClass", YarnAppHeuristicResult.class);
        q.setParameter("yarnAppResultId", (Object)yarnAppResultId);
        q.setParameter("heuristicClass", (Object)heuristicClass);
        YarnAppHeuristicResult result = (YarnAppHeuristicResult)q.getSingleResult();
        return result.getId();
    }

    public String searchForSeverity(String yarnAppResultId, String heuristicClass) {
        try {
            TypedQuery q = this.em.createNamedQuery("YarnAppHeuristicResult.findByIdAndHeuristicClass", YarnAppHeuristicResult.class);
            q.setParameter("yarnAppResultId", (Object)yarnAppResultId);
            q.setParameter("heuristicClass", (Object)heuristicClass);
            YarnAppHeuristicResult result = (YarnAppHeuristicResult)q.getSingleResult();
            short severity = result.getSeverity();
            switch (severity) {
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "LOW";
                }
                case 2: {
                    return "MODERATE";
                }
                case 3: {
                    return "SEVERE";
                }
                case 4: {
                    return "CRITICAL";
                }
            }
            return "NONE";
        }
        catch (NoResultException e) {
            return "UNDEFINED";
        }
    }
}

