/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jobhistory;

import io.hops.hopsworks.common.dao.AbstractFacade;
import io.hops.hopsworks.common.dao.jobhistory.YarnAppResult;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

@Stateless
public class YarnAppResultFacade
extends AbstractFacade<YarnAppResult> {
    @PersistenceContext(unitName="kthfsPU")
    private EntityManager em;

    @Override
    protected EntityManager getEntityManager() {
        return this.em;
    }

    public YarnAppResultFacade() {
        super(YarnAppResult.class);
    }

    @Override
    public List<YarnAppResult> findAll() {
        TypedQuery query = this.em.createNamedQuery("YarnAppResult.findAll", YarnAppResult.class);
        return query.getResultList();
    }

    public List<YarnAppResult> findAllHistory() {
        Query query = this.em.createNativeQuery("SELECT * FROM hopsworks.yarn_app_result", YarnAppResult.class);
        return query.getResultList();
    }

    public YarnAppResult findAllByName(String id) {
        try {
            return (YarnAppResult)this.em.createNamedQuery("YarnAppResult.findById", YarnAppResult.class).setParameter("id", (Object)id).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<YarnAppResult> findByUsername(String username) {
        try {
            return this.em.createNamedQuery("YarnAppResult.findByUsername", YarnAppResult.class).setParameter("username", (Object)username).getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public YarnAppResult findByStartTime(String startTime) {
        try {
            return (YarnAppResult)this.em.createNamedQuery("YarnAppResult.findByStartTime", YarnAppResult.class).setParameter("startTime", (Object)startTime).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public YarnAppResult update(YarnAppResult yarnApp) {
        return (YarnAppResult)this.em.merge((Object)yarnApp);
    }
}

