/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.jupyter.config;

import io.hops.hopsworks.common.dao.jupyter.JupyterSettings;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterPaths;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.jobs.spark.SparkJobConfiguration;
import io.hops.hopsworks.common.jupyter.JupyterContentsManager;
import io.hops.hopsworks.common.jupyter.JupyterNbVCSController;
import io.hops.hopsworks.common.tensorflow.TfLibMappingUtil;
import io.hops.hopsworks.common.util.ConfigFileGenerator;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.common.util.SparkConfigurationUtil;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JupyterConfigFilesGenerator {
    private static final Logger LOGGER = Logger.getLogger(JupyterConfigFilesGenerator.class.getName());
    public static final String JUPYTER_NOTEBOOK_CONFIG = "jupyter_notebook_config.py";
    public static final String JUPYTER_CUSTOM_KERNEL = "kernel.json";
    public static final String JUPYTER_CUSTOM_JS_FILE = "custom.js";
    public static final String JUPYTER_CUSTOM_JS = "/custom/custom.js";
    public static final String SPARKMAGIC_CONFIG = "config.json";
    @EJB
    private Settings settings;
    @EJB
    private TfLibMappingUtil tfLibMappingUtil;
    @Inject
    private JupyterNbVCSController jupyterNbVCSController;

    public JupyterPaths generateJupyterPaths(Project project, String hdfsUser, String secretConfig) {
        return new JupyterPaths(this.settings.getJupyterDir(), project.getName(), hdfsUser, secretConfig);
    }

    public JupyterPaths generateConfiguration(Project project, String secretConfig, String hdfsUser, String usersFullName, String nameNodeEndpoint, JupyterSettings js, Integer port, String allowOrigin) throws ServiceException {
        boolean newDir = false;
        JupyterPaths jp = this.generateJupyterPaths(project, hdfsUser, secretConfig);
        try {
            newDir = this.createJupyterDirs(jp);
            this.createConfigFiles(jp, hdfsUser, usersFullName, project, nameNodeEndpoint, port, js, allowOrigin);
        }
        catch (Exception e) {
            if (newDir) {
                this.removeProjectUserDirRecursive(jp);
            }
            LOGGER.log(Level.SEVERE, "Error in initializing JupyterConfig for project: {0}. {1}", new Object[]{project.getName(), e});
            throw new ServiceException(RESTCodes.ServiceErrorCode.JUPYTER_ADD_FAILURE, Level.SEVERE, null, e.getMessage(), (Throwable)e);
        }
        return jp;
    }

    private boolean createJupyterDirs(JupyterPaths jp) throws IOException {
        File projectDir = new File(jp.getProjectUserPath());
        projectDir.mkdirs();
        File baseDir = new File(jp.getNotebookPath());
        baseDir.mkdirs();
        HashSet<PosixFilePermission> xOnly = new HashSet<PosixFilePermission>();
        xOnly.add(PosixFilePermission.OWNER_WRITE);
        xOnly.add(PosixFilePermission.OWNER_READ);
        xOnly.add(PosixFilePermission.OWNER_EXECUTE);
        xOnly.add(PosixFilePermission.GROUP_WRITE);
        xOnly.add(PosixFilePermission.GROUP_EXECUTE);
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.GROUP_WRITE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_READ);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(Paths.get(jp.getNotebookPath(), new String[0]), perms);
        Files.setPosixFilePermissions(Paths.get(jp.getProjectUserPath(), new String[0]), xOnly);
        new File(jp.getConfDirPath() + "/custom").mkdirs();
        new File(jp.getRunDirPath()).mkdirs();
        new File(jp.getLogDirPath()).mkdirs();
        new File(jp.getCertificatesDir()).mkdirs();
        new File(jp.getKernelsDir()).mkdirs();
        return true;
    }

    public String pythonKernelName(String pythonVersion) {
        return "python" + pythonVersion.charAt(0);
    }

    public String pythonKernelPath(String kernelsDir, String pythonKernelName) {
        return kernelsDir + File.separator + pythonKernelName;
    }

    public String createJupyterKernelConfig(Project project, JupyterSettings js, String hdfsUser) throws IOException {
        StringBuilder jupyterKernelConfig = ConfigFileGenerator.instantiateFromTemplate(ConfigFileGenerator.JUPYTER_CUSTOM_KERNEL, "hdfs_user", hdfsUser, "hadoop_home", this.settings.getHadoopSymbolicLinkDir(), "hadoop_version", this.settings.getHadoopVersion(), "anaconda_home", this.settings.getAnacondaProjectDir(project), "secret_dir", this.settings.getStagingDir() + "/private_dirs/" + js.getSecret(), "project_name", project.getName(), "hive_endpoint", this.settings.getHiveServerHostName(false));
        return jupyterKernelConfig.toString();
    }

    public String createJupyterNotebookConfig(Project project, String nameNodeEndpoint, int port, JupyterSettings js, String hdfsUser, String pythonKernelName, String certsDir, String allowOrigin) throws IOException, ServiceException {
        String[] nn = nameNodeEndpoint.split(":");
        String nameNodeIp = nn[0];
        String nameNodePort = nn[1];
        String remoteGitURL = "";
        String apiKey = "";
        String baseBranch = "";
        String headBranch = "";
        if (js.isGitBackend().booleanValue() && js.getGitConfig() != null) {
            remoteGitURL = js.getGitConfig().getRemoteGitURL();
            apiKey = this.jupyterNbVCSController.getGitApiKey(hdfsUser, js.getGitConfig().getApiKeyName());
            baseBranch = js.getGitConfig().getBaseBranch();
            headBranch = js.getGitConfig().getHeadBranch();
        }
        JupyterContentsManager jcm = this.jupyterNbVCSController.getJupyterContentsManagerClass(remoteGitURL);
        return ConfigFileGenerator.instantiateFromTemplate(ConfigFileGenerator.JUPYTER_NOTEBOOK_CONFIG_TEMPLATE, "project", project.getName(), "namenode_ip", nameNodeIp, "namenode_port", nameNodePort, "contents_manager", jcm.getClassName(), "hopsworks_endpoint", this.settings.getRestEndpoint(), "elastic_endpoint", this.settings.getElasticEndpoint(), "port", String.valueOf(port), "base_dir", js.getBaseDir(), "hdfs_user", hdfsUser, "python-kernel", ", '" + pythonKernelName + "'", "hadoop_home", this.settings.getHadoopSymbolicLinkDir(), "hdfs_home", this.settings.getHadoopSymbolicLinkDir(), "jupyter_certs_dir", certsDir, "secret_dir", this.settings.getStagingDir() + "/private_dirs/" + js.getSecret(), "allow_origin", allowOrigin, "ws_ping_interval", String.valueOf(this.settings.getJupyterWSPingInterval()), "hopsworks_project_id", Integer.toString(project.getId()), "remote_git_url", remoteGitURL, "api_key", apiKey, "base_branch", baseBranch, "head_branch", headBranch).toString();
    }

    public String createSparkMagicConfig(Project project, JupyterSettings js, String hdfsUser, String confDirPath, String usersFullName) throws IOException {
        SparkJobConfiguration sparkJobConfiguration = (SparkJobConfiguration)js.getJobConfig();
        String tfLdLibraryPath = this.tfLibMappingUtil.getTfLdLibraryPath(project);
        SparkConfigurationUtil sparkConfigurationUtil = new SparkConfigurationUtil();
        HashMap<String, String> extraJavaOptions = new HashMap<String, String>();
        extraJavaOptions.put("hopsworks.logstash.job.info", project.getName().toLowerCase() + ",jupyter,notebook,?");
        HashMap<String, String> finalSparkConfiguration = new HashMap<String, String>();
        finalSparkConfiguration.put("spark.yarn.stagingDir", "hdfs:///Projects/" + project.getName() + "/Resources");
        finalSparkConfiguration.putAll(sparkConfigurationUtil.setFrameworkProperties(project, sparkJobConfiguration, this.settings, hdfsUser, usersFullName, tfLdLibraryPath, extraJavaOptions));
        StringBuilder sparkConfBuilder = new StringBuilder();
        ArrayList keys = new ArrayList(finalSparkConfiguration.keySet());
        Collections.sort(keys);
        for (String configKey : keys) {
            sparkConfBuilder.append("\t\"" + configKey + "\":\"" + (String)finalSparkConfiguration.get(configKey) + "\",\n");
        }
        sparkConfBuilder.deleteCharAt(sparkConfBuilder.lastIndexOf(","));
        HashMap<String, String> replacementMap = new HashMap<String, String>();
        replacementMap.put("livy_ip", this.settings.getLivyIp());
        replacementMap.put("jupyter_home", confDirPath);
        replacementMap.put("driver_cores", (String)finalSparkConfiguration.get("spark.driver.cores"));
        replacementMap.put("driver_memory", (String)finalSparkConfiguration.get("spark.driver.memory"));
        if (sparkJobConfiguration.isDynamicAllocationEnabled() || sparkJobConfiguration.getExperimentType() != null) {
            replacementMap.put("num_executors", "1");
        } else {
            replacementMap.put("num_executors", (String)finalSparkConfiguration.get("spark.executor.instances"));
        }
        replacementMap.put("executor_cores", (String)finalSparkConfiguration.get("spark.executor.cores"));
        replacementMap.put("executor_memory", (String)finalSparkConfiguration.get("spark.executor.memory"));
        replacementMap.put("hdfs_user", hdfsUser);
        replacementMap.put("yarn_queue", sparkJobConfiguration.getAmQueue());
        replacementMap.put("hadoop_home", this.settings.getHadoopSymbolicLinkDir());
        replacementMap.put("hadoop_version", this.settings.getHadoopVersion());
        replacementMap.put("spark_configuration", sparkConfBuilder.toString());
        return ConfigFileGenerator.instantiateFromTemplate(ConfigFileGenerator.SPARKMAGIC_CONFIG_TEMPLATE, replacementMap).toString();
    }

    public String createCustomJs() throws IOException {
        return ConfigFileGenerator.instantiateFromTemplate(ConfigFileGenerator.JUPYTER_CUSTOM_TEMPLATE, "hadoop_home", this.settings.getHadoopSymbolicLinkDir()).toString();
    }

    private boolean createConfigFiles(JupyterPaths jp, String hdfsUser, String usersFullName, Project project, String nameNodeEndpoint, Integer port, JupyterSettings js, String allowOrigin) throws IOException, ServiceException {
        String confDirPath = jp.getConfDirPath();
        String kernelsDir = jp.getKernelsDir();
        String certsDir = jp.getCertificatesDir();
        File jupyter_config_file = new File(confDirPath, JUPYTER_NOTEBOOK_CONFIG);
        File sparkmagic_config_file = new File(confDirPath, SPARKMAGIC_CONFIG);
        File custom_js = new File(confDirPath, JUPYTER_CUSTOM_JS);
        boolean createdJupyter = false;
        boolean createdSparkmagic = false;
        boolean createdCustomJs = false;
        if (!jupyter_config_file.exists()) {
            String pythonKernelName = this.pythonKernelName(project.getPythonVersion());
            if (this.settings.isPythonKernelEnabled()) {
                String pythonKernelPath = this.pythonKernelPath(kernelsDir, pythonKernelName);
                File pythonKernelFile = new File(pythonKernelPath, JUPYTER_CUSTOM_KERNEL);
                new File(pythonKernelPath).mkdir();
                ConfigFileGenerator.createConfigFile(pythonKernelFile, this.createJupyterKernelConfig(project, js, hdfsUser));
            }
            createdJupyter = ConfigFileGenerator.createConfigFile(jupyter_config_file, this.createJupyterNotebookConfig(project, nameNodeEndpoint, port, js, hdfsUser, pythonKernelName, certsDir, allowOrigin));
        }
        if (!sparkmagic_config_file.exists()) {
            createdSparkmagic = ConfigFileGenerator.createConfigFile(sparkmagic_config_file, this.createSparkMagicConfig(project, js, hdfsUser, confDirPath, usersFullName));
        }
        if (!custom_js.exists()) {
            createdCustomJs = ConfigFileGenerator.createConfigFile(custom_js, this.createCustomJs());
        }
        return createdJupyter || createdSparkmagic || createdCustomJs;
    }

    private void removeProjectUserDirRecursive(JupyterPaths jp) {
        try {
            FileUtils.deleteDirectory((File)new File(jp.getProjectUserPath()));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not delete Jupyter directory: " + jp.getProjectUserPath(), e);
        }
    }
}

