/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.kafka;

import io.hops.hopsworks.common.dao.kafka.SchemaTopics;
import io.hops.hopsworks.common.dao.kafka.TopicAcls;
import io.hops.hopsworks.common.dao.project.Project;
import java.io.Serializable;
import java.util.Collection;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnore;

@Entity
@Table(name="project_topics", catalog="hopsworks", schema="")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="ProjectTopics.findAll", query="SELECT p FROM ProjectTopics p"), @NamedQuery(name="ProjectTopics.findByTopicName", query="SELECT p FROM ProjectTopics p WHERE p.topicName = :topicName"), @NamedQuery(name="ProjectTopics.findByProject", query="SELECT p FROM ProjectTopics p WHERE p.project = :project"), @NamedQuery(name="ProjectTopics.findByProjectAndTopicName", query="SELECT p FROM ProjectTopics p WHERE p.project = :project AND p.topicName = :topicName"), @NamedQuery(name="ProjectTopics.findBySchemaVersion", query="SELECT p FROM ProjectTopics p WHERE p.schemaTopics.schemaTopicsPK.name = :schema_name AND p.schemaTopics.schemaTopicsPK.version = :schema_version")})
public class ProjectTopics
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @Basic(optional=false)
    @Column(name="id", unique=true)
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=255)
    @Column(name="topic_name")
    private String topicName;
    @JoinColumn(name="project_id", referencedColumnName="id")
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Project project;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="projectTopics")
    private Collection<TopicAcls> topicAclsCollection;
    @JoinColumns(value={@JoinColumn(name="schema_name", referencedColumnName="name"), @JoinColumn(name="schema_version", referencedColumnName="version")})
    @ManyToOne(optional=false)
    private SchemaTopics schemaTopics;

    public ProjectTopics() {
    }

    public ProjectTopics(String topicName, Project project, SchemaTopics schemaTopics) {
        this.topicName = topicName;
        this.project = project;
        this.schemaTopics = schemaTopics;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @NotNull
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(@NotNull String topicName) {
        this.topicName = topicName;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public SchemaTopics getSchemaTopics() {
        return this.schemaTopics;
    }

    public void setSchemaTopics(SchemaTopics schemaTopics) {
        this.schemaTopics = schemaTopics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectTopics topics = (ProjectTopics)o;
        if (this.id != null ? !this.id.equals(topics.id) : topics.id != null) {
            return false;
        }
        if (!this.topicName.equals(topics.topicName)) {
            return false;
        }
        if (this.project != null ? !this.project.equals(topics.project) : topics.project != null) {
            return false;
        }
        if (this.topicAclsCollection != null ? !this.topicAclsCollection.equals(topics.topicAclsCollection) : topics.topicAclsCollection != null) {
            return false;
        }
        return this.schemaTopics != null ? this.schemaTopics.equals(topics.schemaTopics) : topics.schemaTopics == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.topicName.hashCode();
        result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
        result = 31 * result + (this.topicAclsCollection != null ? this.topicAclsCollection.hashCode() : 0);
        result = 31 * result + (this.schemaTopics != null ? this.schemaTopics.hashCode() : 0);
        return result;
    }

    @XmlTransient
    @JsonIgnore
    public Collection<TopicAcls> getTopicAclsCollection() {
        return this.topicAclsCollection;
    }

    public void setTopicAclsCollection(Collection<TopicAcls> topicAclsCollection) {
        this.topicAclsCollection = topicAclsCollection;
    }
}

