/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.message;

import io.hops.hopsworks.common.dao.user.Users;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.codehaus.jackson.annotate.JsonIgnore;

@Entity
@Table(name="hopsworks.message")
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="Message.findAll", query="SELECT m FROM Message m"), @NamedQuery(name="Message.findById", query="SELECT m FROM Message m WHERE m.id = :id"), @NamedQuery(name="Message.findByDateSent", query="SELECT m FROM Message m WHERE m.dateSent = :dateSent"), @NamedQuery(name="Message.findByFrom", query="SELECT m FROM Message m WHERE m.from = :from"), @NamedQuery(name="Message.findMessagesByToAndUnread", query="SELECT m FROM Message m WHERE m.unread = :unread AND m.to = :to"), @NamedQuery(name="Message.countByToAndUnread", query="SELECT COUNT(m.id) FROM Message m WHERE m.to = :to AND m.unread = :unread"), @NamedQuery(name="Message.findByToAndDeleted", query="SELECT m FROM Message m WHERE m.to = :to AND m.deleted = :deleted  ORDER BY m.unread DESC, m.dateSent DESC"), @NamedQuery(name="Message.emptyToAndDeleted", query="DELETE FROM Message m WHERE m.to = :to AND m.deleted = :deleted"), @NamedQuery(name="Message.countByToAndDeleted", query="SELECT COUNT(m.id) FROM Message m WHERE m.to = :to AND m.deleted = :deleted")})
public class Message
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Basic(optional=false)
    @Column(name="id")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Column(name="date_sent")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateSent;
    @Size(max=128)
    @Column(name="subject")
    private String subject;
    @Size(max=128)
    @Column(name="preview")
    private String preview;
    @Basic(optional=false)
    @NotNull
    @Lob
    @Size(min=1, max=65535)
    @Column(name="content")
    private String content;
    @Basic(optional=false)
    @NotNull
    @Column(name="unread")
    private boolean unread;
    @Basic(optional=false)
    @NotNull
    @Column(name="deleted")
    private boolean deleted;
    @Size(max=600)
    @Column(name="path")
    private String path;
    @JoinTable(name="hopsworks.message_to_user", joinColumns={@JoinColumn(name="message", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="user_email", referencedColumnName="email")})
    @ManyToMany
    private Collection<Users> usersCollection;
    @JoinColumn(name="user_from", referencedColumnName="email")
    @ManyToOne
    private Users from;
    @JoinColumn(name="user_to", referencedColumnName="email")
    @ManyToOne(optional=false)
    private Users to;
    @JoinColumn(name="reply_to_msg")
    @OneToOne
    private Message replyToMsg;

    public Message() {
    }

    public Message(Integer id) {
        this.id = id;
    }

    public Message(Users from, Users to, Date dateSent, String content, boolean unread, boolean deleted) {
        this.from = from;
        this.to = to;
        this.dateSent = dateSent;
        this.content = content;
        this.unread = unread;
        this.deleted = deleted;
    }

    public Message(Users from, Users to, Date dateSent) {
        this.from = from;
        this.to = to;
        this.dateSent = dateSent;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getDateSent() {
        return this.dateSent;
    }

    public void setDateSent(Date dateSent) {
        this.dateSent = dateSent;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getPreview() {
        return this.preview;
    }

    public void setPreview(String preview) {
        this.preview = preview;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean getUnread() {
        return this.unread;
    }

    public void setUnread(boolean unread) {
        this.unread = unread;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Collection<Users> getUsersCollection() {
        return this.usersCollection;
    }

    public void setUsersCollection(Collection<Users> usersCollection) {
        this.usersCollection = usersCollection;
    }

    public Users getFrom() {
        return this.from;
    }

    public void setFrom(Users from) {
        this.from = from;
    }

    public Users getTo() {
        return this.to;
    }

    public void setTo(Users to) {
        this.to = to;
    }

    @XmlTransient
    @JsonIgnore
    public Message getReplyToMsg() {
        return this.replyToMsg;
    }

    public void setReplyToMsg(Message replyToMsg) {
        this.replyToMsg = replyToMsg;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Message)) {
            return false;
        }
        Message other = (Message)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "se.kth.hopsworks.message.Message[ id=" + this.id + " ]";
    }
}

