/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.dao.tensorflow.config;

import com.google.common.io.Files;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.tensorflow.TensorBoard;
import io.hops.hopsworks.common.dao.tensorflow.config.TensorBoardDTO;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.TensorBoardException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.DependsOn;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.apache.commons.io.FileUtils;

@Stateless
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
@DependsOn(value={"Settings"})
public class TensorBoardProcessMgr {
    private static final Logger LOGGER = Logger.getLogger(TensorBoardProcessMgr.class.getName());
    @EJB
    private Settings settings;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private DistributedFsService dfsService;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private OSProcessExecutor osProcessExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public TensorBoardDTO startTensorBoard(Project project, Users user, HdfsUsers hdfsUser, String hdfsLogdir, String tfLdLibraryPath, String tensorBoardDirectory) throws IOException, TensorBoardException {
        String prog = this.settings.getHopsworksDomainDir() + "/bin/tensorboard.sh";
        Integer port = 0;
        BigInteger pid = null;
        String tbBasePath = this.settings.getStagingDir() + "/tensorboard/";
        String tbSecretDir = tbBasePath + tensorBoardDirectory;
        String certsPath = "";
        File tbDir = new File(tbSecretDir);
        if (tbDir.exists()) {
            for (File file : tbDir.listFiles()) {
                if (!file.getName().endsWith(".pid")) continue;
                String pidContents = Files.readFirstLine((File)file, (Charset)Charset.defaultCharset());
                try {
                    pid = BigInteger.valueOf(Long.parseLong(pidContents));
                    if (pid == null || this.ping(pid) != 0) continue;
                    this.killTensorBoard(pid);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.WARNING, "Expected number in pidfile " + file.getAbsolutePath() + " got " + pidContents);
                }
            }
            FileUtils.deleteDirectory((File)tbDir);
        }
        tbDir.mkdirs();
        DistributedFileSystemOps dfso = this.dfsService.getDfsOps();
        try {
            certsPath = tbSecretDir + "/certs";
            File certsDir = new File(certsPath);
            certsDir.mkdirs();
            HopsUtils.materializeCertificatesForUserCustomDir(project.getName(), user.getUsername(), this.settings.getHdfsTmpCertDir(), dfso, this.certificateMaterializer, this.settings, certsPath);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Failed in materializing certificates for " + hdfsUser + " in directory " + certsPath, ioe);
            HopsUtils.cleanupCertificatesForUserCustomDir(user.getUsername(), project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certsPath, this.settings);
            throw new TensorBoardException(RESTCodes.TensorBoardErrorCode.TENSORBOARD_START_ERROR, Level.SEVERE, "Failed to start TensorBoard", "An exception occurred while materializing certificates", (Throwable)ioe);
        }
        finally {
            if (dfso != null) {
                this.dfsService.closeDfsClient(dfso);
            }
        }
        String anacondaEnvironmentPath = this.settings.getAnacondaProjectDir(project);
        int retries = 3;
        while (retries > 0) {
            try {
                if (retries == 0) {
                    throw new IOException("Failed to start TensorBoard for project=" + project.getName() + ", user=" + user.getUid());
                }
                port = ThreadLocalRandom.current().nextInt(40000, 59999);
                ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("start").addCommand(hdfsUser.getName()).addCommand(hdfsLogdir).addCommand(tbSecretDir).addCommand(port.toString()).addCommand(anacondaEnvironmentPath).addCommand(this.settings.getHadoopVersion()).addCommand(this.settings.getJavaHome()).addCommand(tfLdLibraryPath).ignoreOutErrStreams(true).build();
                LOGGER.log(Level.FINE, processDescriptor.toString());
                ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
                if (!processResult.processExited()) {
                    throw new IOException("TensorBoard start process timed out!");
                }
                int exitValue = processResult.getExitCode();
                String pidPath = tbSecretDir + File.separator + port + ".pid";
                File pidFile = new File(pidPath);
                if (!pidFile.exists()) {
                    throw new IOException("No .pid file found for TensorBoard" + pidPath);
                }
                String pidContents = Files.readFirstLine((File)pidFile, (Charset)Charset.defaultCharset());
                pid = BigInteger.valueOf(Long.parseLong(pidContents));
                if (exitValue == 0 && pid != null) {
                    TensorBoardDTO tensorBoardDTO = new TensorBoardDTO();
                    String host = null;
                    try {
                        host = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException ex) {
                        LOGGER.log(Level.SEVERE, null, ex);
                    }
                    tensorBoardDTO.setEndpoint(host + ":" + port);
                    tensorBoardDTO.setPid(pid);
                    TensorBoardDTO tensorBoardDTO2 = tensorBoardDTO;
                    return tensorBoardDTO2;
                }
                LOGGER.log(Level.SEVERE, "Failed starting TensorBoard got exitcode " + exitValue + " retrying on new port");
                if (pid != null) {
                    this.killTensorBoard(pid);
                }
                pid = null;
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Problem starting TensorBoard: {0}", ex);
                if (pid == null || this.ping(pid) != 0) continue;
                this.killTensorBoard(pid);
            }
            finally {
                --retries;
            }
        }
        dfso = this.dfsService.getDfsOps();
        certsPath = tbBasePath + "/certs";
        try {
            HopsUtils.cleanupCertificatesForUserCustomDir(user.getUsername(), project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certsPath, this.settings);
        }
        finally {
            if (dfso != null) {
                this.dfsService.closeDfsClient(dfso);
            }
        }
        this.removeTensorBoardDirectory(tbSecretDir);
        throw new TensorBoardException(RESTCodes.TensorBoardErrorCode.TENSORBOARD_START_ERROR, Level.SEVERE, "Failed to start TensorBoard after exhausting retry attempts");
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int killTensorBoard(BigInteger pid) {
        int exitValue;
        String prog = this.settings.getHopsworksDomainDir() + "/bin/tensorboard.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("kill").addCommand(pid.toString()).ignoreOutErrStreams(true).build();
        LOGGER.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited()) {
                LOGGER.log(Level.SEVERE, "Failed to kill TensorBoard");
            }
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            exitValue = 2;
            LOGGER.log(Level.SEVERE, "Failed to kill TensorBoard", ex);
        }
        return exitValue;
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int killTensorBoard(TensorBoard tb) {
        int exitValue;
        String prog = this.settings.getHopsworksDomainDir() + "/bin/tensorboard.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("kill").addCommand(tb.getPid().toString()).ignoreOutErrStreams(true).build();
        LOGGER.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited()) {
                LOGGER.log(Level.SEVERE, "Failed to kill TensorBoard, process time-out");
            }
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            exitValue = 2;
            LOGGER.log(Level.SEVERE, "Failed to kill TensorBoard", ex);
        }
        return exitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void cleanup(TensorBoard tb) throws TensorBoardException {
        String tbBasePath = this.settings.getStagingDir() + "/tensorboard/";
        String tbPath = tbBasePath + tb.getSecret();
        String certsPath = tbPath + "/certs";
        DistributedFileSystemOps dfso = this.dfsService.getDfsOps();
        try {
            HopsUtils.cleanupCertificatesForUserCustomDir(tb.getUsers().getUsername(), tb.getProject().getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certsPath, this.settings);
        }
        finally {
            if (dfso != null) {
                this.dfsService.closeDfsClient(dfso);
            }
        }
        this.removeTensorBoardDirectory(tbPath);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void removeTensorBoardDirectory(String tensorBoardDirectoryPath) throws TensorBoardException {
        String prog = this.settings.getHopsworksDomainDir() + "/bin/tensorboard.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("cleanup").addCommand(tensorBoardDirectoryPath).ignoreOutErrStreams(true).build();
        LOGGER.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited() || processResult.getExitCode() != 0) {
                throw new TensorBoardException(RESTCodes.TensorBoardErrorCode.TENSORBOARD_CLEANUP_ERROR, Level.SEVERE, "Failed to cleanup TensorBoard", "Could not delete TensorBoard directory: " + tensorBoardDirectoryPath);
            }
        }
        catch (IOException ex) {
            throw new TensorBoardException(RESTCodes.TensorBoardErrorCode.TENSORBOARD_CLEANUP_ERROR, Level.SEVERE, "Failed to cleanup TensorBoard", "Could not delete TensorBoard directory: " + tensorBoardDirectoryPath, (Throwable)ex);
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int ping(BigInteger pid) {
        String prog = this.settings.getHopsworksDomainDir() + "/bin/tensorboard.sh";
        int exitValue = 1;
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand("/usr/bin/sudo").addCommand(prog).addCommand("ping").addCommand(pid.toString()).ignoreOutErrStreams(true).build();
        LOGGER.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited()) {
                LOGGER.log(Level.SEVERE, "Pinging time-out");
                exitValue = 2;
            }
            exitValue = processResult.getExitCode();
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Problem pinging: {0}", ex.toString());
        }
        return exitValue;
    }
}

