/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.elastic;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.dataset.Dataset;
import io.hops.hopsworks.common.dao.dataset.DatasetFacade;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.ProjectFacade;
import io.hops.hopsworks.common.dataset.DatasetController;
import io.hops.hopsworks.common.elastic.ElasticHit;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.Ip;
import io.hops.hopsworks.exceptions.ProjectException;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
public class ElasticController {
    @EJB
    private io.hops.hopsworks.common.util.Settings settings;
    @EJB
    private ProjectFacade projectFacade;
    @EJB
    private DatasetFacade datasetFacade;
    @EJB
    private DatasetController datasetController;
    private static final Logger LOG = Logger.getLogger(ElasticController.class.getName());
    private Client elasticClient = null;

    @PostConstruct
    private void initClient() {
        try {
            this.getClient();
        }
        catch (ServiceException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @PreDestroy
    private void closeClient() {
        this.shutdownClient();
    }

    public List<ElasticHit> globalSearch(String searchTerm) throws ServiceException {
        Client client = this.getClient();
        if (!this.indexExists(client, "projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        LOG.log(Level.INFO, "Found elastic index, now executing the query.");
        SearchRequestBuilder srb = client.prepareSearch(new String[]{"projects"});
        srb = srb.setTypes(new String[]{"_doc"});
        srb = srb.setQuery(this.globalSearchQuery(searchTerm.toLowerCase()));
        srb = srb.highlighter(new HighlightBuilder().field("name"));
        LOG.log(Level.INFO, "Global search Elastic query is: {0}", srb);
        ActionFuture futureResponse = srb.execute();
        SearchResponse response = (SearchResponse)futureResponse.actionGet();
        if (response.status().getStatus() == 200) {
            LinkedList<ElasticHit> elasticHits = new LinkedList<ElasticHit>();
            if (response.getHits().getHits().length > 0) {
                SearchHit[] hits;
                for (SearchHit hit : hits = response.getHits().getHits()) {
                    ElasticHit eHit = new ElasticHit(hit);
                    eHit.setLocalDataset(true);
                    int inode_id = Integer.parseInt(hit.getId());
                    List<Dataset> dsl = this.datasetFacade.findByInodeId(inode_id);
                    if (!dsl.isEmpty() && dsl.get(0).isPublicDs()) {
                        Dataset ds = dsl.get(0);
                        eHit.setPublicId(ds.getPublicDsId());
                    }
                    elasticHits.add(eHit);
                }
            }
            return elasticHits;
        }
        this.shutdownClient();
        throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_SERVER_NOT_FOUND, Level.WARNING, "Elasticsearch error code: " + response.status().getStatus());
    }

    public String findExperiment(String index, String app_id) throws ServiceException {
        Client client = this.getClient();
        SearchResponse searchResponse = (SearchResponse)client.prepareSearch(new String[]{index}).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"app_id", (Object)app_id)).get();
        int status = searchResponse.status().getStatus();
        if (status != 200) {
            LOG.log(Level.SEVERE, "Unexpected response code " + searchResponse.status().getStatus() + " when updating experiment in Elastic. " + searchResponse.toString());
        }
        return searchResponse.toString();
    }

    public void updateExperiment(String index, String id, JSONObject source) throws IOException, ServiceException {
        Client client = this.getClient();
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(source.toString(), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        IndexResponse indexResponse = (IndexResponse)client.prepareIndex(index, "experiments", id).setSource(map).get();
        int status = indexResponse.status().getStatus();
        if (status != 200) {
            LOG.log(Level.SEVERE, "Unexpected response code " + indexResponse.status().getStatus() + " when updating experiment in Elastic. " + indexResponse.toString());
        }
    }

    public List<ElasticHit> projectSearch(Integer projectId, String searchTerm) throws ServiceException {
        Client client = this.getClient();
        if (!this.indexExists(client, "projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        if (!this.typeExists(client, "projects", "_doc")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_TYPE_NOT_FOUND, Level.SEVERE, "type: _doc");
        }
        SearchRequestBuilder srb = client.prepareSearch(new String[]{"projects"});
        srb = srb.setTypes(new String[]{"_doc"});
        srb = srb.setQuery(this.projectSearchQuery(projectId, searchTerm.toLowerCase()));
        srb = srb.highlighter(new HighlightBuilder().field("name"));
        LOG.log(Level.INFO, "Project Elastic query is: {0} {1}", new String[]{String.valueOf(projectId), srb.toString()});
        ActionFuture futureResponse = srb.execute();
        SearchResponse response = (SearchResponse)futureResponse.actionGet();
        if (response.status().getStatus() == 200) {
            LinkedList<ElasticHit> elasticHits = new LinkedList<ElasticHit>();
            if (response.getHits().getHits().length > 0) {
                SearchHit[] hits;
                for (SearchHit hit : hits = response.getHits().getHits()) {
                    ElasticHit eHit = new ElasticHit(hit);
                    eHit.setLocalDataset(true);
                    elasticHits.add(eHit);
                }
            }
            this.projectSearchInSharedDatasets(client, projectId, searchTerm, elasticHits);
            return elasticHits;
        }
        this.shutdownClient();
        throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_SERVER_NOT_FOUND, Level.SEVERE);
    }

    public List<ElasticHit> datasetSearch(Integer projectId, String datasetName, String searchTerm) throws ServiceException {
        Project project;
        Client client = this.getClient();
        if (!this.indexExists(client, "projects")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "index: projects");
        }
        if (!this.typeExists(client, "projects", "_doc")) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_TYPE_NOT_FOUND, Level.SEVERE, "type: _doc");
        }
        String dsName = datasetName;
        if (datasetName.contains("::")) {
            String[] sharedDS = datasetName.split("::");
            dsName = sharedDS[1];
            project = this.projectFacade.findByName(sharedDS[0]);
        } else {
            project = this.projectFacade.find(projectId);
        }
        Dataset dataset = this.datasetController.getByProjectAndDsName(project, null, dsName);
        long datasetId = dataset.getInodeId();
        SearchRequestBuilder srb = client.prepareSearch(new String[]{"projects"});
        srb = srb.setTypes(new String[]{"_doc"});
        srb = srb.setQuery(this.datasetSearchQuery(datasetId, searchTerm.toLowerCase()));
        LOG.log(Level.INFO, "Dataset Elastic query is: {0}", srb.toString());
        ActionFuture futureResponse = srb.execute();
        SearchResponse response = (SearchResponse)futureResponse.actionGet();
        if (response.status().getStatus() == 200) {
            LinkedList<ElasticHit> elasticHits = new LinkedList<ElasticHit>();
            if (response.getHits().getHits().length > 0) {
                SearchHit[] hits;
                for (SearchHit hit : hits = response.getHits().getHits()) {
                    ElasticHit eHit = new ElasticHit(hit);
                    eHit.setLocalDataset(true);
                    elasticHits.add(eHit);
                }
            }
            return elasticHits;
        }
        this.shutdownClient();
        throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_SERVER_NOT_FOUND, Level.SEVERE);
    }

    public boolean deleteIndex(String index) throws ServiceException {
        boolean acked = ((DeleteIndexResponse)this.getClient().admin().indices().delete(new DeleteIndexRequest(index)).actionGet()).isAcknowledged();
        if (acked) {
            LOG.log(Level.INFO, "Acknowledged deletion of elastic index:{0}", index);
        } else {
            LOG.log(Level.SEVERE, "Elastic index:{0} deletion could not be acknowledged", index);
        }
        return acked;
    }

    public boolean indexExists(String index) throws ServiceException {
        boolean exists = ((IndicesExistsResponse)this.getClient().admin().indices().exists(new IndicesExistsRequest(new String[]{index})).actionGet()).isExists();
        if (exists) {
            LOG.log(Level.FINE, "Elastic index found:{0}", index);
        } else {
            LOG.log(Level.FINE, "Elastic index:{0} could not be found", index);
        }
        return exists;
    }

    public void createIndex(String index) throws ServiceException {
        boolean acked = ((CreateIndexResponse)this.getClient().admin().indices().create(new CreateIndexRequest(index)).actionGet()).isAcknowledged();
        if (!acked) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_INDEX_CREATION_ERROR, Level.SEVERE, "Elastic index:{0} creation could not be acknowledged. index: " + index);
        }
    }

    public void createIndexPattern(Project project, String pattern) throws ProjectException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", "POST");
        params.put("data", "{\"attributes\": {\"title\": \"" + pattern + "\"}}");
        JSONObject resp = this.sendKibanaReq(params, "index-pattern", pattern);
        if (!(resp.has("updated_at") || resp.has("statusCode") && resp.get("statusCode").toString().equals("409"))) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.PROJECT_KIBANA_CREATE_INDEX_ERROR, Level.SEVERE, null, "project: " + project.getName() + ", resp: " + resp.toString(2), null);
        }
    }

    public void deleteProjectIndices(Project project) throws ServiceException {
        Map<String, IndexMetaData> indices = this.getIndices(project.getName() + "_(((logs|serving)-\\d{4}.\\d{2}.\\d{2})|(" + "experiments" + ")| (" + "_kagent-*" + "))");
        for (String index : indices.keySet()) {
            if (this.deleteIndex(index)) continue;
            LOG.log(Level.SEVERE, "Could not delete project index:{0}", index);
        }
    }

    public void deleteProjectSavedObjects(List<String> projects) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", "GET");
        JSONArray allObjects = this.sendKibanaReq(params).getJSONArray("saved_objects");
        HashMap<String, String> objectsToDelete = new HashMap<String, String>();
        for (int i = 0; i < allObjects.length(); ++i) {
            String projectName;
            String index = this.getIndexFromKibana(allObjects.getJSONObject(i));
            LOG.log(Level.FINE, "deleteProjectSavedObjects-index:{0}", index);
            if (Strings.isNullOrEmpty((String)index) || !index.contains("_logs-*") || !projects.contains(projectName = index.split("_logs-*")[0])) continue;
            objectsToDelete.put(allObjects.getJSONObject(i).getString("id"), allObjects.getJSONObject(i).getString("type"));
        }
        params.put("op", "DELETE");
        for (String id : objectsToDelete.keySet()) {
            LOG.log(Level.FINE, "deleteProjectSavedObjects-deleting id:{0}, of type:{1}", new Object[]{id, objectsToDelete.get(id)});
            this.sendKibanaReq(params, (String)objectsToDelete.get(id), id);
        }
    }

    public DocWriteResponse.Result deleteDocument(String index, String type, String id) throws ServiceException {
        return ((DeleteResponse)this.getClient().prepareDelete(index, type, id).get()).getResult();
    }

    public Map<String, IndexMetaData> getIndices() throws ServiceException {
        return this.getIndices(null);
    }

    public Map<String, IndexMetaData> getIndices(String regex) throws ServiceException {
        ImmutableOpenMap indices = ((ClusterStateResponse)this.getClient().admin().cluster().prepareState().get()).getState().getMetaData().getIndices();
        HashMap<String, Object> indicesMap = null;
        if (indices != null && !indices.isEmpty()) {
            indicesMap = new HashMap<String, Object>();
            Pattern pattern = null;
            if (regex != null) {
                pattern = Pattern.compile(regex);
            }
            Iterator iter = indices.keysIt();
            while (iter.hasNext()) {
                String index = (String)iter.next();
                if (pattern != null && !pattern.matcher(index).matches()) continue;
                indicesMap.put(index, indices.get((Object)index));
            }
        }
        return indicesMap;
    }

    private Client getClient() throws ServiceException {
        if (this.elasticClient == null) {
            Settings settings = Settings.builder().put("client.transport.sniff", true).put("cluster.name", "hops").build();
            this.elasticClient = new PreBuiltTransportClient(settings, new Class[0]).addTransportAddress(new TransportAddress(new InetSocketAddress(this.getElasticIpAsString(), this.settings.getElasticPort())));
        }
        return this.elasticClient;
    }

    private void projectSearchInSharedDatasets(Client client, Integer projectId, String searchTerm, List<ElasticHit> elasticHits) {
        Project project = this.projectFacade.find(projectId);
        Collection<Dataset> datasets = project.getDatasetCollection();
        for (Dataset ds : datasets) {
            if (!ds.isShared()) continue;
            List<Dataset> dss = this.datasetFacade.findByInode(ds.getInode());
            for (Dataset sh : dss) {
                if (sh.isShared()) continue;
                long datasetId = ds.getInodeId();
                this.executeProjectSearchQuery(client, this.searchSpecificDataset(datasetId, searchTerm), elasticHits);
                this.executeProjectSearchQuery(client, this.datasetSearchQuery(datasetId, searchTerm), elasticHits);
            }
        }
    }

    private void executeProjectSearchQuery(Client client, QueryBuilder query, List<ElasticHit> elasticHits) {
        SearchRequestBuilder srb = client.prepareSearch(new String[]{"projects"});
        srb = srb.setTypes(new String[]{"_doc"});
        srb = srb.setQuery(query);
        srb = srb.highlighter(new HighlightBuilder().field("name"));
        LOG.log(Level.INFO, "Project Elastic query in Shared Dataset : {0}", srb.toString());
        ActionFuture futureResponse = srb.execute();
        SearchResponse response = (SearchResponse)futureResponse.actionGet();
        if (response.status().getStatus() == 200 && response.getHits().getHits().length > 0) {
            SearchHit[] hits;
            for (SearchHit hit : hits = response.getHits().getHits()) {
                elasticHits.add(new ElasticHit(hit));
            }
        }
    }

    private QueryBuilder searchSpecificDataset(Long datasetId, String searchTerm) {
        MatchQueryBuilder dataset = QueryBuilders.matchQuery((String)"_id", (Object)datasetId);
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        return QueryBuilders.boolQuery().must((QueryBuilder)dataset).must(nameDescQuery);
    }

    private QueryBuilder globalSearchQuery(String searchTerm) {
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        TermsQueryBuilder onlyDatasetsAndProjectsQuery = QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"ds", "proj"});
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)onlyDatasetsAndProjectsQuery).must(nameDescQuery);
        return query;
    }

    private QueryBuilder projectSearchQuery(Integer projectId, String searchTerm) {
        TermQueryBuilder projectIdQuery = QueryBuilders.termQuery((String)"project_id", (Object)projectId);
        QueryBuilder nameDescQuery = this.getNameDescriptionMetadataQuery(searchTerm);
        TermsQueryBuilder onlyDatasetsAndInodes = QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"ds", "inode"});
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)projectIdQuery).must((QueryBuilder)onlyDatasetsAndInodes).must(nameDescQuery);
        return query;
    }

    private QueryBuilder datasetSearchQuery(long datasetId, String searchTerm) {
        TermQueryBuilder datasetIdQuery = QueryBuilders.termQuery((String)"dataset_id", (long)datasetId);
        QueryBuilder query = this.getNameDescriptionMetadataQuery(searchTerm);
        TermQueryBuilder onlyInodes = QueryBuilders.termQuery((String)"doc_type", (String)"inode");
        BoolQueryBuilder cq = QueryBuilders.boolQuery().must((QueryBuilder)datasetIdQuery).must((QueryBuilder)onlyInodes).must(query);
        return cq;
    }

    private QueryBuilder getNameDescriptionMetadataQuery(String searchTerm) {
        QueryBuilder nameQuery = this.getNameQuery(searchTerm);
        QueryBuilder descriptionQuery = this.getDescriptionQuery(searchTerm);
        QueryBuilder metadataQuery = this.getMetadataQuery(searchTerm);
        BoolQueryBuilder textCondition = QueryBuilders.boolQuery().should(nameQuery).should(descriptionQuery).should(metadataQuery);
        return textCondition;
    }

    private QueryBuilder getNameQuery(String searchTerm) {
        PrefixQueryBuilder namePrefixMatch = QueryBuilders.prefixQuery((String)"name", (String)searchTerm);
        MatchPhraseQueryBuilder namePhraseMatch = QueryBuilders.matchPhraseQuery((String)"name", (Object)searchTerm);
        FuzzyQueryBuilder nameFuzzyQuery = QueryBuilders.fuzzyQuery((String)"name", (String)searchTerm);
        WildcardQueryBuilder wildCardQuery = QueryBuilders.wildcardQuery((String)"name", (String)String.format("*%s*", searchTerm));
        BoolQueryBuilder nameQuery = QueryBuilders.boolQuery().should((QueryBuilder)namePrefixMatch).should((QueryBuilder)namePhraseMatch).should((QueryBuilder)nameFuzzyQuery).should((QueryBuilder)wildCardQuery);
        return nameQuery;
    }

    private QueryBuilder getDescriptionQuery(String searchTerm) {
        PrefixQueryBuilder descriptionPrefixMatch = QueryBuilders.prefixQuery((String)"description", (String)searchTerm);
        TermsQueryBuilder descriptionMatch = QueryBuilders.termsQuery((String)"description", (String[])new String[]{searchTerm});
        MatchPhraseQueryBuilder descriptionPhraseMatch = QueryBuilders.matchPhraseQuery((String)"description", (Object)searchTerm);
        FuzzyQueryBuilder descriptionFuzzyQuery = QueryBuilders.fuzzyQuery((String)"description", (String)searchTerm);
        WildcardQueryBuilder wildCardQuery = QueryBuilders.wildcardQuery((String)"description", (String)String.format("*%s*", searchTerm));
        BoolQueryBuilder descriptionQuery = QueryBuilders.boolQuery().should((QueryBuilder)descriptionPrefixMatch).should((QueryBuilder)descriptionMatch).should((QueryBuilder)descriptionPhraseMatch).should((QueryBuilder)descriptionFuzzyQuery).should((QueryBuilder)wildCardQuery);
        return descriptionQuery;
    }

    private QueryBuilder getMetadataQuery(String searchTerm) {
        QueryStringQueryBuilder metadataQuery = QueryBuilders.queryStringQuery((String)String.format("*%s*", searchTerm)).lenient(Boolean.TRUE).field("xattr.*");
        NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)"xattr", (QueryBuilder)metadataQuery, (ScoreMode)ScoreMode.Avg);
        return nestedQuery;
    }

    private boolean indexExists(Client client, String indexName) {
        AdminClient admin = client.admin();
        IndicesAdminClient indices = admin.indices();
        IndicesExistsRequestBuilder indicesExistsRequestBuilder = indices.prepareExists(new String[]{indexName});
        IndicesExistsResponse response = (IndicesExistsResponse)indicesExistsRequestBuilder.execute().actionGet();
        return response.isExists();
    }

    private boolean typeExists(Client client, String indexName, String typeName) {
        AdminClient admin = client.admin();
        IndicesAdminClient indices = admin.indices();
        ActionFuture action = indices.typesExists(new TypesExistsRequest(new String[]{indexName}, new String[]{typeName}));
        TypesExistsResponse response = (TypesExistsResponse)action.actionGet();
        return response.isExists();
    }

    private void shutdownClient() {
        if (this.elasticClient != null) {
            this.elasticClient.admin().indices().clearCache(new ClearIndicesCacheRequest(new String[]{"projects"}));
            this.elasticClient.close();
            this.elasticClient = null;
        }
    }

    private void bootIndices(Client client) {
        client.admin().indices().open(new OpenIndexRequest(new String[]{"projects"}));
    }

    private String getElasticIpAsString() throws ServiceException {
        String addr = this.settings.getElasticIp();
        if (!Ip.validIp(addr)) {
            try {
                InetAddress.getByName(addr);
            }
            catch (UnknownHostException ex) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.ELASTIC_SERVER_NOT_AVAILABLE, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
            }
        }
        return addr;
    }

    private JSONObject sendKibanaReq(String templateUrl, Map<String, String> params, boolean async) {
        if (async) {
            ClientBuilder.newClient().target(templateUrl).request().async().method(params.get("op"));
            return null;
        }
        if (params.containsKey("data")) {
            return new JSONObject((String)ClientBuilder.newClient().target(templateUrl).request().header("kbn-xsrf", (Object)"required").header("Content-Type", (Object)"application/json").method(params.get("op"), Entity.json((Object)params.get("data"))).readEntity(String.class));
        }
        return new JSONObject((String)ClientBuilder.newClient().target(templateUrl).request().header("kbn-xsrf", (Object)"required").method(params.get("op")).readEntity(String.class));
    }

    public JSONObject sendKibanaReq(Map<String, String> params) {
        String templateUrl = this.settings.getKibanaUri() + "/api/saved_objects";
        LOG.log(Level.INFO, templateUrl);
        return this.sendKibanaReq(templateUrl, params, false);
    }

    public JSONObject sendKibanaReq(Map<String, String> params, String kibanaType) {
        String templateUrl = this.settings.getKibanaUri() + "/api/saved_objects/" + kibanaType;
        LOG.log(Level.INFO, templateUrl);
        return this.sendKibanaReq(templateUrl, params, false);
    }

    public JSONObject sendKibanaReq(Map<String, String> params, String kibanaType, String id) {
        String templateUrl = this.settings.getKibanaUri() + "/api/saved_objects/" + kibanaType + "/" + id;
        LOG.log(Level.INFO, templateUrl);
        return this.sendKibanaReq(templateUrl, params, false);
    }

    public JSONObject sendKibanaReq(Map<String, String> params, String kibanaType, String id, boolean overwrite) {
        String templateUrl = overwrite ? this.settings.getKibanaUri() + "/api/saved_objects/" + kibanaType + "/" + id + "?overwrite=true" : this.settings.getKibanaUri() + "/api/saved_objects/" + kibanaType + "/" + id;
        LOG.log(Level.INFO, templateUrl);
        return this.sendKibanaReq(templateUrl, params, false);
    }

    public String getIndexFromKibana(JSONObject json) {
        String index = null;
        if (json.has("type")) {
            switch (json.getString("type")) {
                case "index-pattern": {
                    index = json.getString("id");
                    break;
                }
                case "search": {
                    index = new JSONObject(json.getJSONObject("attributes").getJSONObject("kibanaSavedObjectMeta").getString("searchSourceJSON")).getString("index");
                    break;
                }
                case "visualization": {
                    JSONObject objectMetaJson;
                    if (!json.has("attributes")) break;
                    if (json.getJSONObject("attributes").has("savedSearchId")) {
                        String searchId = json.getJSONObject("attributes").getString("savedSearchId");
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("op", "GET");
                        JSONObject savedSearch = this.sendKibanaReq(params, "search", searchId);
                        LOG.log(Level.FINE, "visualization-parent:{0}", savedSearch);
                        index = this.getIndexFromKibana(savedSearch);
                        break;
                    }
                    if (!HopsUtils.jsonKeyExists(json, "kibanaSavedObjectMeta") || !(objectMetaJson = new JSONObject(json.getJSONObject("attributes").getJSONObject("kibanaSavedObjectMeta").getString("searchSourceJSON"))).has("index")) break;
                    index = objectMetaJson.getString("index");
                    break;
                }
                case "dashboard": {
                    if (!HopsUtils.jsonKeyExists(json, "panelsJSON")) break;
                    String id = (String)new JSONArray((String)json.getJSONObject("attributes").get("panelsJSON")).getJSONObject(0).get("id");
                    LOG.log(Level.FINE, "dashboard-id:{0}", id);
                    String type = (String)new JSONArray((String)json.getJSONObject("attributes").get("panelsJSON")).getJSONObject(0).get("type");
                    LOG.log(Level.FINE, "dashboard-type:{0}", type);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("op", "GET");
                    JSONObject parent = this.sendKibanaReq(params, type, id);
                    LOG.log(Level.FINE, "dashboard-parent:{0}", parent.toString());
                    index = this.getIndexFromKibana(parent);
                    break;
                }
            }
        }
        LOG.log(Level.FINE, "getIndexFromKibana-index:{0}", index);
        return index;
    }

    public String getIndex(JSONObject json) {
        String objectId = null;
        if (json.getJSONObject("attributes").has("savedSearchId")) {
            LOG.log(Level.FINE, "savedSearchId-1:{0}", objectId);
            String searchId = json.getJSONObject("attributes").getString("savedSearchId");
            LOG.log(Level.FINE, "savedSearchId-2:{0}", searchId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("op", "GET");
            JSONObject savedSearch = this.sendKibanaReq(params, "search", searchId);
            objectId = new JSONObject(savedSearch.getJSONObject("attributes").getJSONObject("kibanaSavedObjectMeta").getString("searchSourceJSON")).getString("index");
        } else if (HopsUtils.jsonKeyExists(json, "kibanaSavedObjectMeta") && new JSONObject(json.getJSONObject("attributes").getJSONObject("kibanaSavedObjectMeta").getString("searchSourceJSON")).has("index")) {
            objectId = new JSONObject(json.getJSONObject("attributes").getJSONObject("kibanaSavedObjectMeta").getString("searchSourceJSON")).getString("index");
        } else if (json.getString("type").equals("dashboard") && HopsUtils.jsonKeyExists(json, "panelsJSON")) {
            String id = (String)new JSONArray((String)json.getJSONObject("attributes").get("panelsJSON")).getJSONObject(0).get("id");
            LOG.log(Level.FINE, "dashboard-id:{0}", id);
            String type = (String)new JSONArray((String)json.getJSONObject("attributes").get("panelsJSON")).getJSONObject(0).get("type");
            LOG.log(Level.FINE, "dashboard-type:{0}", type);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("op", "GET");
            JSONObject allObjects = this.sendKibanaReq(params, type);
            JSONArray allObjectsArray = allObjects.getJSONArray("saved_objects");
            for (int j = 0; j < allObjectsArray.length(); ++j) {
                LOG.log(Level.FINE, "Checking id:{0}", allObjectsArray.getJSONObject(j).getString("id"));
                if (!allObjectsArray.getJSONObject(j).getString("id").equals(id)) continue;
                if (allObjectsArray.getJSONObject(j).getJSONObject("attributes").has("savedSearchId")) {
                    String searchId = allObjectsArray.getJSONObject(j).getJSONObject("attributes").getString("savedSearchId");
                    params.put("op", "GET");
                    JSONObject savedSearch = this.sendKibanaReq(params, "search", searchId);
                    objectId = new JSONObject(savedSearch.getJSONObject("attributes").getJSONObject("kibanaSavedObjectMeta").getString("searchSourceJSON")).getString("index");
                    continue;
                }
                if (!HopsUtils.jsonKeyExists(allObjectsArray.getJSONObject(j), "kibanaSavedObjectMeta") || !new JSONObject(allObjectsArray.getJSONObject(j).getJSONObject("attributes").getJSONObject("kibanaSavedObjectMeta").getString("searchSourceJSON")).has("index")) continue;
                JSONObject newjson = new JSONObject(allObjectsArray.getJSONObject(j).getJSONObject("attributes").getJSONObject("kibanaSavedObjectMeta").getString("searchSourceJSON"));
                objectId = newjson.getString("index");
                LOG.log(Level.FINE, "objectId to remove:{0}", objectId);
                break;
            }
        }
        return objectId;
    }

    public String getLogdirFromElastic(Project project, String elasticId) throws ProjectException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("op", "GET");
        String projectName = project.getName().toLowerCase();
        String experimentsIndex = projectName + "_experiments";
        String templateUrl = "http://" + this.settings.getElasticRESTEndpoint() + "/" + experimentsIndex + "/experiments/" + elasticId;
        boolean foundEntry = false;
        JSONObject resp = null;
        try {
            resp = this.sendKibanaReq(templateUrl, params, false);
            foundEntry = (Boolean)resp.get("found");
        }
        catch (Exception ex) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.TENSORBOARD_ELASTIC_INDEX_NOT_FOUND, Level.SEVERE, "project:" + project.getName() + ", index: " + elasticId, ex.getMessage(), (Throwable)ex);
        }
        if (!foundEntry) {
            throw new ProjectException(RESTCodes.ProjectErrorCode.TENSORBOARD_ELASTIC_INDEX_NOT_FOUND, Level.WARNING, "project:" + project.getName() + ", index: " + elasticId);
        }
        JSONObject source = resp.getJSONObject("_source");
        return (String)source.get("logdir");
    }
}

