/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs;

import com.google.common.base.Strings;
import io.hops.hopsworks.common.dao.jobs.description.JobFacade;
import io.hops.hopsworks.common.dao.jobs.description.Jobs;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.dao.user.activity.ActivityFacade;
import io.hops.hopsworks.common.dao.user.activity.ActivityFlag;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.jobs.JobScheduler;
import io.hops.hopsworks.common.jobs.configuration.JobConfiguration;
import io.hops.hopsworks.common.jobs.configuration.JobType;
import io.hops.hopsworks.common.jobs.configuration.ScheduleDTO;
import io.hops.hopsworks.common.jobs.execution.ExecutionController;
import io.hops.hopsworks.common.jobs.flink.FlinkController;
import io.hops.hopsworks.common.jobs.flink.FlinkJobConfiguration;
import io.hops.hopsworks.common.jobs.spark.SparkController;
import io.hops.hopsworks.common.jobs.spark.SparkJobConfiguration;
import io.hops.hopsworks.exceptions.JobException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.exceptions.DatabaseException;

@Stateless
public class JobController {
    @EJB
    private JobFacade jobFacade;
    @EJB
    private JobScheduler scheduler;
    @EJB
    private ActivityFacade activityFacade;
    @EJB
    private HdfsUsersController hdfsUsersBean;
    @EJB
    private DistributedFsService dfs;
    @EJB
    private SparkController sparkController;
    @EJB
    private FlinkController flinkController;
    @EJB
    private ExecutionController executionController;
    private static final Logger LOGGER = Logger.getLogger(JobController.class.getName());

    public Jobs putJob(Users user, Project project, Jobs job, JobConfiguration config) throws JobException {
        try {
            job = this.jobFacade.put(user, project, config, job);
        }
        catch (IllegalStateException ise) {
            if (ise.getCause() instanceof JAXBException) {
                throw new JobException(RESTCodes.JobErrorCode.JOB_CONFIGURATION_CONVERT_TO_JSON_ERROR, Level.FINE, "Unable to create json from JobConfiguration", ise.getMessage(), (Throwable)ise);
            }
            throw ise;
        }
        if (config.getSchedule() != null) {
            this.scheduler.scheduleJobPeriodic(job);
        }
        this.activityFacade.persistActivity(" created a new job named " + this.getJobNameForActivity(job.getName()), project, user, ActivityFlag.JOB);
        return job;
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void updateSchedule(Project project, Jobs job, ScheduleDTO schedule, Users user) throws JobException {
        boolean isScheduleUpdated = this.jobFacade.updateJobSchedule(job.getId(), schedule);
        if (!isScheduleUpdated) {
            throw new JobException(RESTCodes.JobErrorCode.JOB_SCHEDULE_UPDATE, Level.WARNING, "Schedule is not updated in the database for jobid: " + job.getId());
        }
        job.getJobConfig().setSchedule(schedule);
        this.scheduler.scheduleJobPeriodic(job);
        this.activityFacade.persistActivity(" scheduled a job named " + this.getJobNameForActivity(job.getName()), project, user, ActivityFlag.JOB);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean unscheduleJob(Jobs job) {
        if (job.getJobConfig().getSchedule() != null) {
            boolean status = this.scheduler.unscheduleJob(job);
            job.getJobConfig().setSchedule(null);
            this.jobFacade.updateJobSchedule(job.getId(), null);
            if (!status) {
                LOGGER.log(Level.WARNING, "Schedule does not exist in the scheduler for jobid {0}", job.getId());
            }
        }
        return this.scheduler.unscheduleJob(job);
    }

    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void deleteJob(Jobs job, Users user) throws JobException {
        this.executionController.stop(job);
        try {
            LOGGER.log(Level.FINE, "Request to delete job name ={0} job id ={1}", new Object[]{job.getName(), job.getId()});
            this.jobFacade.removeJob(job);
            LOGGER.log(Level.FINE, "Deleted job name ={0} job id ={1}", new Object[]{job.getName(), job.getId()});
            this.activityFacade.persistActivity(" deleted a job named " + job.getName(), job.getProject(), user.getEmail(), ActivityFlag.JOB);
        }
        catch (DatabaseException ex) {
            LOGGER.log(Level.SEVERE, "Job cannot be deleted job name ={0} job id ={1}", new Object[]{job.getName(), job.getId()});
            throw new JobException(RESTCodes.JobErrorCode.JOB_DELETION_ERROR, Level.SEVERE, ex.getMessage(), null, (Throwable)ex);
        }
    }

    public Jobs getJob(Project project, String name) throws JobException {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("job name was not provided or it was not set.");
        }
        Jobs job = this.jobFacade.findByProjectAndName(project, name);
        if (job == null) {
            throw new JobException(RESTCodes.JobErrorCode.JOB_NOT_FOUND, Level.FINEST, "jobId:" + name);
        }
        return job;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public JobConfiguration inspectProgram(String path, Project project, Users user, JobType jobType) throws JobException {
        DistributedFileSystemOps udfso = null;
        try {
            String username = this.hdfsUsersBean.getHdfsUserName(project, user);
            udfso = this.dfs.getDfsOps(username);
            LOGGER.log(Level.INFO, "Inspecting executable job program by {0} at path: {1}", new Object[]{username, path});
            if (Strings.isNullOrEmpty((String)path) || !path.endsWith(".jar") && !path.endsWith(".py") && !path.endsWith(".ipynb")) {
                throw new IllegalArgumentException("Path does not point to a .jar, .py or .ipynb file.");
            }
            switch (jobType) {
                case SPARK: 
                case PYSPARK: {
                    SparkJobConfiguration sparkJobConfiguration = this.sparkController.inspectProgram(path, udfso);
                    if (udfso != null) {
                        this.dfs.closeDfsClient(udfso);
                    }
                    return sparkJobConfiguration;
                }
                case FLINK: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Job type not supported: " + (Object)((Object)jobType));
                }
            }
        }
        catch (Throwable throwable) {
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
            throw throwable;
        }
        {
            FlinkJobConfiguration flinkJobConfiguration = this.flinkController.inspectProgram(path, udfso);
            if (udfso != null) {
                this.dfs.closeDfsClient(udfso);
            }
            return flinkJobConfiguration;
        }
    }

    private String getJobNameForActivity(String jobName) {
        String activityJobMsg = jobName;
        if (jobName.length() > 60) {
            activityJobMsg = jobName.substring(0, 60) + "...";
        }
        return activityJobMsg;
    }
}

