/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jobs.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.hops.hopsworks.common.jobs.configuration.JobType;
import io.hops.hopsworks.common.jobs.configuration.KafkaDTO;
import io.hops.hopsworks.common.jobs.configuration.ScheduleDTO;
import io.hops.hopsworks.common.jobs.erasureCode.ErasureCodeJobConfiguration;
import io.hops.hopsworks.common.jobs.flink.FlinkJobConfiguration;
import io.hops.hopsworks.common.jobs.spark.SparkJobConfiguration;
import io.hops.hopsworks.common.jobs.yarn.YarnJobConfiguration;
import java.util.concurrent.ThreadLocalRandom;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={YarnJobConfiguration.class})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY)
@JsonSubTypes(value={@JsonSubTypes.Type(value=YarnJobConfiguration.class, name="YarnJobConfiguration")})
public abstract class JobConfiguration {
    protected String appName;
    protected ScheduleDTO schedule;
    protected KafkaDTO kafka;

    protected JobConfiguration() {
    }

    public JobConfiguration(String appname) {
        this.appName = appname;
    }

    public abstract JobType getJobType();

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public ScheduleDTO getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ScheduleDTO schedule) {
        this.schedule = schedule;
    }

    public KafkaDTO getKafka() {
        return this.kafka;
    }

    public void setKafka(KafkaDTO kafka) {
        this.kafka = kafka;
    }

    public final boolean equals(Object o) {
        return false;
    }

    public int hashCode() {
        return ThreadLocalRandom.current().nextInt(0, 1000000000);
    }

    public static class JobConfigurationFactory {
        public static JobConfiguration getJobConfigurationTemplate(JobType type) {
            JobConfiguration conf;
            switch (type) {
                case SPARK: 
                case PYSPARK: {
                    conf = new SparkJobConfiguration();
                    break;
                }
                case FLINK: {
                    conf = new FlinkJobConfiguration();
                    break;
                }
                case ERASURE_CODING: {
                    conf = new ErasureCodeJobConfiguration();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("The given JobType is not recognized by this factory.");
                }
            }
            return conf;
        }
    }
}

