/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hopsworks.common.jupyter;

import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsers;
import io.hops.hopsworks.common.dao.hdfsUser.HdfsUsersFacade;
import io.hops.hopsworks.common.dao.jupyter.JupyterProject;
import io.hops.hopsworks.common.dao.jupyter.JupyterSettings;
import io.hops.hopsworks.common.dao.jupyter.JupyterSettingsFacade;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterFacade;
import io.hops.hopsworks.common.dao.jupyter.config.JupyterManager;
import io.hops.hopsworks.common.dao.project.Project;
import io.hops.hopsworks.common.dao.project.team.ProjectTeamFacade;
import io.hops.hopsworks.common.dao.user.UserFacade;
import io.hops.hopsworks.common.dao.user.Users;
import io.hops.hopsworks.common.elastic.ElasticController;
import io.hops.hopsworks.common.hdfs.DistributedFileSystemOps;
import io.hops.hopsworks.common.hdfs.DistributedFsService;
import io.hops.hopsworks.common.hdfs.HdfsUsersController;
import io.hops.hopsworks.common.jobs.jobhistory.JobState;
import io.hops.hopsworks.common.jupyter.JupyterJWTManager;
import io.hops.hopsworks.common.jupyter.JupyterNbVCSController;
import io.hops.hopsworks.common.livy.LivyController;
import io.hops.hopsworks.common.livy.LivyMsg;
import io.hops.hopsworks.common.security.CertificateMaterializer;
import io.hops.hopsworks.common.util.HopsUtils;
import io.hops.hopsworks.common.util.OSProcessExecutor;
import io.hops.hopsworks.common.util.ProcessDescriptor;
import io.hops.hopsworks.common.util.ProcessResult;
import io.hops.hopsworks.common.util.Settings;
import io.hops.hopsworks.exceptions.ServiceException;
import io.hops.hopsworks.restutils.RESTCodes;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NEVER)
public class JupyterController {
    private static final Logger LOGGER = Logger.getLogger(JupyterController.class.getName());
    @EJB
    private OSProcessExecutor osProcessExecutor;
    @EJB
    private Settings settings;
    @EJB
    private LivyController livyController;
    @EJB
    private JupyterFacade jupyterFacade;
    @Inject
    private JupyterManager jupyterManager;
    @EJB
    private ElasticController elasticController;
    @EJB
    private CertificateMaterializer certificateMaterializer;
    @EJB
    private DistributedFsService dfsService;
    @EJB
    private ProjectTeamFacade projectTeamFacade;
    @EJB
    private HdfsUsersController hdfsUsersController;
    @EJB
    private UserFacade userFacade;
    @EJB
    private JupyterSettingsFacade jupyterSettingsFacade;
    @EJB
    private HdfsUsersFacade hdfsUsersFacade;
    @EJB
    private JupyterJWTManager jupyterJWTManager;
    @Inject
    private JupyterNbVCSController jupyterNbVCSController;

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void convertIPythonNotebook(String hdfsUsername, String notebookPath, Project project, String pyPath) throws ServiceException {
        String conversionDir = DigestUtils.sha256Hex((String)Integer.toString(ThreadLocalRandom.current().nextInt()));
        notebookPath = notebookPath.replace(" ", "\\ ");
        pyPath = pyPath.replace(" ", "\\ ");
        String prog = this.settings.getHopsworksDomainDir() + "/bin/convert-ipython-notebook.sh";
        ProcessDescriptor processDescriptor = new ProcessDescriptor.Builder().addCommand(prog).addCommand(notebookPath).addCommand(hdfsUsername).addCommand(this.settings.getAnacondaProjectDir(project)).addCommand(pyPath).addCommand(conversionDir).setWaitTimeout(60L, TimeUnit.SECONDS).build();
        LOGGER.log(Level.FINE, processDescriptor.toString());
        try {
            ProcessResult processResult = this.osProcessExecutor.execute(processDescriptor);
            if (!processResult.processExited() || processResult.getExitCode() != 0) {
                throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.SEVERE, "error code: " + processResult.getExitCode(), "Failed to convert " + notebookPath + "\nstderr: " + processResult.getStderr() + "\nstdout: " + processResult.getStdout());
            }
        }
        catch (IOException ex) {
            throw new ServiceException(RESTCodes.ServiceErrorCode.IPYTHON_CONVERT_ERROR, Level.SEVERE, null, ex.getMessage(), (Throwable)ex);
        }
    }

    public void shutdownOrphan(Long pid, Integer port) throws ServiceException {
        try {
            this.jupyterManager.stopOrphanedJupyterServer(pid, port);
        }
        finally {
            this.jupyterJWTManager.cleanJWT(pid, port);
        }
    }

    public void shutdownQuietly(Project project, String hdfsUser, Users user, String secret, long pid, int port) {
        try {
            this.shutdown(project, hdfsUser, user, secret, pid, port);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Encountered exception while cleaning up", e);
        }
        this.jupyterJWTManager.cleanJWT(pid, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(Project project, String hdfsUser, Users user, String secret, long pid, int port) throws ServiceException {
        DistributedFileSystemOps dfso;
        String[] project_user;
        List<LivyMsg.Session> sessions = this.livyController.getLivySessionsForProjectUser(project, user);
        for (int retries = 3; retries > 0 && this.livyController.getLivySessionsForProjectUser(project, user).size() > 0; --retries) {
            LOGGER.log(Level.SEVERE, "Failed previous attempt to delete livy sessions for project " + project.getName() + " user " + hdfsUser + ", retrying...");
            this.livyController.deleteAllLivySessions(hdfsUser);
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException ie) {
                LOGGER.log(Level.SEVERE, "Interrupted while sleeping");
            }
        }
        String jupyterHomePath = this.jupyterManager.getJupyterHome(this.settings, hdfsUser, project, secret);
        try {
            JupyterProject jupyterProject = this.jupyterFacade.findByUser(hdfsUser);
            JupyterSettings jupyterSettings = this.jupyterSettingsFacade.findByProjectUser(project.getId(), user.getEmail());
            if (jupyterProject != null && jupyterSettings != null && jupyterSettings.isGitBackend().booleanValue() && jupyterSettings.getGitConfig().getShutdownAutoPush().booleanValue()) {
                this.jupyterNbVCSController.commit(jupyterProject, user, "Auto-generated commit message due to Jupyter Notebook server shutdown");
                this.jupyterNbVCSController.push(jupyterProject);
            }
            this.jupyterManager.stopJupyterServer(project, user, hdfsUser, jupyterHomePath, pid, port);
            project_user = hdfsUser.split("__");
            dfso = this.dfsService.getDfsOps();
        }
        catch (Throwable throwable) {
            String[] project_user2 = hdfsUser.split("__");
            DistributedFileSystemOps dfso2 = this.dfsService.getDfsOps();
            try {
                String certificatesDir = Paths.get(jupyterHomePath, "certificates").toString();
                HopsUtils.cleanupCertificatesForUserCustomDir(project_user2[1], project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certificatesDir, this.settings);
                this.certificateMaterializer.removeCertificatesLocal(project_user2[1], project.getName());
            }
            finally {
                if (dfso2 != null) {
                    this.dfsService.closeDfsClient(dfso2);
                }
            }
            FileUtils.deleteQuietly((File)new File(jupyterHomePath));
            this.jupyterJWTManager.cleanJWT(pid, port);
            Iterator<LivyMsg.Session> iterator = sessions.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.livyController.deleteAllLivySessions(hdfsUser);
                    throw throwable;
                }
                LivyMsg.Session session = iterator.next();
                this.updateRunningExperimentAsKilled(project, session);
            }
        }
        try {
            String certificatesDir = Paths.get(jupyterHomePath, "certificates").toString();
            HopsUtils.cleanupCertificatesForUserCustomDir(project_user[1], project.getName(), this.settings.getHdfsTmpCertDir(), this.certificateMaterializer, certificatesDir, this.settings);
            this.certificateMaterializer.removeCertificatesLocal(project_user[1], project.getName());
        }
        finally {
            if (dfso != null) {
                this.dfsService.closeDfsClient(dfso);
            }
        }
        FileUtils.deleteQuietly((File)new File(jupyterHomePath));
        this.jupyterJWTManager.cleanJWT(pid, port);
        Iterator<LivyMsg.Session> iterator = sessions.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.livyController.deleteAllLivySessions(hdfsUser);
                return;
            }
            LivyMsg.Session session = iterator.next();
            this.updateRunningExperimentAsKilled(project, session);
        }
    }

    public void stopSession(Project project, Users user, String appId) {
        List<LivyMsg.Session> sessions = this.livyController.getLivySessionsForProjectUser(project, user);
        for (LivyMsg.Session session : sessions) {
            if (!session.getAppId().equalsIgnoreCase(appId)) continue;
            this.livyController.deleteLivySession(session.getId());
            this.updateRunningExperimentAsKilled(project, session);
            break;
        }
    }

    private void updateRunningExperimentAsKilled(Project project, LivyMsg.Session session) {
        try {
            String experimentsIndex = project.getName().toLowerCase() + "_" + "experiments";
            String sessionAppId = session.getAppId();
            String experiment = this.elasticController.findExperiment(experimentsIndex, sessionAppId);
            JSONObject json = new JSONObject(experiment);
            json = json.getJSONObject("hits");
            JSONArray hits = json.getJSONArray("hits");
            for (int i = 0; i < hits.length(); ++i) {
                JSONObject obj = (JSONObject)hits.get(i);
                JSONObject source = obj.getJSONObject("_source");
                String status = source.getString("status");
                if (!status.equalsIgnoreCase(JobState.RUNNING.name())) continue;
                source.put("status", (Object)"KILLED");
                this.elasticController.updateExperiment(experimentsIndex, obj.getString("_id"), source);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception while updating RUNNING status to KILLED on experiments", e);
        }
    }

    public void removeJupyter(Project project) throws ServiceException {
        for (JupyterProject jp : project.getJupyterProjectCollection()) {
            HdfsUsers hdfsUser = this.hdfsUsersFacade.findById(jp.getHdfsUserId());
            String username = this.hdfsUsersController.getUserName(hdfsUser.getName());
            Users user = this.userFacade.findByUsername(username);
            this.shutdown(project, hdfsUser.getName(), user, jp.getSecret(), jp.getPid(), jp.getPort());
        }
        this.jupyterManager.projectCleanup(project);
    }

    public JupyterSettings updateExpirationDate(Project project, Users user, JupyterSettings jupyterSettings) {
        JupyterSettings js = this.jupyterSettingsFacade.findByProjectUser(project.getId(), user.getEmail());
        js.setShutdownLevel(jupyterSettings.getShutdownLevel());
        this.jupyterSettingsFacade.update(js);
        String hdfsUser = this.hdfsUsersController.getHdfsUserName(project, user);
        JupyterProject jupyterProject = this.jupyterFacade.findByUser(hdfsUser);
        Date expirationDate = jupyterProject.getExpires();
        Calendar cal = Calendar.getInstance();
        cal.setTime(expirationDate);
        cal.add(11, jupyterSettings.getShutdownLevel());
        expirationDate = cal.getTime();
        jupyterProject.setExpires(expirationDate);
        this.jupyterFacade.update(jupyterProject);
        return jupyterSettings;
    }
}

